/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.object;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.photon.security.login.LoggedInUserManager;
import com.helger.tenancy.AbstractBusinessObject;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class BusinessObjectHelper {
    private BusinessObjectHelper() {
    }

    @Nonnull
    @Nonempty
    private static String _getUserID() {
        String string = LoggedInUserManager.getInstance().getCurrentUserID();
        if (StringHelper.hasNoText(string)) {
            string = "$GUEST$";
        }
        return string;
    }

    public static void setLastModificationNow(@Nonnull AbstractBusinessObject abstractBusinessObject) {
        abstractBusinessObject.setLastModification(PDTFactory.getCurrentLocalDateTime(), BusinessObjectHelper._getUserID());
    }

    @Nonnull
    public static EChange setDeletionNow(@Nonnull AbstractBusinessObject abstractBusinessObject) {
        return abstractBusinessObject.setDeletion(PDTFactory.getCurrentLocalDateTime(), BusinessObjectHelper._getUserID());
    }

    @Nonnull
    public static EChange setUndeletionNow(@Nonnull AbstractBusinessObject abstractBusinessObject) {
        return abstractBusinessObject.setUndeletion(PDTFactory.getCurrentLocalDateTime(), BusinessObjectHelper._getUserID());
    }
}

