/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.object.accarea;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.tenancy.AbstractBusinessObject;
import com.helger.tenancy.IBusinessObject;
import com.helger.tenancy.accarea.IAccountingArea;
import com.helger.tenancy.accarea.IAccountingAreaObject;
import com.helger.tenancy.tenant.ITenant;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public abstract class AbstractAccountingAreaObject
extends AbstractBusinessObject
implements IAccountingAreaObject {
    private final ITenant m_aTenant;
    private final IAccountingArea m_aAccountingArea;
    private transient int m_nHashCode = 0;

    protected AbstractAccountingAreaObject(@Nonnull IAccountingAreaObject iAccountingAreaObject) {
        super(iAccountingAreaObject);
        this.m_aTenant = iAccountingAreaObject.getTenant();
        this.m_aAccountingArea = iAccountingAreaObject.getAccountingArea();
    }

    public AbstractAccountingAreaObject(@Nonnull IAccountingArea iAccountingArea, @Nonnull IBusinessObject iBusinessObject) {
        this(iAccountingArea.getTenant(), iAccountingArea, iBusinessObject);
    }

    public AbstractAccountingAreaObject(@Nonnull ITenant iTenant, @Nonnull IAccountingArea iAccountingArea, @Nonnull IBusinessObject iBusinessObject) {
        super(iBusinessObject);
        ValueEnforcer.notNull(iTenant, "Tenant");
        ValueEnforcer.notNull(iAccountingArea, "AccountingArea");
        if (!iAccountingArea.hasSameTenant(iTenant)) {
            throw new IllegalArgumentException("The passed accounting area '" + (String)iAccountingArea.getID() + "' does not belong to the passed tenant '" + (String)iTenant.getID() + "'!");
        }
        this.m_aTenant = iTenant;
        this.m_aAccountingArea = iAccountingArea;
    }

    public AbstractAccountingAreaObject(@Nonnull ITenant iTenant, @Nonnull IAccountingArea iAccountingArea, @Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime, @Nullable String string2, @Nullable LocalDateTime localDateTime2, @Nullable String string3, @Nullable LocalDateTime localDateTime3, @Nullable String string4) {
        super(string, localDateTime, string2, localDateTime2, string3, localDateTime3, string4, null);
        ValueEnforcer.notNull(iTenant, "Tenant");
        ValueEnforcer.notNull(iAccountingArea, "AccountingArea");
        if (!iAccountingArea.hasSameTenant(iTenant)) {
            throw new IllegalArgumentException("The passed accounting area '" + (String)iAccountingArea.getID() + "' does not belong to the passed tenant '" + (String)iTenant.getID() + "'!");
        }
        this.m_aTenant = iTenant;
        this.m_aAccountingArea = iAccountingArea;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getTenantID() {
        return (String)this.m_aTenant.getID();
    }

    @Override
    @Nonnull
    public final ITenant getTenant() {
        return this.m_aTenant;
    }

    @Override
    @Nonnull
    @Nonempty
    public final String getAccountingAreaID() {
        return (String)this.m_aAccountingArea.getID();
    }

    @Override
    @Nonnull
    public final IAccountingArea getAccountingArea() {
        return this.m_aAccountingArea;
    }

    @Override
    public final boolean hasSameTenantAndAccountingAreaID(@Nullable IAccountingArea iAccountingArea) {
        return iAccountingArea != null && this.hasSameTenantID(iAccountingArea) && ((String)this.m_aAccountingArea.getID()).equals(iAccountingArea.getID());
    }

    @Override
    public final boolean hasSameTenantAndAccountingAreaID(@Nullable IAccountingAreaObject iAccountingAreaObject) {
        return iAccountingAreaObject != null && this.hasSameTenantID(iAccountingAreaObject) && ((String)this.m_aAccountingArea.getID()).equals(iAccountingAreaObject.getAccountingAreaID());
    }

    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractAccountingAreaObject abstractAccountingAreaObject = (AbstractAccountingAreaObject)object;
        return this.m_aTenant.equals(abstractAccountingAreaObject.m_aTenant) && this.m_aAccountingArea.equals(abstractAccountingAreaObject.m_aAccountingArea) && this.getID().equals(abstractAccountingAreaObject.getID());
    }

    @Override
    public final int hashCode() {
        int n = this.m_nHashCode;
        if (n == 0) {
            n = this.m_nHashCode = new HashCodeGenerator(this).append(this.m_aTenant).append(this.m_aAccountingArea).append(this.getID()).getHashCode();
        }
        return n;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("Tenant", this.m_aTenant).append("AccoutingArea", this.m_aAccountingArea).getToString();
    }
}

