/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.object.accarea;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.id.IHasID;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.dao.DAOException;
import com.helger.masterdata.address.IPostalAddress;
import com.helger.masterdata.currency.ECurrency;
import com.helger.photon.app.dao.AbstractPhotonMapBasedWALDAO;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.security.object.BusinessObjectHelper;
import com.helger.photon.security.object.accarea.AccountingArea;
import com.helger.tenancy.accarea.IAccountingArea;
import com.helger.tenancy.accarea.IAccountingAreaResolver;
import com.helger.tenancy.tenant.ITenant;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AccountingAreaManager
extends AbstractPhotonMapBasedWALDAO<IAccountingArea, AccountingArea>
implements IAccountingAreaResolver {
    public AccountingAreaManager(@Nonnull @Nonempty String string) throws DAOException {
        super(AccountingArea.class, string);
    }

    @Nonnull
    public IAccountingArea createAccountingArea(@Nonnull ITenant iTenant, @Nonnull @Nonempty String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nonnull IPostalAddress iPostalAddress, @Nonnull String string6, @Nullable String string7, @Nullable String string8, @Nullable String string9, @Nonnull ECurrency eCurrency, @Nullable String string10, @Nullable String string11, @Nullable String string12, @Nonnull Locale locale) {
        AccountingArea accountingArea = new AccountingArea(iTenant, string, string2, string3, string4, string5, iPostalAddress, string6, string7, string8, string9, eCurrency, string10, string11, string12, locale);
        this.m_aRWLock.writeLocked(() -> this.internalCreateItem(accountingArea));
        AuditHelper.onAuditCreateSuccess(AccountingArea.OT, accountingArea.getID(), string, string2, string3, string4, string5, iPostalAddress, string6, string7, string8, eCurrency, string10, string11, string12);
        return accountingArea;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange updateAccountingArea(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nonnull IPostalAddress iPostalAddress, @Nonnull String string7, @Nullable String string8, @Nullable String string9, @Nullable String string10, @Nonnull ECurrency eCurrency, @Nullable String string11, @Nullable String string12, @Nullable String string13, @Nonnull Locale locale) {
        AccountingArea accountingArea = (AccountingArea)this.getOfID(string);
        if (accountingArea == null) {
            AuditHelper.onAuditModifyFailure(AccountingArea.OT, string, "no-such-id");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.UNCHANGED;
            eChange = eChange.or(accountingArea.setDisplayName(string2));
            eChange = eChange.or(accountingArea.setCompanyType(string3));
            eChange = eChange.or(accountingArea.setCompanyVATIN(string4));
            eChange = eChange.or(accountingArea.setCompanyNumber(string5));
            eChange = eChange.or(accountingArea.setCustomerNumber(string6));
            eChange = eChange.or(accountingArea.setAddress(iPostalAddress, locale));
            eChange = eChange.or(accountingArea.setTelephone(string7));
            eChange = eChange.or(accountingArea.setFax(string8));
            eChange = eChange.or(accountingArea.setEmailAddress(string9));
            eChange = eChange.or(accountingArea.setWebSite(string10));
            eChange = eChange.or(accountingArea.setDefaultCurrency(eCurrency));
            eChange = eChange.or(accountingArea.setOfficeLocation(string11));
            eChange = eChange.or(accountingArea.setCommercialRegistrationNumber(string12));
            eChange = eChange.or(accountingArea.setCommercialCourt(string13));
            if (eChange.isUnchanged()) {
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            BusinessObjectHelper.setLastModificationNow(accountingArea);
            this.internalUpdateItem(accountingArea);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(AccountingArea.OT, "all", string, string2, string3, string4, string5, iPostalAddress, string7, string8, string9, eCurrency, string11, string12, string13);
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange deleteAccountingArea(@Nullable String string) {
        AccountingArea accountingArea = (AccountingArea)this.getOfID(string);
        if (accountingArea == null) {
            AuditHelper.onAuditDeleteFailure(AccountingArea.OT, "no-such-object-id", string);
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setDeletionNow(accountingArea).isUnchanged()) {
                AuditHelper.onAuditDeleteFailure(AccountingArea.OT, "already-deleted", string);
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalMarkItemDeleted(accountingArea);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess(AccountingArea.OT, string);
        return EChange.CHANGED;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IAccountingArea> getAllAccountingAreasOfTenant(@Nullable String string) {
        return this.getAll(iAccountingArea -> iAccountingArea.hasSameTenantID(string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IAccountingArea> getAllAccountingAreasOfTenant(@Nullable ITenant iTenant) {
        return this.getAll(iAccountingArea -> iAccountingArea.hasSameTenant(iTenant));
    }

    @Nonnegative
    public int getCountAccountingAreasOfTenant(@Nullable ITenant iTenant) {
        return this.getCount(iAccountingArea -> iAccountingArea.hasSameTenant(iTenant));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllAccountingAreaIDsOfTenant(@Nullable String string) {
        return this.getAllMapped(iAccountingArea -> iAccountingArea.hasSameTenantID(string), IHasID::getID);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllAccountingAreaIDsOfTenant(@Nullable ITenant iTenant) {
        return this.getAllMapped(iAccountingArea -> iAccountingArea.hasSameTenant(iTenant), IHasID::getID);
    }

    @Nonnegative
    public int getCountAccountingAreaIDsOfTenant(@Nullable ITenant iTenant) {
        return this.getCount(iAccountingArea -> iAccountingArea.hasSameTenant(iTenant));
    }

    @Override
    @Nullable
    public IAccountingArea getAccountingAreaOfID(@Nullable String string) {
        return (IAccountingArea)this.getOfID(string);
    }

    @Nullable
    public IAccountingArea getAccountingAreaOfID(@Nullable String string, @Nullable ITenant iTenant) {
        IAccountingArea iAccountingArea = this.getAccountingAreaOfID(string);
        return iAccountingArea != null && iAccountingArea.hasSameTenant(iTenant) ? iAccountingArea : null;
    }

    public boolean containsAccountingAreaWithID(@Nullable String string, @Nullable ITenant iTenant) {
        return this.getAccountingAreaOfID(string, iTenant) != null;
    }

    @Nullable
    public IAccountingArea getAccountingAreaOfName(@Nullable String string, @Nullable ITenant iTenant) {
        if (StringHelper.hasNoText(string) || iTenant == null) {
            return null;
        }
        return this.findFirst(iAccountingArea -> iAccountingArea.hasSameTenant(iTenant) && iAccountingArea.getDisplayName().equals(string));
    }
}

