/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.object.tenant;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ObjectType;
import com.helger.photon.security.object.StubObject;
import com.helger.tenancy.AbstractBusinessObject;
import com.helger.tenancy.tenant.ITenant;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class Tenant
extends AbstractBusinessObject
implements ITenant {
    public static final ObjectType OT = new ObjectType("tenant");
    private String m_sDisplayName;

    public Tenant(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        this(StubObject.createForCurrentUserAndID(string), string2);
    }

    Tenant(@Nonnull StubObject stubObject, @Nonnull @Nonempty String string) {
        super(stubObject);
        this.setDisplayName(string);
    }

    @Override
    @Nonnull
    public ObjectType getObjectType() {
        return OT;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_sDisplayName;
    }

    @Nonnull
    public EChange setDisplayName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "DisplayName");
        if (string.equals(this.m_sDisplayName)) {
            return EChange.UNCHANGED;
        }
        this.m_sDisplayName = string;
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsUIText(Locale locale) {
        return this.getID() + " - " + this.m_sDisplayName;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("DisplayName", this.m_sDisplayName).getToString();
    }
}

