/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.object.tenant;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.state.EChange;
import com.helger.dao.DAOException;
import com.helger.photon.app.dao.AbstractPhotonMapBasedWALDAO;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.security.object.BusinessObjectHelper;
import com.helger.photon.security.object.tenant.Tenant;
import com.helger.tenancy.tenant.ITenant;
import com.helger.tenancy.tenant.ITenantResolver;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TenantManager
extends AbstractPhotonMapBasedWALDAO<ITenant, Tenant>
implements ITenantResolver {
    public TenantManager(@Nonnull @Nonempty String string) throws DAOException {
        super(Tenant.class, string);
    }

    @Override
    @Nonnull
    protected EChange onInit() {
        this.internalCreateItem(new Tenant("$", "$system tenant$"));
        return EChange.CHANGED;
    }

    @Nullable
    public ITenant createTenant(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        if (this.containsWithID(string)) {
            return null;
        }
        Tenant tenant = new Tenant(string, string2);
        this.m_aRWLock.writeLocked(() -> this.internalCreateItem(tenant));
        AuditHelper.onAuditCreateSuccess(Tenant.OT, tenant.getID(), string2);
        return tenant;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange updateTenant(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        Tenant tenant = (Tenant)this.getOfID(string);
        if (tenant == null) {
            AuditHelper.onAuditModifyFailure(Tenant.OT, string, "no-such-id");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.UNCHANGED;
            eChange = eChange.or(tenant.setDisplayName(string2));
            if (eChange.isUnchanged()) {
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            BusinessObjectHelper.setLastModificationNow(tenant);
            this.internalUpdateItem(tenant);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(Tenant.OT, "all", string, string2);
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public EChange deleteTenant(@Nullable String string) {
        Tenant tenant = (Tenant)this.getOfID(string);
        if (tenant == null) {
            AuditHelper.onAuditDeleteFailure(Tenant.OT, "no-such-object-id", string);
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setDeletionNow(tenant).isUnchanged()) {
                AuditHelper.onAuditDeleteFailure(Tenant.OT, "already-deleted", string);
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalMarkItemDeleted(tenant);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess(Tenant.OT, string);
        return EChange.CHANGED;
    }

    public boolean containsAnyExceptGlobal() {
        return this.containsAny(iTenant -> !iTenant.isGlobalTenant());
    }

    @Override
    @Nullable
    public ITenant getTenantOfID(@Nullable String string) {
        return (ITenant)this.getOfID(string);
    }
}

