/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.password;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.ServiceLoaderHelper;
import com.helger.photon.security.password.constraint.IPasswordConstraintList;
import com.helger.photon.security.password.constraint.PasswordConstraintList;
import com.helger.photon.security.password.hash.IPasswordHashCreatorRegistrarSPI;
import com.helger.photon.security.password.hash.PasswordHashCreatorManager;
import com.helger.security.password.hash.PasswordHash;
import com.helger.security.password.hash.PasswordHashCreatorPBKDF2_1000_48;
import com.helger.security.password.hash.PasswordHashCreatorSHA512;
import com.helger.security.password.salt.IPasswordSalt;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class GlobalPasswordSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(GlobalPasswordSettings.class);
    private static final SimpleReadWriteLock s_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="s_aRWLock")
    private static IPasswordConstraintList s_aPasswordConstraintList = new PasswordConstraintList();
    private static final PasswordHashCreatorManager s_aPHCMgr = new PasswordHashCreatorManager();
    private static final GlobalPasswordSettings s_aInstance;

    private GlobalPasswordSettings() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static IPasswordConstraintList getPasswordConstraintList() {
        return s_aRWLock.readLockedGet(s_aPasswordConstraintList::getClone);
    }

    public static void setPasswordConstraintList(@Nonnull IPasswordConstraintList iPasswordConstraintList) {
        ValueEnforcer.notNull(iPasswordConstraintList, "PasswordConstraintList");
        IPasswordConstraintList iPasswordConstraintList2 = (IPasswordConstraintList)iPasswordConstraintList.getClone();
        s_aRWLock.writeLocked(() -> {
            s_aPasswordConstraintList = iPasswordConstraintList2;
        });
        LOGGER.info("Set global password constraints to " + iPasswordConstraintList2);
    }

    public static boolean isAnyPasswordConstraintDefined() {
        return GlobalPasswordSettings.getPasswordConstraintList().hasConstraints();
    }

    @Nonnull
    public static PasswordHashCreatorManager getPasswordHashCreatorManager() {
        return s_aPHCMgr;
    }

    @Nonnull
    public static PasswordHash createUserDefaultPasswordHash(@Nullable IPasswordSalt iPasswordSalt, @Nonnull String string) {
        return s_aPHCMgr.createUserDefaultPasswordHash(iPasswordSalt, string);
    }

    @Nonnull
    public static PasswordHash createUserPasswordHash(@Nonnull @Nonempty String string, @Nullable IPasswordSalt iPasswordSalt, @Nonnull String string2) {
        return s_aPHCMgr.createUserPasswordHash(string, iPasswordSalt, string2);
    }

    static {
        s_aPHCMgr.registerPasswordHashCreator(new PasswordHashCreatorSHA512());
        s_aPHCMgr.registerPasswordHashCreator(new PasswordHashCreatorPBKDF2_1000_48());
        s_aPHCMgr.setDefaultPasswordHashCreatorAlgorithm("PBKDF2_1000_48");
        for (IPasswordHashCreatorRegistrarSPI iPasswordHashCreatorRegistrarSPI : ServiceLoaderHelper.getAllSPIImplementations(IPasswordHashCreatorRegistrarSPI.class)) {
            iPasswordHashCreatorRegistrarSPI.registerPasswordHashCreators(s_aPHCMgr);
        }
        s_aInstance = new GlobalPasswordSettings();
    }
}

