/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.password.constraint;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.security.password.constraint.EPasswordConstraintText;
import com.helger.photon.security.password.constraint.IPasswordConstraint;
import com.helger.xml.microdom.IMicroElement;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PasswordConstraintMinLength
implements IPasswordConstraint {
    private static final String ATTR_MIN_LENGTH = "minlength";
    private final int m_nMinLength;

    public PasswordConstraintMinLength(@Nonnegative int n) {
        this.m_nMinLength = ValueEnforcer.isGT0(n, "MinLength");
    }

    @Nonnegative
    public int getMinLength() {
        return this.m_nMinLength;
    }

    @Override
    public boolean isPasswordValid(@Nullable String string) {
        return StringHelper.getLength(string) >= this.m_nMinLength;
    }

    @Override
    @Nullable
    public String getDescription(@Nonnull Locale locale) {
        return EPasswordConstraintText.DESC_MIN_LENGTH.getDisplayTextWithArgs(locale, this.m_nMinLength);
    }

    @Override
    public void fillMicroElement(@Nonnull IMicroElement iMicroElement) {
        iMicroElement.setAttribute(ATTR_MIN_LENGTH, this.m_nMinLength);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PasswordConstraintMinLength passwordConstraintMinLength = (PasswordConstraintMinLength)object;
        return this.m_nMinLength == passwordConstraintMinLength.m_nMinLength;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nMinLength).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("minLength", this.m_nMinLength).getToString();
    }
}

