/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.password.constraint;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.security.password.constraint.EPasswordConstraintText;
import com.helger.photon.security.password.constraint.IPasswordConstraint;
import com.helger.xml.microdom.IMicroElement;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PasswordConstraintMustContainLetterLowerCase
implements IPasswordConstraint {
    private static final String ATTR_MIN_LETTERS_LOWERCASE = "minletters_lowercase";
    private final int m_nMinLetters;

    public PasswordConstraintMustContainLetterLowerCase(@Nonnegative int n) {
        this.m_nMinLetters = ValueEnforcer.isGT0(n, "MinLetters");
    }

    @Nonnegative
    public int getMinLetters() {
        return this.m_nMinLetters;
    }

    @Override
    public boolean isPasswordValid(@Nullable String string) {
        int n = 0;
        if (string != null) {
            for (char c : string.toCharArray()) {
                if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
                ++n;
            }
        }
        return n >= this.m_nMinLetters;
    }

    @Override
    @Nullable
    public String getDescription(@Nonnull Locale locale) {
        return EPasswordConstraintText.DESC_MUST_CONTAIN_LETTERS_LOWERCASE.getDisplayTextWithArgs(locale, this.m_nMinLetters);
    }

    @Override
    public void fillMicroElement(@Nonnull IMicroElement iMicroElement) {
        iMicroElement.setAttribute(ATTR_MIN_LETTERS_LOWERCASE, this.m_nMinLetters);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        PasswordConstraintMustContainLetterLowerCase passwordConstraintMustContainLetterLowerCase = (PasswordConstraintMustContainLetterLowerCase)object;
        return this.m_nMinLetters == passwordConstraintMustContainLetterLowerCase.m_nMinLetters;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nMinLetters).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("minLetters", this.m_nMinLetters).getToString();
    }
}

