/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.role;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.state.EChange;
import com.helger.dao.DAOException;
import com.helger.photon.app.dao.AbstractPhotonMapBasedWALDAO;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.security.object.BusinessObjectHelper;
import com.helger.photon.security.object.StubObject;
import com.helger.photon.security.role.IRole;
import com.helger.photon.security.role.IRoleManager;
import com.helger.photon.security.role.IRoleModificationCallback;
import com.helger.photon.security.role.Role;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class RoleManager
extends AbstractPhotonMapBasedWALDAO<IRole, Role>
implements IRoleManager {
    private final CallbackList<IRoleModificationCallback> m_aCallbacks = new CallbackList();

    public RoleManager(@Nonnull @Nonempty String string) throws DAOException {
        super(Role.class, string);
    }

    @Override
    public void createDefaults() {
        if (!this.containsWithID("radmin")) {
            this.internalCreateItem(new Role(StubObject.createForCurrentUserAndID("radmin"), "Administrator", (String)null));
        }
        if (!this.containsWithID("ruser")) {
            this.internalCreateItem(new Role(StubObject.createForCurrentUserAndID("ruser"), "User", (String)null));
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IRoleModificationCallback> roleModificationCallbacks() {
        return this.m_aCallbacks;
    }

    @Override
    @Nonnull
    public IRole createNewRole(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable Map<String, String> map) {
        Role role = new Role(string, string2, map);
        this.m_aRWLock.writeLocked(() -> this.internalCreateItem(role));
        AuditHelper.onAuditCreateSuccess(Role.OT, role.getID(), string);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iRoleModificationCallback) -> iRoleModificationCallback.onRoleCreated(role, false));
        return role;
    }

    @Override
    @Nonnull
    public IRole createPredefinedRole(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nullable Map<String, String> map) {
        Role role = new Role(StubObject.createForCurrentUserAndID(string, map), string2, string3);
        this.m_aRWLock.writeLocked(() -> this.internalCreateItem(role));
        AuditHelper.onAuditCreateSuccess(Role.OT, role.getID(), "predefind-role", string2);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iRoleModificationCallback) -> iRoleModificationCallback.onRoleCreated(role, true));
        return role;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange deleteRole(@Nullable String string) {
        Role role;
        this.m_aRWLock.writeLock().lock();
        try {
            role = (Role)this.internalDeleteItem(string);
            if (role == null) {
                AuditHelper.onAuditDeleteFailure(Role.OT, "no-such-role-id", string);
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setDeletionNow(role);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess(Role.OT, string);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iRoleModificationCallback) -> iRoleModificationCallback.onRoleDeleted(role));
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public IRole getRoleOfID(@Nullable String string) {
        return (IRole)this.getOfID(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange renameRole(@Nullable String string, @Nonnull @Nonempty String string2) {
        Role role = (Role)this.getOfID(string);
        if (role == null) {
            AuditHelper.onAuditModifyFailure(Role.OT, string, "no-such-id");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (role.setName(string2).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setLastModificationNow(role);
            this.internalUpdateItem(role);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(Role.OT, "name", string, string2);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iRoleModificationCallback) -> iRoleModificationCallback.onRoleRenamed(role));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange setRoleData(@Nullable String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nullable Map<String, String> map) {
        Role role = (Role)this.getOfID(string);
        if (role == null) {
            AuditHelper.onAuditModifyFailure(Role.OT, string, "no-such-role-id");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = role.setName(string2);
            eChange = eChange.or(role.setDescription(string3));
            eChange = eChange.or(role.attrs().setAll(map));
            if (eChange.isUnchanged()) {
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            BusinessObjectHelper.setLastModificationNow(role);
            this.internalUpdateItem(role);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(Role.OT, "all", role.getID(), string2, string3, map);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iRoleModificationCallback) -> iRoleModificationCallback.onRoleUpdated(role));
        return EChange.CHANGED;
    }
}

