/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.role;

import com.helger.commons.string.StringHelper;
import com.helger.photon.security.object.AbstractBusinessObjectMicroTypeConverter;
import com.helger.photon.security.role.Role;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.util.MicroHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class RoleMicroTypeConverter
extends AbstractBusinessObjectMicroTypeConverter<Role> {
    private static final String ATTR_NAME = "name";
    private static final String ELEMENT_DESCRIPTION = "description";

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull Role role, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        RoleMicroTypeConverter.setObjectFields(role, microElement);
        microElement.setAttribute(ATTR_NAME, role.getName());
        if (StringHelper.hasText(role.getDescription())) {
            microElement.appendElement(string, ELEMENT_DESCRIPTION).appendText(role.getDescription());
        }
        return microElement;
    }

    @Override
    @Nonnull
    public Role convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = iMicroElement.getAttributeValue(ATTR_NAME);
        String string2 = MicroHelper.getChildTextContentTrimmed(iMicroElement, ELEMENT_DESCRIPTION);
        return new Role(RoleMicroTypeConverter.getStubObject(iMicroElement), string, string2);
    }
}

