/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.token.accesstoken;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.base64.Base64;
import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.string.StringHelper;
import com.helger.photon.security.token.accesstoken.IAccessToken;
import com.helger.photon.security.token.revocation.RevocationStatus;
import java.time.LocalDateTime;
import java.util.Random;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class AccessToken
implements IAccessToken {
    private final String m_sTokenString;
    private final LocalDateTime m_aNotBefore;
    private LocalDateTime m_aNotAfter;
    private final RevocationStatus m_aRevocationStatus;

    AccessToken(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime, @Nullable LocalDateTime localDateTime2, @Nonnull RevocationStatus revocationStatus) {
        this.m_sTokenString = ValueEnforcer.notEmpty(string, "TokenString");
        this.m_aNotBefore = ValueEnforcer.notNull(localDateTime, "NotBefore");
        if (localDateTime2 != null) {
            this.setNotAfter(localDateTime2);
        }
        this.m_aRevocationStatus = ValueEnforcer.notNull(revocationStatus, "RevocationStatus");
    }

    @Override
    @Nonnull
    @Nonempty
    public String getTokenString() {
        return this.m_sTokenString;
    }

    @Override
    @Nonnull
    public LocalDateTime getNotBefore() {
        return this.m_aNotBefore;
    }

    @Override
    @Nullable
    public LocalDateTime getNotAfter() {
        return this.m_aNotAfter;
    }

    public void setNotAfter(@Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull(localDateTime, "NotAfter");
        if (localDateTime.isBefore(this.m_aNotBefore)) {
            throw new IllegalArgumentException("Not after date (" + localDateTime + ") must be >= not before date (" + this.m_aNotBefore + ")");
        }
        this.m_aNotAfter = localDateTime;
    }

    @Override
    public boolean isValidAt(@Nonnull LocalDateTime localDateTime) {
        ValueEnforcer.notNull(localDateTime, "DateTime");
        if (localDateTime.isBefore(this.m_aNotBefore)) {
            return false;
        }
        return this.m_aNotAfter == null || !localDateTime.isAfter(this.m_aNotAfter);
    }

    @Override
    @Nonnull
    public RevocationStatus getRevocationStatus() {
        return this.m_aRevocationStatus;
    }

    public void markRevoked(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string2) {
        this.m_aRevocationStatus.markRevoked(string, localDateTime, string2);
    }

    @Nonnull
    @Nonempty
    public static String createNewTokenString(@Nonnegative int n) {
        byte[] byArray = new byte[n];
        new Random().nextBytes(byArray);
        return Base64.encodeBytes(byArray);
    }

    @Nonnull
    public static AccessToken createNewAccessTokenValidFromNow() {
        return AccessToken.createAccessTokenValidFromNow(null);
    }

    @Nonnull
    public static AccessToken createAccessTokenValidFromNow(@Nullable String string) {
        String string2 = StringHelper.hasText(string) ? string : AccessToken.createNewTokenString(66);
        return new AccessToken(string2, PDTFactory.getCurrentLocalDateTime(), null, new RevocationStatus());
    }
}

