/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.token.object;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.security.token.accesstoken.AccessToken;
import com.helger.photon.security.token.accesstoken.IAccessToken;
import com.helger.photon.security.token.object.IObjectWithAccessToken;
import com.helger.tenancy.AbstractBusinessObject;
import com.helger.tenancy.IBusinessObject;
import java.time.LocalDateTime;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractObjectWithAccessToken
extends AbstractBusinessObject
implements IObjectWithAccessToken {
    private final ICommonsList<AccessToken> m_aAccessTokens;
    private AccessToken m_aActiveAccessToken;

    @Nullable
    protected static AccessToken _getIfNotRevoked(@Nullable AccessToken accessToken) {
        return accessToken != null && !accessToken.isRevoked() ? accessToken : null;
    }

    public AbstractObjectWithAccessToken(@Nonnull IBusinessObject iBusinessObject, @Nonnull @Nonempty List<AccessToken> list) {
        super(iBusinessObject);
        ValueEnforcer.notEmptyNoNullValue(list, "AccessTokens");
        this.m_aAccessTokens = new CommonsArrayList<List<AccessToken>>(list);
        this.m_aActiveAccessToken = AbstractObjectWithAccessToken._getIfNotRevoked(CollectionHelper.getLastElement(list));
    }

    @Nonnull
    @Nonempty
    public ICommonsList<AccessToken> getAllAccessTokens() {
        return (ICommonsList)this.m_aAccessTokens.getClone();
    }

    @Override
    @Nullable
    public IAccessToken findFirstAccessToken(@Nullable Predicate<? super IAccessToken> predicate) {
        return this.m_aAccessTokens.findFirst(predicate);
    }

    @Override
    @Nullable
    public IAccessToken getActiveAccessToken() {
        return this.m_aActiveAccessToken;
    }

    @Nonnull
    public EChange revokeActiveAccessToken(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string2) {
        if (this.m_aActiveAccessToken == null) {
            return EChange.UNCHANGED;
        }
        this.m_aActiveAccessToken.markRevoked(string, localDateTime, string2);
        this.m_aActiveAccessToken.setNotAfter(localDateTime);
        this.m_aActiveAccessToken = null;
        return EChange.CHANGED;
    }

    @Nonnull
    public AccessToken createNewAccessToken(@Nullable String string) {
        if (this.m_aActiveAccessToken != null) {
            throw new IllegalStateException("You need to revoke the previous access token before creating a new one!");
        }
        AccessToken accessToken = AccessToken.createAccessTokenValidFromNow(string);
        this.m_aAccessTokens.add(accessToken);
        this.m_aActiveAccessToken = accessToken;
        return accessToken;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("AccessTokens", this.m_aAccessTokens).append("ActiveAccessToken", this.m_aActiveAccessToken).getToString();
    }
}

