/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.token.revocation;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.photon.security.token.revocation.IRevocationStatus;
import java.time.LocalDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class RevocationStatus
implements IRevocationStatus {
    private boolean m_bRevoked;
    private String m_sRevocationUserID;
    private LocalDateTime m_aRevocationDT;
    private String m_sRevocationReason;

    public RevocationStatus() {
        this(false, null, null, null);
    }

    RevocationStatus(boolean bl, @Nullable String string, @Nullable LocalDateTime localDateTime, @Nullable String string2) {
        if (bl) {
            ValueEnforcer.notEmpty(string, "RevocationUserID");
            ValueEnforcer.notNull(localDateTime, "RevocationDT");
            ValueEnforcer.notEmpty(string2, "RevocationReason");
        }
        this.m_bRevoked = bl;
        this.m_sRevocationUserID = string;
        this.m_aRevocationDT = localDateTime;
        this.m_sRevocationReason = string2;
    }

    @Override
    public boolean isRevoked() {
        return this.m_bRevoked;
    }

    @Override
    public String getRevocationUserID() {
        return this.m_sRevocationUserID;
    }

    @Override
    public LocalDateTime getRevocationDateTime() {
        return this.m_aRevocationDT;
    }

    @Override
    public String getRevocationReason() {
        return this.m_sRevocationReason;
    }

    public void markRevoked(@Nonnull @Nonempty String string, @Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string2) {
        ValueEnforcer.notEmpty(string, "RevocationUserID");
        ValueEnforcer.notNull(localDateTime, "RevocationDT");
        ValueEnforcer.notEmpty(string2, "RevocationReason");
        if (this.m_bRevoked) {
            throw new IllegalStateException("This object is already revoked!");
        }
        this.m_bRevoked = true;
        this.m_sRevocationUserID = string;
        this.m_aRevocationDT = localDateTime;
        this.m_sRevocationReason = string2;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        RevocationStatus revocationStatus = (RevocationStatus)object;
        return this.m_bRevoked == revocationStatus.m_bRevoked && EqualsHelper.equals(this.m_sRevocationUserID, revocationStatus.m_sRevocationUserID) && EqualsHelper.equals(this.m_aRevocationDT, revocationStatus.m_aRevocationDT) && EqualsHelper.equals(this.m_sRevocationReason, revocationStatus.m_sRevocationReason);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_bRevoked).append(this.m_sRevocationUserID).append(this.m_aRevocationDT).append(this.m_sRevocationReason).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("revoked", this.m_bRevoked).appendIfNotNull("RevocationUserID", this.m_sRevocationUserID).appendIfNotNull("RevocationDT", this.m_aRevocationDT).appendIfNotNull("RevocationReason", this.m_sRevocationReason).getToString();
    }
}

