/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.token.user;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ObjectType;
import com.helger.photon.security.object.StubObject;
import com.helger.photon.security.token.accesstoken.AccessToken;
import com.helger.photon.security.token.object.AbstractObjectWithAccessToken;
import com.helger.photon.security.token.user.IUserToken;
import com.helger.photon.security.user.IUser;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserToken
extends AbstractObjectWithAccessToken
implements IUserToken {
    public static final ObjectType OT = new ObjectType("usertoken");
    private final IUser m_aUser;

    public UserToken(@Nullable String string, @Nullable Map<String, String> map, @Nonnull IUser iUser) {
        this(StubObject.createForCurrentUser(map), new CommonsArrayList<AccessToken>(AccessToken.createAccessTokenValidFromNow(string)), iUser);
    }

    UserToken(@Nonnull StubObject stubObject, @Nonnull @Nonempty List<AccessToken> list, @Nonnull IUser iUser) {
        super(stubObject, list);
        this.m_aUser = ValueEnforcer.notNull(iUser, "User");
    }

    @Override
    @Nonnull
    public ObjectType getObjectType() {
        return OT;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getDisplayName() {
        return this.m_aUser.getDisplayName();
    }

    @Override
    @Nonnull
    public IUser getUser() {
        return this.m_aUser;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("User", this.m_aUser).getToString();
    }
}

