/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.token.user;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.dao.DAOException;
import com.helger.photon.app.dao.AbstractPhotonMapBasedWALDAO;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.security.object.BusinessObjectHelper;
import com.helger.photon.security.token.accesstoken.AccessToken;
import com.helger.photon.security.token.user.IUserToken;
import com.helger.photon.security.token.user.IUserTokenManager;
import com.helger.photon.security.token.user.IUserTokenModificationCallback;
import com.helger.photon.security.token.user.UserToken;
import com.helger.photon.security.user.IUser;
import java.time.LocalDateTime;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class UserTokenManager
extends AbstractPhotonMapBasedWALDAO<IUserToken, UserToken>
implements IUserTokenManager {
    private final CallbackList<IUserTokenModificationCallback> m_aCallbacks = new CallbackList();

    public UserTokenManager(@Nonnull @Nonempty String string) throws DAOException {
        super(UserToken.class, string);
    }

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IUserTokenModificationCallback> userTokenModificationCallbacks() {
        return this.m_aCallbacks;
    }

    @Override
    @Nonnull
    public UserToken createUserToken(@Nullable String string, @Nullable Map<String, String> map, @Nonnull IUser iUser) {
        UserToken userToken = new UserToken(string, map, iUser);
        this.m_aRWLock.writeLocked(() -> this.internalCreateItem(userToken));
        AuditHelper.onAuditCreateSuccess(UserToken.OT, userToken.getID(), map, iUser.getID());
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserTokenModificationCallback) -> iUserTokenModificationCallback.onUserTokenCreated(userToken));
        return userToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange updateUserToken(@Nullable String string, @Nullable Map<String, String> map) {
        UserToken userToken = (UserToken)this.getOfID(string);
        if (userToken == null) {
            AuditHelper.onAuditModifyFailure(UserToken.OT, string, "no-such-id");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = EChange.UNCHANGED;
            eChange = eChange.or(userToken.attrs().setAll(map));
            if (eChange.isUnchanged()) {
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            BusinessObjectHelper.setLastModificationNow(userToken);
            this.internalUpdateItem(userToken);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(UserToken.OT, string, map);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserTokenModificationCallback) -> iUserTokenModificationCallback.onUserTokenUpdated(userToken));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange deleteUserToken(@Nullable String string) {
        UserToken userToken = (UserToken)this.getOfID(string);
        if (userToken == null) {
            AuditHelper.onAuditDeleteFailure(UserToken.OT, "no-such-id", string);
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setDeletionNow(userToken).isUnchanged()) {
                AuditHelper.onAuditDeleteFailure(UserToken.OT, "already-deleted", userToken.getID());
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalMarkItemDeleted(userToken);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess(UserToken.OT, userToken.getID());
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserTokenModificationCallback) -> iUserTokenModificationCallback.onUserTokenDeleted(userToken));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange createNewAccessToken(@Nullable String string, @Nonnull @Nonempty String string2, @Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string3, @Nullable String string4) {
        AccessToken accessToken;
        UserToken userToken = (UserToken)this.getOfID(string);
        if (userToken == null) {
            AuditHelper.onAuditModifyFailure(UserToken.OT, "no-such-id", string);
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            userToken.revokeActiveAccessToken(string2, localDateTime, string3);
            accessToken = userToken.createNewAccessToken(string4);
            BusinessObjectHelper.setLastModificationNow(userToken);
            this.internalUpdateItem(userToken);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(UserToken.OT, "create-new-access-token", userToken.getID(), string2, localDateTime, string3, string4);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserTokenModificationCallback) -> iUserTokenModificationCallback.onUserTokenCreateAccessToken(userToken, accessToken));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange revokeAccessToken(@Nullable String string, @Nonnull @Nonempty String string2, @Nonnull LocalDateTime localDateTime, @Nonnull @Nonempty String string3) {
        UserToken userToken = (UserToken)this.getOfID(string);
        if (userToken == null) {
            AuditHelper.onAuditModifyFailure(UserToken.OT, "no-such-id", string);
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (userToken.revokeActiveAccessToken(string2, localDateTime, string3).isUnchanged()) {
                AuditHelper.onAuditModifyFailure(UserToken.OT, "already-revoked", string);
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setLastModificationNow(userToken);
            this.internalUpdateItem(userToken);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(UserToken.OT, "revoke-access-token", userToken.getID(), string2, localDateTime, string3);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserTokenModificationCallback) -> iUserTokenModificationCallback.onUserTokenRevokeAccessToken(userToken));
        return EChange.CHANGED;
    }

    @Override
    public ICommonsList<IUserToken> getAllActiveUserTokens() {
        return this.getAll(iUserToken -> !iUserToken.isDeleted());
    }

    @Override
    @Nullable
    public IUserToken getUserTokenOfID(@Nullable String string) {
        return (IUserToken)this.getOfID(string);
    }

    @Override
    @Nullable
    public IUserToken getUserTokenOfTokenString(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return this.findFirst(iUserToken -> string.equals(iUserToken.getActiveTokenString()));
    }

    @Override
    public boolean isAccessTokenUsed(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        return this.containsAny(iUserToken -> iUserToken.findFirstAccessToken(iAccessToken -> iAccessToken.getTokenString().equals(string)) != null);
    }
}

