/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.token.user;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.photon.security.mgr.PhotonSecurityManager;
import com.helger.photon.security.object.AbstractBusinessObjectMicroTypeConverter;
import com.helger.photon.security.token.accesstoken.AccessToken;
import com.helger.photon.security.token.accesstoken.IAccessToken;
import com.helger.photon.security.token.user.UserToken;
import com.helger.photon.security.user.IUser;
import com.helger.photon.security.user.IUserManager;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.convert.MicroTypeConverter;
import java.io.Serializable;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class UserTokenMicroTypeConverter
extends AbstractBusinessObjectMicroTypeConverter<UserToken> {
    private static final String ELEMENT_ACCESS_TOKEN = "accesstoken";
    private static final String ATTR_USER_ID = "userid";

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull UserToken userToken, @Nullable String string, @Nonnull @Nonempty String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        UserTokenMicroTypeConverter.setObjectFields(userToken, microElement);
        for (IAccessToken iAccessToken : userToken.getAllAccessTokens()) {
            microElement.appendChild(MicroTypeConverter.convertToMicroElement(iAccessToken, string, ELEMENT_ACCESS_TOKEN));
        }
        microElement.setAttribute(ATTR_USER_ID, (String)userToken.getUser().getID());
        return microElement;
    }

    @Override
    @Nonnull
    public UserToken convertToNative(@Nonnull IMicroElement iMicroElement) {
        Serializable serializable2;
        IUserManager iUserManager = PhotonSecurityManager.getUserMgr();
        CommonsArrayList<AccessToken> commonsArrayList = new CommonsArrayList<AccessToken>();
        for (Serializable serializable2 : iMicroElement.getAllChildElements(ELEMENT_ACCESS_TOKEN)) {
            commonsArrayList.add(MicroTypeConverter.convertToNative(serializable2, AccessToken.class));
        }
        String string = iMicroElement.getAttributeValue(ATTR_USER_ID);
        serializable2 = iUserManager.getUserOfID(string);
        if (serializable2 == null) {
            throw new IllegalStateException("Failed to resolve user with ID '" + (String)string + "'");
        }
        return new UserToken(UserTokenMicroTypeConverter.getStubObject(iMicroElement), commonsArrayList, (IUser)serializable2);
    }
}

