/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.user;

import com.helger.commons.annotation.MustImplementEqualsAndHashcode;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.string.StringHelper;
import com.helger.commons.text.IHasDescription;
import com.helger.security.authentication.subject.IAuthSubject;
import com.helger.security.password.hash.PasswordHash;
import com.helger.tenancy.IBusinessObject;
import java.time.LocalDateTime;
import java.util.Locale;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@MustImplementEqualsAndHashcode
public interface IUser
extends IBusinessObject,
IHasDescription,
IAuthSubject {
    public boolean isAdministrator();

    @Nonnull
    @Nonempty
    public String getLoginName();

    @Nullable
    public String getEmailAddress();

    @Nonnull
    public PasswordHash getPasswordHash();

    @Nullable
    public String getFirstName();

    default public boolean hasFirstName() {
        return StringHelper.hasText(this.getFirstName());
    }

    @Nullable
    public String getLastName();

    default public boolean hasLastName() {
        return StringHelper.hasText(this.getLastName());
    }

    @Override
    @Nonnull
    default public String getDisplayName() {
        return StringHelper.getConcatenatedOnDemand(this.getFirstName(), " ", this.getLastName());
    }

    @Nullable
    public Locale getDesiredLocale();

    @Nullable
    public LocalDateTime getLastLoginDateTime();

    @Nonnegative
    public int getLoginCount();

    @Nonnegative
    public int getConsecutiveFailedLoginCount();

    default public boolean isEnabled() {
        return !this.isDisabled();
    }

    public boolean isDisabled();
}

