/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.user;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.dao.DAOException;
import com.helger.photon.app.dao.AbstractPhotonMapBasedWALDAO;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.security.object.BusinessObjectHelper;
import com.helger.photon.security.password.GlobalPasswordSettings;
import com.helger.photon.security.user.IUser;
import com.helger.photon.security.user.IUserManager;
import com.helger.photon.security.user.IUserModificationCallback;
import com.helger.photon.security.user.User;
import com.helger.security.password.hash.PasswordHash;
import com.helger.security.password.salt.PasswordSalt;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class UserManager
extends AbstractPhotonMapBasedWALDAO<IUser, User>
implements IUserManager {
    private final CallbackList<IUserModificationCallback> m_aCallbacks = new CallbackList();

    public UserManager(@Nonnull @Nonempty String string) throws DAOException {
        super(User.class, string);
    }

    @Override
    public void createDefaults() {
        if (!this.containsWithID("admin")) {
            this.m_aRWLock.writeLockedGet(() -> this.internalCreateItem(new User("admin", "Admin", "admin@helger.com", GlobalPasswordSettings.createUserDefaultPasswordHash(new PasswordSalt(), "password"), "Administrator", null, null, null, null, false)));
        }
        if (!this.containsWithID("user")) {
            this.m_aRWLock.writeLockedGet(() -> this.internalCreateItem(new User("user", "User", "user@helger.com", GlobalPasswordSettings.createUserDefaultPasswordHash(new PasswordSalt(), "user"), "User", null, null, null, null, false)));
        }
        if (!this.containsWithID("guest")) {
            this.m_aRWLock.writeLockedGet(() -> this.internalCreateItem(new User("guest", "Guest", "guest@helger.com", GlobalPasswordSettings.createUserDefaultPasswordHash(new PasswordSalt(), "guest"), "Guest", null, null, null, null, false)));
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public final CallbackList<IUserModificationCallback> userModificationCallbacks() {
        return this.m_aCallbacks;
    }

    @Override
    @Nullable
    public IUser createNewUser(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable Locale locale, @Nullable Map<String, String> map, boolean bl) {
        ValueEnforcer.notEmpty(string, "LoginName");
        ValueEnforcer.notNull(string3, "PlainTextPassword");
        if (this.getUserOfLoginName(string) != null) {
            AuditHelper.onAuditCreateFailure(User.OT, "login-name-already-in-use", string);
            return null;
        }
        User user = new User(string, string2, GlobalPasswordSettings.createUserDefaultPasswordHash(new PasswordSalt(), string3), string4, string5, string6, locale, map, bl);
        this.m_aRWLock.writeLocked(() -> this.internalCreateItem(user));
        AuditHelper.onAuditCreateSuccess(User.OT, user.getID(), string, string2, string4, string5, string6, locale, map, bl);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserModificationCallback) -> iUserModificationCallback.onUserCreated(user, false));
        return user;
    }

    @Override
    @Nullable
    public IUser createPredefinedUser(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nonnull String string4, @Nullable String string5, @Nullable String string6, @Nullable String string7, @Nullable Locale locale, @Nullable Map<String, String> map, boolean bl) {
        ValueEnforcer.notEmpty(string2, "LoginName");
        ValueEnforcer.notNull(string4, "PlainTextPassword");
        if (this.getUserOfLoginName(string2) != null) {
            AuditHelper.onAuditCreateFailure(User.OT, "login-name-already-in-use", string2, "predefined-user");
            return null;
        }
        User user = new User(string, string2, string3, GlobalPasswordSettings.createUserDefaultPasswordHash(new PasswordSalt(), string4), string5, string6, string7, locale, map, bl);
        this.m_aRWLock.writeLocked(() -> this.internalCreateItem(user));
        AuditHelper.onAuditCreateSuccess(User.OT, user.getID(), "predefined-user", string2, string3, string5, string6, string7, locale, map, bl);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserModificationCallback) -> iUserModificationCallback.onUserCreated(user, true));
        return user;
    }

    @Override
    @Nullable
    public IUser getUserOfID(@Nullable String string) {
        return (IUser)this.getOfID(string);
    }

    @Override
    @Nullable
    public IUser getUserOfLoginName(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return this.findFirst(iUser -> iUser.getLoginName().equals(string));
    }

    @Override
    @Nullable
    public IUser getUserOfEmailAddress(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return this.findFirst(iUser -> string.equals(iUser.getEmailAddress()));
    }

    @Override
    @Nullable
    public IUser getUserOfEmailAddressIgnoreCase(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return this.findFirst(iUser -> string.equalsIgnoreCase(iUser.getEmailAddress()));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUser> getAllActiveUsers() {
        return this.getAll(iUser -> !iUser.isDeleted() && iUser.isEnabled());
    }

    @Override
    @Nonnegative
    public int getActiveUserCount() {
        return this.getCount(iUser -> !iUser.isDeleted() && iUser.isEnabled());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUser> getAllDisabledUsers() {
        return this.getAll(iUser -> !iUser.isDeleted() && iUser.isDisabled());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUser> getAllNotDeletedUsers() {
        return this.getAll(iUser -> !iUser.isDeleted());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUser> getAllDeletedUsers() {
        return this.getAll(iUser -> iUser.isDeleted());
    }

    @Override
    public boolean containsAnyActiveUser() {
        return this.containsAny(iUser -> !iUser.isDeleted() && iUser.isEnabled());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange setUserData(@Nullable String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5, @Nullable String string6, @Nullable Locale locale, @Nullable Map<String, String> map, boolean bl) {
        User user = (User)this.getOfID(string);
        if (user == null) {
            AuditHelper.onAuditModifyFailure(User.OT, string, "no-such-user-id");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = user.setLoginName(string2);
            eChange = eChange.or(user.setEmailAddress(string3));
            eChange = eChange.or(user.setFirstName(string4));
            eChange = eChange.or(user.setLastName(string5));
            eChange = eChange.or(user.setDescription(string6));
            eChange = eChange.or(user.setDesiredLocale(locale));
            eChange = eChange.or(user.setDisabled(bl));
            eChange = eChange.or(user.attrs().setAll(map));
            if (eChange.isUnchanged()) {
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            BusinessObjectHelper.setLastModificationNow(user);
            this.internalUpdateItem(user);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(User.OT, "all", user.getID(), string2, string3, string4, string5, string6, locale, map, bl);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserModificationCallback) -> iUserModificationCallback.onUserUpdated(user));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange setUserPassword(@Nullable String string, @Nonnull String string2) {
        User user = (User)this.getOfID(string);
        if (user == null) {
            AuditHelper.onAuditModifyFailure(User.OT, string, "no-such-user-id", "password");
            return EChange.UNCHANGED;
        }
        PasswordHash passwordHash = GlobalPasswordSettings.createUserDefaultPasswordHash(new PasswordSalt(), string2);
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = user.setPasswordHash(passwordHash);
            if (eChange.isUnchanged()) {
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            BusinessObjectHelper.setLastModificationNow(user);
            this.internalUpdateItem(user);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(User.OT, "password", string);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserModificationCallback) -> iUserModificationCallback.onUserPasswordChanged(user));
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange updateUserLastLogin(@Nullable String string) {
        User user = (User)this.getOfID(string);
        if (user == null) {
            AuditHelper.onAuditModifyFailure(User.OT, string, "no-such-user-id", "update-last-login");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            user.onSuccessfulLogin();
            this.internalUpdateItem(user);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(User.OT, "update-last-login", string);
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    public EChange updateUserLastFailedLogin(@Nullable String string) {
        User user = (User)this.getOfID(string);
        if (user == null) {
            AuditHelper.onAuditModifyFailure(User.OT, string, "no-such-user-id", "update-last-failed-login");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            user.onFailedLogin();
            this.internalUpdateItem(user);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(User.OT, "update-last-failed-login", string);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserModificationCallback) -> iUserModificationCallback.onUserLastFailedLoginUpdated(user));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange deleteUser(@Nullable String string) {
        User user = (User)this.getOfID(string);
        if (user == null) {
            AuditHelper.onAuditDeleteFailure(User.OT, "no-such-user-id", string);
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setDeletionNow(user).isUnchanged()) {
                AuditHelper.onAuditDeleteFailure(User.OT, "already-deleted", string);
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalMarkItemDeleted(user);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess(User.OT, string);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserModificationCallback) -> iUserModificationCallback.onUserDeleted(user));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange undeleteUser(@Nullable String string) {
        User user = (User)this.getOfID(string);
        if (user == null) {
            AuditHelper.onAuditUndeleteFailure(User.OT, string, "no-such-user-id");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setUndeletionNow(user).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalMarkItemUndeleted(user);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditUndeleteSuccess(User.OT, string);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserModificationCallback) -> iUserModificationCallback.onUserUndeleted(user));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange disableUser(@Nullable String string) {
        User user = (User)this.getOfID(string);
        if (user == null) {
            AuditHelper.onAuditModifyFailure(User.OT, string, "no-such-user-id", "disable");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (user.setDisabled(true).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalUpdateItem(user);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(User.OT, "disable", string);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserModificationCallback) -> iUserModificationCallback.onUserEnabled(user, false));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange enableUser(@Nullable String string) {
        User user = (User)this.getOfID(string);
        if (user == null) {
            AuditHelper.onAuditModifyFailure(User.OT, string, "no-such-user-id", "enable");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (user.setDisabled(false).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalUpdateItem(user);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(User.OT, "enable", string);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserModificationCallback) -> iUserModificationCallback.onUserEnabled(user, true));
        return EChange.CHANGED;
    }
}

