/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.user;

import com.helger.commons.annotation.ContainsSoftMigration;
import com.helger.commons.locale.LocaleCache;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.StringParser;
import com.helger.photon.security.object.AbstractBusinessObjectMicroTypeConverter;
import com.helger.photon.security.user.User;
import com.helger.security.password.hash.PasswordHash;
import com.helger.security.password.salt.PasswordSalt;
import com.helger.xml.microdom.IMicroElement;
import com.helger.xml.microdom.IMicroQName;
import com.helger.xml.microdom.MicroElement;
import com.helger.xml.microdom.MicroQName;
import com.helger.xml.microdom.util.MicroHelper;
import java.time.LocalDateTime;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class UserMicroTypeConverter
extends AbstractBusinessObjectMicroTypeConverter<User> {
    private static final IMicroQName ATTR_DESIREDLOCALE = new MicroQName("desiredlocale");
    private static final IMicroQName ATTR_LASTLOGINLDT = new MicroQName("lastloginldt");
    private static final IMicroQName ATTR_LOGINCOUNT = new MicroQName("logincount");
    private static final IMicroQName ATTR_CONSECUTIVEFAILEDLOGINCOUNT = new MicroQName("consecutivefailedlogincount");
    private static final String ELEMENT_LOGINNAME = "loginname";
    private static final String ELEMENT_EMAILADDRESS = "emailaddress";
    private static final String ELEMENT_PASSWORDHASH = "passwordhash";
    private static final IMicroQName ATTR_ALGORITHM = new MicroQName("algorithm");
    private static final IMicroQName ATTR_SALT = new MicroQName("salt");
    private static final String ELEMENT_FIRSTNAME = "firstname";
    private static final String ELEMENT_LASTNAME = "lastname";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final IMicroQName ATTR_DISABLED = new MicroQName("disabled");

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull User user, @Nullable String string, @Nonnull String string2) {
        MicroElement microElement = new MicroElement(string, string2);
        UserMicroTypeConverter.setObjectFields(user, microElement);
        microElement.appendElement(ELEMENT_LOGINNAME).appendText(user.getLoginName());
        if (user.getEmailAddress() != null) {
            microElement.appendElement(ELEMENT_EMAILADDRESS).appendText(user.getEmailAddress());
        }
        IMicroElement iMicroElement = microElement.appendElement(ELEMENT_PASSWORDHASH);
        iMicroElement.setAttribute(ATTR_ALGORITHM, user.getPasswordHash().getAlgorithmName());
        if (user.getPasswordHash().hasSalt()) {
            iMicroElement.setAttribute(ATTR_SALT, user.getPasswordHash().getSaltAsString());
        }
        iMicroElement.appendText(user.getPasswordHash().getPasswordHashValue());
        if (user.getFirstName() != null) {
            microElement.appendElement(ELEMENT_FIRSTNAME).appendText(user.getFirstName());
        }
        if (user.getLastName() != null) {
            microElement.appendElement(ELEMENT_LASTNAME).appendText(user.getLastName());
        }
        if (StringHelper.hasText(user.getDescription())) {
            microElement.appendElement(string, ELEMENT_DESCRIPTION).appendText(user.getDescription());
        }
        if (user.getDesiredLocale() != null) {
            microElement.setAttribute(ATTR_DESIREDLOCALE, user.getDesiredLocale().toString());
        }
        if (user.getLastLoginDateTime() != null) {
            microElement.setAttributeWithConversion(ATTR_LASTLOGINLDT, (Object)user.getLastLoginDateTime());
        }
        microElement.setAttribute(ATTR_LOGINCOUNT, user.getLoginCount());
        microElement.setAttribute(ATTR_CONSECUTIVEFAILEDLOGINCOUNT, user.getConsecutiveFailedLoginCount());
        microElement.setAttribute(ATTR_DISABLED, Boolean.toString(user.isDisabled()));
        return microElement;
    }

    @Override
    @Nonnull
    @ContainsSoftMigration
    public User convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = MicroHelper.getChildTextContentTrimmed(iMicroElement, ELEMENT_LOGINNAME);
        String string2 = MicroHelper.getChildTextContentTrimmed(iMicroElement, ELEMENT_EMAILADDRESS);
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(ELEMENT_PASSWORDHASH);
        String string3 = iMicroElement2.getAttributeValue(ATTR_ALGORITHM);
        if (string3 == null) {
            string3 = "PBKDF2_1000_48";
        }
        String string4 = iMicroElement2.getAttributeValue(ATTR_SALT);
        PasswordSalt passwordSalt = PasswordSalt.createFromStringMaybe(string4);
        String string5 = iMicroElement2.getTextContentTrimmed();
        PasswordHash passwordHash = new PasswordHash(string3, passwordSalt, string5);
        String string6 = MicroHelper.getChildTextContentTrimmed(iMicroElement, ELEMENT_FIRSTNAME);
        String string7 = MicroHelper.getChildTextContentTrimmed(iMicroElement, ELEMENT_LASTNAME);
        String string8 = MicroHelper.getChildTextContentTrimmed(iMicroElement, ELEMENT_DESCRIPTION);
        String string9 = iMicroElement.getAttributeValue(ATTR_DESIREDLOCALE);
        Locale locale = string9 == null ? null : LocaleCache.getInstance().getLocale(string9);
        LocalDateTime localDateTime = UserMicroTypeConverter.readAsLocalDateTime(iMicroElement, ATTR_LASTLOGINLDT, "lastlogindt");
        int n = StringParser.parseInt(iMicroElement.getAttributeValue(ATTR_LOGINCOUNT), 0);
        int n2 = StringParser.parseInt(iMicroElement.getAttributeValue(ATTR_CONSECUTIVEFAILEDLOGINCOUNT), 0);
        String string10 = iMicroElement.getAttributeValue(ATTR_DISABLED);
        boolean bl = StringParser.parseBool(string10);
        return new User(UserMicroTypeConverter.getStubObject(iMicroElement), string, string2, passwordHash, string6, string7, string8, locale, localDateTime, n, n2, bl);
    }
}

