/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.usergroup;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.photon.app.mgr.IPhotonManager;
import com.helger.photon.security.role.IRoleManager;
import com.helger.photon.security.user.IUserManager;
import com.helger.photon.security.usergroup.IUserGroup;
import com.helger.photon.security.usergroup.IUserGroupModificationCallback;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface IUserGroupManager
extends IPhotonManager<IUserGroup> {
    @Nonnull
    public IUserManager getUserManager();

    @Nonnull
    public IRoleManager getRoleManager();

    public void createDefaults();

    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IUserGroupModificationCallback> userGroupModificationCallbacks();

    @Nonnull
    public IUserGroup createNewUserGroup(@Nonnull @Nonempty String var1, @Nullable String var2, @Nullable Map<String, String> var3);

    @Nonnull
    public IUserGroup createPredefinedUserGroup(@Nonnull @Nonempty String var1, @Nonnull @Nonempty String var2, @Nullable String var3, @Nullable Map<String, String> var4);

    @Nonnull
    public EChange deleteUserGroup(@Nullable String var1);

    @Nonnull
    public EChange undeleteUserGroup(@Nullable String var1);

    @Nullable
    public IUserGroup getUserGroupOfID(@Nullable String var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUserGroup> getAllActiveUserGroups();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUserGroup> getAllDeletedUserGroups();

    @Nonnull
    public EChange renameUserGroup(@Nullable String var1, @Nonnull @Nonempty String var2);

    @Nonnull
    public EChange setUserGroupData(@Nullable String var1, @Nonnull @Nonempty String var2, @Nullable String var3, @Nullable Map<String, String> var4);

    @Nonnull
    public EChange assignUserToUserGroup(@Nullable String var1, @Nonnull @Nonempty String var2);

    @Nonnull
    public EChange unassignUserFromUserGroup(@Nullable String var1, @Nullable String var2);

    @Nonnull
    public EChange unassignUserFromAllUserGroups(@Nullable String var1);

    default public boolean isUserAssignedToUserGroup(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string2)) {
            return false;
        }
        IUserGroup iUserGroup = this.getUserGroupOfID(string);
        return iUserGroup == null ? false : iUserGroup.containsUserID(string2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUserGroup> getAllUserGroupsWithAssignedUser(@Nullable String var1);

    public boolean containsAnyUserGroupWithAssignedUserAndRole(@Nullable String var1, @Nullable String var2);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllUserGroupIDsWithAssignedUser(@Nullable String var1);

    @Nonnull
    public EChange assignRoleToUserGroup(@Nullable String var1, @Nonnull @Nonempty String var2);

    @Nonnull
    public EChange unassignRoleFromUserGroup(@Nullable String var1, @Nullable String var2);

    @Nonnull
    public EChange unassignRoleFromAllUserGroups(@Nullable String var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUserGroup> getAllUserGroupsWithAssignedRole(@Nullable String var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllUserGroupIDsWithAssignedRole(@Nullable String var1);

    public boolean containsUserGroupWithAssignedRole(@Nullable String var1);
}

