/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.usergroup;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.type.ObjectType;
import com.helger.photon.security.object.StubObject;
import com.helger.photon.security.usergroup.IUserGroup;
import com.helger.tenancy.AbstractBusinessObject;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class UserGroup
extends AbstractBusinessObject
implements IUserGroup {
    public static final ObjectType OT = new ObjectType("usergroup");
    private String m_sName;
    private String m_sDescription;
    private final ICommonsSet<String> m_aUserIDs = new CommonsHashSet<String>();
    private final ICommonsSet<String> m_aRoleIDs = new CommonsHashSet<String>();

    public UserGroup(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable Map<String, String> map) {
        this(StubObject.createForCurrentUser(map), string, string2);
    }

    protected UserGroup(@Nonnull StubObject stubObject, @Nonnull @Nonempty String string, @Nullable String string2) {
        super(stubObject);
        this.setName(string);
        this.setDescription(string2);
    }

    @Override
    @Nonnull
    public ObjectType getObjectType() {
        return OT;
    }

    @Override
    @Nonnull
    @Nonempty
    public String getName() {
        return this.m_sName;
    }

    @Nonnull
    protected EChange setName(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        if (string.equals(this.m_sName)) {
            return EChange.UNCHANGED;
        }
        this.m_sName = string;
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public String getDescription() {
        return this.m_sDescription;
    }

    @Nonnull
    protected EChange setDescription(@Nullable String string) {
        if (EqualsHelper.equals(string, this.m_sDescription)) {
            return EChange.UNCHANGED;
        }
        this.m_sDescription = string;
        return EChange.CHANGED;
    }

    @Override
    public boolean hasContainedUsers() {
        return this.m_aUserIDs.isNotEmpty();
    }

    @Override
    @Nonnegative
    public int getContainedUserCount() {
        return this.m_aUserIDs.size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllContainedUserIDs() {
        return (ICommonsSet)this.m_aUserIDs.getClone();
    }

    @Override
    public boolean containsUserID(String string) {
        return this.m_aUserIDs.contains(string);
    }

    @Nonnull
    protected EChange assignUser(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "UserID");
        return EChange.valueOf(this.m_aUserIDs.add(string));
    }

    @Nonnull
    protected EChange unassignUser(@Nonnull String string) {
        return EChange.valueOf(this.m_aUserIDs.remove(string));
    }

    @Override
    public boolean hasContainedRoles() {
        return this.m_aRoleIDs.isNotEmpty();
    }

    @Override
    @Nonnegative
    public int getContainedRoleCount() {
        return this.m_aRoleIDs.size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllContainedRoleIDs() {
        return (ICommonsSet)this.m_aRoleIDs.getClone();
    }

    @Override
    public boolean containsRoleID(String string) {
        return this.m_aRoleIDs.contains(string);
    }

    @Nonnull
    protected EChange assignRole(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "RoleID");
        return EChange.valueOf(this.m_aRoleIDs.add(string));
    }

    @Nonnull
    protected EChange unassignRole(@Nonnull String string) {
        return EChange.valueOf(this.m_aRoleIDs.remove(string));
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("name", this.m_sName).appendIfNotNull("description", this.m_sDescription).append("assignedUsers", this.m_aUserIDs).append("assignedRoles", this.m_aRoleIDs).getToString();
    }
}

