/*
 * Decompiled with CFR 0.152.
 */
package com.helger.photon.security.usergroup;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.id.IHasID;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.dao.DAOException;
import com.helger.photon.app.dao.AbstractPhotonMapBasedWALDAO;
import com.helger.photon.audit.AuditHelper;
import com.helger.photon.security.object.BusinessObjectHelper;
import com.helger.photon.security.object.StubObject;
import com.helger.photon.security.role.IRoleManager;
import com.helger.photon.security.user.IUserManager;
import com.helger.photon.security.usergroup.IUserGroup;
import com.helger.photon.security.usergroup.IUserGroupManager;
import com.helger.photon.security.usergroup.IUserGroupModificationCallback;
import com.helger.photon.security.usergroup.UserGroup;
import com.helger.tenancy.IBusinessObject;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class UserGroupManager
extends AbstractPhotonMapBasedWALDAO<IUserGroup, UserGroup>
implements IUserGroupManager {
    private final IUserManager m_aUserMgr;
    private final IRoleManager m_aRoleMgr;
    private final CallbackList<IUserGroupModificationCallback> m_aCallbacks = new CallbackList();

    public UserGroupManager(@Nonnull @Nonempty String string, @Nonnull IUserManager iUserManager, @Nonnull IRoleManager iRoleManager) throws DAOException {
        super(UserGroup.class, string);
        this.m_aUserMgr = ValueEnforcer.notNull(iUserManager, "UserManager");
        this.m_aRoleMgr = ValueEnforcer.notNull(iRoleManager, "RoleManager");
    }

    @Override
    @Nonnull
    public final IUserManager getUserManager() {
        return this.m_aUserMgr;
    }

    @Override
    @Nonnull
    public final IRoleManager getRoleManager() {
        return this.m_aRoleMgr;
    }

    @Override
    public void createDefaults() {
        UserGroup userGroup = (UserGroup)this.getOfID("ugadmin");
        if (userGroup == null) {
            userGroup = this.m_aRWLock.writeLockedGet(() -> this.internalCreateItem(new UserGroup(StubObject.createForCurrentUserAndID("ugadmin"), "Administrators", (String)null)));
        }
        if (this.m_aUserMgr.containsWithID("admin")) {
            userGroup.assignUser("admin");
        }
        if (this.m_aRoleMgr.containsWithID("radmin")) {
            userGroup.assignRole("radmin");
        }
        if ((userGroup = (UserGroup)this.getOfID("uguser")) == null) {
            userGroup = this.m_aRWLock.writeLockedGet(() -> this.internalCreateItem(new UserGroup(StubObject.createForCurrentUserAndID("uguser"), "Users", (String)null)));
        }
        if (this.m_aUserMgr.containsWithID("user")) {
            userGroup.assignUser("user");
        }
        if (this.m_aRoleMgr.containsWithID("ruser")) {
            userGroup.assignRole("ruser");
        }
        if ((userGroup = (UserGroup)this.getOfID("ugguest")) == null) {
            userGroup = this.m_aRWLock.writeLockedGet(() -> this.internalCreateItem(new UserGroup(StubObject.createForCurrentUserAndID("ugguest"), "Guests", (String)null)));
        }
        if (this.m_aUserMgr.containsWithID("guest")) {
            userGroup.assignUser("guest");
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableObject
    public CallbackList<IUserGroupModificationCallback> userGroupModificationCallbacks() {
        return this.m_aCallbacks;
    }

    @Override
    @Nonnull
    public IUserGroup createNewUserGroup(@Nonnull @Nonempty String string, @Nullable String string2, @Nullable Map<String, String> map) {
        UserGroup userGroup = new UserGroup(string, string2, map);
        this.m_aRWLock.writeLocked(() -> this.internalCreateItem(userGroup));
        AuditHelper.onAuditCreateSuccess(UserGroup.OT, userGroup.getID(), string, string2, map);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserGroupModificationCallback) -> iUserGroupModificationCallback.onUserGroupCreated(userGroup, false));
        return userGroup;
    }

    @Override
    @Nonnull
    public IUserGroup createPredefinedUserGroup(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nullable Map<String, String> map) {
        UserGroup userGroup = new UserGroup(StubObject.createForCurrentUserAndID(string, map), string2, string3);
        this.m_aRWLock.writeLocked(() -> this.internalCreateItem(userGroup));
        AuditHelper.onAuditCreateSuccess(UserGroup.OT, userGroup.getID(), "predefined-usergroup", string2, string3, map);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserGroupModificationCallback) -> iUserGroupModificationCallback.onUserGroupCreated(userGroup, true));
        return userGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange deleteUserGroup(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return EChange.UNCHANGED;
        }
        UserGroup userGroup = (UserGroup)this.getOfID(string);
        if (userGroup == null) {
            AuditHelper.onAuditDeleteFailure(UserGroup.OT, "no-such-usergroup-id", string);
            return EChange.UNCHANGED;
        }
        if (userGroup.isDeleted()) {
            AuditHelper.onAuditDeleteFailure(UserGroup.OT, "already-deleted", string);
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setDeletionNow(userGroup).isUnchanged()) {
                AuditHelper.onAuditDeleteFailure(UserGroup.OT, "already-deleted", string);
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalMarkItemDeleted(userGroup);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditDeleteSuccess(UserGroup.OT, string);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserGroupModificationCallback) -> iUserGroupModificationCallback.onUserGroupDeleted(userGroup));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange undeleteUserGroup(@Nullable String string) {
        UserGroup userGroup = (UserGroup)this.getOfID(string);
        if (userGroup == null) {
            AuditHelper.onAuditUndeleteFailure(UserGroup.OT, string, "no-such-id");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (BusinessObjectHelper.setUndeletionNow(userGroup).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            this.internalMarkItemUndeleted(userGroup);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditUndeleteSuccess(UserGroup.OT, string);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserGroupModificationCallback) -> iUserGroupModificationCallback.onUserGroupUndeleted(userGroup));
        return EChange.CHANGED;
    }

    @Override
    @Nullable
    public IUserGroup getUserGroupOfID(@Nullable String string) {
        return (IUserGroup)this.getOfID(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUserGroup> getAllActiveUserGroups() {
        return this.getAll(iUserGroup -> !iUserGroup.isDeleted());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUserGroup> getAllDeletedUserGroups() {
        return this.getAll(IBusinessObject::isDeleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange renameUserGroup(@Nullable String string, @Nonnull @Nonempty String string2) {
        UserGroup userGroup = (UserGroup)this.getOfID(string);
        if (userGroup == null) {
            AuditHelper.onAuditModifyFailure(UserGroup.OT, string, "no-such-usergroup-id", "name");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (userGroup.setName(string2).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setLastModificationNow(userGroup);
            this.internalUpdateItem(userGroup);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(UserGroup.OT, "name", string, string2);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserGroupModificationCallback) -> iUserGroupModificationCallback.onUserGroupRenamed(userGroup));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange setUserGroupData(@Nullable String string, @Nonnull @Nonempty String string2, @Nullable String string3, @Nullable Map<String, String> map) {
        UserGroup userGroup = (UserGroup)this.getOfID(string);
        if (userGroup == null) {
            AuditHelper.onAuditModifyFailure(UserGroup.OT, string, "no-such-usergroup-id");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            EChange eChange = userGroup.setName(string2);
            eChange = eChange.or(userGroup.setDescription(string3));
            eChange = eChange.or(userGroup.attrs().setAll(map));
            if (eChange.isUnchanged()) {
                EChange eChange2 = EChange.UNCHANGED;
                return eChange2;
            }
            BusinessObjectHelper.setLastModificationNow(userGroup);
            this.internalUpdateItem(userGroup);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(UserGroup.OT, "all", userGroup.getID(), string2, string3, map);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserGroupModificationCallback) -> iUserGroupModificationCallback.onUserGroupUpdated(userGroup));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange assignUserToUserGroup(@Nullable String string, @Nonnull @Nonempty String string2) {
        UserGroup userGroup = (UserGroup)this.getOfID(string);
        if (userGroup == null) {
            AuditHelper.onAuditModifyFailure(UserGroup.OT, string, "no-such-usergroup-id", "assign-user");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (userGroup.assignUser(string2).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setLastModificationNow(userGroup);
            this.internalUpdateItem(userGroup);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(UserGroup.OT, "assign-user", string, string2);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserGroupModificationCallback) -> iUserGroupModificationCallback.onUserGroupUserAssignment(userGroup, string2, true));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange unassignUserFromUserGroup(@Nullable String string, @Nullable String string2) {
        UserGroup userGroup = (UserGroup)this.getOfID(string);
        if (userGroup == null) {
            AuditHelper.onAuditModifyFailure(UserGroup.OT, string, "no-such-usergroup-id", "unassign-user");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (userGroup.unassignUser(string2).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setLastModificationNow(userGroup);
            this.internalUpdateItem(userGroup);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(UserGroup.OT, "unassign-user", string, string2);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserGroupModificationCallback) -> iUserGroupModificationCallback.onUserGroupUserAssignment(userGroup, string2, false));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange unassignUserFromAllUserGroups(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return EChange.UNCHANGED;
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.m_aRWLock.writeLock().lock();
        try {
            Object object = EChange.UNCHANGED;
            for (UserGroup userGroup : this.internalDirectGetAll()) {
                if (!userGroup.unassignUser(string).isChanged()) continue;
                commonsArrayList.add(userGroup);
                BusinessObjectHelper.setLastModificationNow(userGroup);
                this.internalUpdateItem(userGroup);
                object = EChange.CHANGED;
            }
            if (object.isUnchanged()) {
                Object object2 = EChange.UNCHANGED;
                return object2;
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(UserGroup.OT, "unassign-user-from-all-usergroups", string);
        for (Object object2 : commonsArrayList) {
            this.m_aCallbacks.forEach(arg_0 -> UserGroupManager.lambda$unassignUserFromAllUserGroups$14((IUserGroup)object2, string, arg_0));
        }
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUserGroup> getAllUserGroupsWithAssignedUser(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return new CommonsArrayList<IUserGroup>();
        }
        return this.getAll(iUserGroup -> iUserGroup.containsUserID(string));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllUserGroupIDsWithAssignedUser(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return new CommonsArrayList<String>();
        }
        return this.getAllMapped(iUserGroup -> iUserGroup.containsUserID(string), IHasID::getID);
    }

    @Override
    public boolean containsAnyUserGroupWithAssignedUserAndRole(@Nullable String string, @Nullable String string2) {
        if (StringHelper.hasNoText(string)) {
            return false;
        }
        if (StringHelper.hasNoText(string2)) {
            return false;
        }
        return this.containsAny(iUserGroup -> iUserGroup.containsUserID(string) && iUserGroup.containsRoleID(string2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange assignRoleToUserGroup(@Nullable String string, @Nonnull @Nonempty String string2) {
        UserGroup userGroup = (UserGroup)this.getOfID(string);
        if (userGroup == null) {
            AuditHelper.onAuditModifyFailure(UserGroup.OT, string, "no-such-usergroup-id", "assign-role");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (userGroup.assignRole(string2).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setLastModificationNow(userGroup);
            this.internalUpdateItem(userGroup);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(UserGroup.OT, "assign-role", string, string2);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserGroupModificationCallback) -> iUserGroupModificationCallback.onUserGroupRoleAssignment(userGroup, string2, true));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange unassignRoleFromUserGroup(@Nullable String string, @Nullable String string2) {
        UserGroup userGroup = (UserGroup)this.getOfID(string);
        if (userGroup == null) {
            AuditHelper.onAuditModifyFailure(UserGroup.OT, string, "no-such-usergroup-id", "unassign-role");
            return EChange.UNCHANGED;
        }
        this.m_aRWLock.writeLock().lock();
        try {
            if (userGroup.unassignRole(string2).isUnchanged()) {
                EChange eChange = EChange.UNCHANGED;
                return eChange;
            }
            BusinessObjectHelper.setLastModificationNow(userGroup);
            this.internalUpdateItem(userGroup);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(UserGroup.OT, "unassign-role", string, string2);
        this.m_aCallbacks.forEach((? super CALLBACKTYPE iUserGroupModificationCallback) -> iUserGroupModificationCallback.onUserGroupRoleAssignment(userGroup, string2, false));
        return EChange.CHANGED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public EChange unassignRoleFromAllUserGroups(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return EChange.UNCHANGED;
        }
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        this.m_aRWLock.writeLock().lock();
        try {
            Object object = EChange.UNCHANGED;
            for (UserGroup userGroup : this.internalDirectGetAll()) {
                if (!userGroup.unassignRole(string).isChanged()) continue;
                commonsArrayList.add(userGroup);
                BusinessObjectHelper.setLastModificationNow(userGroup);
                this.internalUpdateItem(userGroup);
                object = EChange.CHANGED;
            }
            if (object.isUnchanged()) {
                Object object2 = EChange.UNCHANGED;
                return object2;
            }
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        AuditHelper.onAuditModifySuccess(UserGroup.OT, "unassign-role-from-all-usergroups", string);
        for (Object object2 : commonsArrayList) {
            this.m_aCallbacks.forEach(arg_0 -> UserGroupManager.lambda$unassignRoleFromAllUserGroups$20((IUserGroup)object2, string, arg_0));
        }
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IUserGroup> getAllUserGroupsWithAssignedRole(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return this.getNone();
        }
        return this.getAll(iUserGroup -> iUserGroup.containsRoleID(string));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<String> getAllUserGroupIDsWithAssignedRole(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return this.getNone();
        }
        return this.getAllMapped(iUserGroup -> iUserGroup.containsRoleID(string), IHasID::getID);
    }

    @Override
    public boolean containsUserGroupWithAssignedRole(@Nullable String string) {
        return this.containsAny(iUserGroup -> iUserGroup.containsRoleID(string));
    }

    private static /* synthetic */ void lambda$unassignRoleFromAllUserGroups$20(IUserGroup iUserGroup, String string, IUserGroupModificationCallback iUserGroupModificationCallback) {
        iUserGroupModificationCallback.onUserGroupRoleAssignment(iUserGroup, string, false);
    }

    private static /* synthetic */ void lambda$unassignUserFromAllUserGroups$14(IUserGroup iUserGroup, String string, IUserGroupModificationCallback iUserGroupModificationCallback) {
        iUserGroupModificationCallback.onUserGroupUserAssignment(iUserGroup, string, false);
    }
}

