/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.PDTFactory;
import com.helger.quartz.EIntervalUnit;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.ITrigger;
import com.helger.quartz.TimeOfDay;
import com.helger.quartz.impl.triggers.DailyTimeIntervalTrigger;
import java.time.DayOfWeek;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;

public class DailyTimeIntervalScheduleBuilder
implements IScheduleBuilder<DailyTimeIntervalTrigger> {
    private int m_nInterval = 1;
    private EIntervalUnit m_eIntervalUnit = EIntervalUnit.MINUTE;
    private EnumSet<DayOfWeek> m_aDaysOfWeek;
    private TimeOfDay m_aStartTimeOfDay;
    private TimeOfDay m_aEndTimeOfDay;
    private int m_nRepeatCount = -1;
    private ITrigger.EMisfireInstruction m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_SMART_POLICY;
    private static final EnumSet<DayOfWeek> ALL_DAYS_OF_THE_WEEK = EnumSet.allOf(DayOfWeek.class);
    private static final EnumSet<DayOfWeek> MONDAY_THROUGH_FRIDAY = EnumSet.of(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    private static final EnumSet<DayOfWeek> SATURDAY_AND_SUNDAY = EnumSet.of(DayOfWeek.SUNDAY, DayOfWeek.SATURDAY);

    protected DailyTimeIntervalScheduleBuilder() {
    }

    @Nonnull
    public static DailyTimeIntervalScheduleBuilder dailyTimeIntervalSchedule() {
        return new DailyTimeIntervalScheduleBuilder();
    }

    @Override
    @Nonnull
    public DailyTimeIntervalTrigger build() {
        DailyTimeIntervalTrigger dailyTimeIntervalTrigger = new DailyTimeIntervalTrigger();
        dailyTimeIntervalTrigger.setRepeatInterval(this.m_nInterval);
        dailyTimeIntervalTrigger.setRepeatIntervalUnit(this.m_eIntervalUnit);
        dailyTimeIntervalTrigger.setMisfireInstruction(this.m_eMisfireInstruction);
        dailyTimeIntervalTrigger.setRepeatCount(this.m_nRepeatCount);
        if (this.m_aDaysOfWeek != null) {
            dailyTimeIntervalTrigger.setDaysOfWeek(this.m_aDaysOfWeek);
        } else {
            dailyTimeIntervalTrigger.setDaysOfWeek(EnumSet.copyOf(ALL_DAYS_OF_THE_WEEK));
        }
        if (this.m_aStartTimeOfDay != null) {
            dailyTimeIntervalTrigger.setStartTimeOfDay(this.m_aStartTimeOfDay);
        } else {
            dailyTimeIntervalTrigger.setStartTimeOfDay(TimeOfDay.hourAndMinuteOfDay(0, 0));
        }
        if (this.m_aEndTimeOfDay != null) {
            dailyTimeIntervalTrigger.setEndTimeOfDay(this.m_aEndTimeOfDay);
        } else {
            dailyTimeIntervalTrigger.setEndTimeOfDay(TimeOfDay.hourMinuteAndSecondOfDay(23, 59, 59));
        }
        return dailyTimeIntervalTrigger;
    }

    @Nonnull
    public DailyTimeIntervalScheduleBuilder withInterval(int n, @Nonnull EIntervalUnit eIntervalUnit) {
        if (eIntervalUnit == null || !eIntervalUnit.equals((Object)EIntervalUnit.SECOND) && !eIntervalUnit.equals((Object)EIntervalUnit.MINUTE) && !eIntervalUnit.equals((Object)EIntervalUnit.HOUR)) {
            throw new IllegalArgumentException("Invalid repeat IntervalUnit (must be SECOND, MINUTE or HOUR).");
        }
        DailyTimeIntervalScheduleBuilder._validateInterval(n);
        this.m_nInterval = n;
        this.m_eIntervalUnit = eIntervalUnit;
        return this;
    }

    @Nonnull
    public DailyTimeIntervalScheduleBuilder withIntervalInSeconds(int n) {
        return this.withInterval(n, EIntervalUnit.SECOND);
    }

    @Nonnull
    public DailyTimeIntervalScheduleBuilder withIntervalInMinutes(int n) {
        return this.withInterval(n, EIntervalUnit.MINUTE);
    }

    @Nonnull
    public DailyTimeIntervalScheduleBuilder withIntervalInHours(int n) {
        this.withInterval(n, EIntervalUnit.HOUR);
        return this;
    }

    @Nonnull
    public DailyTimeIntervalScheduleBuilder onDaysOfTheWeek(Set<DayOfWeek> set) {
        ValueEnforcer.notEmpty(set, "OnDaysOfWeek");
        this.m_aDaysOfWeek = EnumSet.copyOf(set);
        return this;
    }

    @Nonnull
    public DailyTimeIntervalScheduleBuilder onDaysOfTheWeek(DayOfWeek ... dayOfWeekArray) {
        EnumSet<DayOfWeek> enumSet = EnumSet.noneOf(DayOfWeek.class);
        Collections.addAll(enumSet, dayOfWeekArray);
        return this.onDaysOfTheWeek(enumSet);
    }

    @Nonnull
    public DailyTimeIntervalScheduleBuilder onMondayThroughFriday() {
        this.m_aDaysOfWeek = EnumSet.copyOf(MONDAY_THROUGH_FRIDAY);
        return this;
    }

    @Nonnull
    public DailyTimeIntervalScheduleBuilder onSaturdayAndSunday() {
        this.m_aDaysOfWeek = EnumSet.copyOf(SATURDAY_AND_SUNDAY);
        return this;
    }

    @Nonnull
    public DailyTimeIntervalScheduleBuilder onEveryDay() {
        this.m_aDaysOfWeek = EnumSet.copyOf(ALL_DAYS_OF_THE_WEEK);
        return this;
    }

    @Nonnull
    public DailyTimeIntervalScheduleBuilder startingDailyAt(TimeOfDay timeOfDay) {
        if (timeOfDay == null) {
            throw new IllegalArgumentException("Start time of day cannot be null!");
        }
        this.m_aStartTimeOfDay = timeOfDay;
        return this;
    }

    @Nonnull
    public DailyTimeIntervalScheduleBuilder endingDailyAt(TimeOfDay timeOfDay) {
        this.m_aEndTimeOfDay = timeOfDay;
        return this;
    }

    @Nonnull
    public DailyTimeIntervalScheduleBuilder endingDailyAfterCount(int n) {
        long l;
        ValueEnforcer.isGT0(n, "Count");
        if (this.m_aStartTimeOfDay == null) {
            throw new IllegalArgumentException("You must set the startDailyAt() before calling this endingDailyAfterCount()!");
        }
        Date date = new Date();
        Date date2 = this.m_aStartTimeOfDay.getTimeOfDayForDate(date);
        Date date3 = TimeOfDay.hourMinuteAndSecondOfDay(23, 59, 59).getTimeOfDayForDate(date);
        long l2 = date3.getTime() - date2.getTime();
        if (this.m_eIntervalUnit == EIntervalUnit.SECOND) {
            l = (long)this.m_nInterval * 1000L;
        } else if (this.m_eIntervalUnit == EIntervalUnit.MINUTE) {
            l = (long)this.m_nInterval * 60000L;
        } else if (this.m_eIntervalUnit == EIntervalUnit.HOUR) {
            l = (long)this.m_nInterval * 86400000L;
        } else {
            throw new IllegalArgumentException("The IntervalUnit: " + (Object)((Object)this.m_eIntervalUnit) + " is invalid for this trigger.");
        }
        if (l2 - l <= 0L) {
            throw new IllegalArgumentException("The startTimeOfDay is too late with given Interval and IntervalUnit values.");
        }
        long l3 = l2 / l;
        if ((long)n > l3) {
            throw new IllegalArgumentException("The given count " + n + " is too large! The max you can set is " + l3);
        }
        long l4 = (long)(n - 1) * l;
        Date date4 = new Date(date2.getTime() + l4);
        if (date4.getTime() > date3.getTime()) {
            throw new IllegalArgumentException("The given count " + n + " is too large! The max you can set is " + l3);
        }
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date4);
        int n2 = calendar.get(11);
        int n3 = calendar.get(12);
        int n4 = calendar.get(13);
        this.m_aEndTimeOfDay = TimeOfDay.hourMinuteAndSecondOfDay(n2, n3, n4);
        return this;
    }

    @Nonnull
    public DailyTimeIntervalScheduleBuilder withMisfireHandlingInstructionIgnoreMisfires() {
        this.m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY;
        return this;
    }

    @Nonnull
    public DailyTimeIntervalScheduleBuilder withMisfireHandlingInstructionDoNothing() {
        this.m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_DO_NOTHING;
        return this;
    }

    @Nonnull
    public DailyTimeIntervalScheduleBuilder withMisfireHandlingInstructionFireAndProceed() {
        this.m_eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_FIRE_ONCE_NOW;
        return this;
    }

    @Nonnull
    public DailyTimeIntervalScheduleBuilder withRepeatCount(int n) {
        this.m_nRepeatCount = n;
        return this;
    }

    private static void _validateInterval(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Interval must be a positive value.");
        }
    }
}

