/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.datetime.PDTFactory;
import com.helger.quartz.CQuartz;
import com.helger.quartz.EIntervalUnit;
import java.time.DayOfWeek;
import java.time.Month;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nonnull;

public final class DateBuilder {
    public static final long SECONDS_IN_MOST_DAYS = 86400L;
    public static final long MILLISECONDS_IN_DAY = 86400000L;
    private TimeZone m_aTZ;
    private Locale m_aLocale;
    private int m_nMonth;
    private int m_nDay;
    private int m_nYear;
    private int m_nHour;
    private int m_nMinute;
    private int m_nSecond;

    private DateBuilder() {
        this(TimeZone.getDefault(), Locale.getDefault(Locale.Category.FORMAT));
    }

    private DateBuilder(TimeZone timeZone) {
        this(timeZone, Locale.getDefault(Locale.Category.FORMAT));
    }

    private DateBuilder(Locale locale) {
        this(TimeZone.getDefault(), locale);
    }

    private DateBuilder(TimeZone timeZone, Locale locale) {
        Calendar calendar = Calendar.getInstance(timeZone, locale);
        this.m_aTZ = timeZone;
        this.m_aLocale = locale;
        this.m_nMonth = calendar.get(2) + 1;
        this.m_nDay = calendar.get(5);
        this.m_nYear = calendar.get(1);
        this.m_nHour = calendar.get(11);
        this.m_nMinute = calendar.get(12);
        this.m_nSecond = calendar.get(13);
    }

    public static DateBuilder newDate() {
        return new DateBuilder();
    }

    public static DateBuilder newDateInTimezone(TimeZone timeZone) {
        return new DateBuilder(timeZone);
    }

    public static DateBuilder newDateInLocale(Locale locale) {
        return new DateBuilder(locale);
    }

    public static DateBuilder newDateInTimeZoneAndLocale(TimeZone timeZone, Locale locale) {
        return new DateBuilder(timeZone, locale);
    }

    @Nonnull
    public Date build() {
        Calendar calendar = this.m_aTZ != null && this.m_aLocale != null ? Calendar.getInstance(this.m_aTZ, this.m_aLocale) : (this.m_aTZ != null ? Calendar.getInstance(this.m_aTZ, Locale.getDefault(Locale.Category.FORMAT)) : (this.m_aLocale != null ? Calendar.getInstance(TimeZone.getDefault(), this.m_aLocale) : PDTFactory.createCalendar()));
        calendar.set(1, this.m_nYear);
        calendar.set(2, this.m_nMonth - 1);
        calendar.set(5, this.m_nDay);
        calendar.set(11, this.m_nHour);
        calendar.set(12, this.m_nMinute);
        calendar.set(13, this.m_nSecond);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public DateBuilder atHourOfDay(int n) {
        DateBuilder.validateHour(n);
        this.m_nHour = n;
        return this;
    }

    public DateBuilder atMinute(int n) {
        DateBuilder.validateMinute(n);
        this.m_nMinute = n;
        return this;
    }

    public DateBuilder atSecond(int n) {
        DateBuilder.validateSecond(n);
        this.m_nSecond = n;
        return this;
    }

    public DateBuilder atHourMinuteAndSecond(int n, int n2, int n3) {
        DateBuilder.validateHour(n);
        DateBuilder.validateMinute(n2);
        DateBuilder.validateSecond(n3);
        this.m_nHour = n;
        this.m_nSecond = n3;
        this.m_nMinute = n2;
        return this;
    }

    public DateBuilder onDay(int n) {
        DateBuilder.validateDayOfMonth(n);
        this.m_nDay = n;
        return this;
    }

    public DateBuilder inMonth(Month month) {
        DateBuilder.validateMonth(month);
        this.m_nMonth = month.getValue();
        return this;
    }

    public DateBuilder inMonthOnDay(Month month, int n) {
        DateBuilder.validateMonth(month);
        DateBuilder.validateDayOfMonth(n);
        this.m_nMonth = month.getValue();
        this.m_nDay = n;
        return this;
    }

    public DateBuilder inYear(int n) {
        DateBuilder.validateYear(n);
        this.m_nYear = n;
        return this;
    }

    public DateBuilder inTimeZone(TimeZone timeZone) {
        this.m_aTZ = timeZone;
        return this;
    }

    public DateBuilder inLocale(Locale locale) {
        this.m_aLocale = locale;
        return this;
    }

    public static Date futureDate(int n, EIntervalUnit eIntervalUnit) {
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(new Date());
        calendar.setLenient(true);
        calendar.add(DateBuilder._translate(eIntervalUnit), n);
        return calendar.getTime();
    }

    private static int _translate(EIntervalUnit eIntervalUnit) {
        switch (eIntervalUnit) {
            case DAY: {
                return 6;
            }
            case HOUR: {
                return 11;
            }
            case MINUTE: {
                return 12;
            }
            case MONTH: {
                return 2;
            }
            case SECOND: {
                return 13;
            }
            case MILLISECOND: {
                return 14;
            }
            case WEEK: {
                return 3;
            }
            case YEAR: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Unknown IntervalUnit");
    }

    public static Date tomorrowAt(int n, int n2, int n3) {
        DateBuilder.validateSecond(n3);
        DateBuilder.validateMinute(n2);
        DateBuilder.validateHour(n);
        Date date = new Date();
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date);
        calendar.setLenient(true);
        calendar.add(6, 1);
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date todayAt(int n, int n2, int n3) {
        return DateBuilder.dateOf(n, n2, n3);
    }

    public static Date dateOf(int n, int n2, int n3) {
        DateBuilder.validateSecond(n3);
        DateBuilder.validateMinute(n2);
        DateBuilder.validateHour(n);
        Date date = new Date();
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date);
        calendar.setLenient(true);
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date dateOf(int n, int n2, int n3, int n4, Month month) {
        DateBuilder.validateSecond(n3);
        DateBuilder.validateMinute(n2);
        DateBuilder.validateHour(n);
        DateBuilder.validateDayOfMonth(n4);
        DateBuilder.validateMonth(month);
        Date date = new Date();
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date);
        calendar.set(2, month.getValue() - 1);
        calendar.set(5, n4);
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date dateOf(int n, int n2, int n3, int n4, Month month, int n5) {
        DateBuilder.validateSecond(n3);
        DateBuilder.validateMinute(n2);
        DateBuilder.validateHour(n);
        DateBuilder.validateDayOfMonth(n4);
        DateBuilder.validateMonth(month);
        DateBuilder.validateYear(n5);
        Date date = new Date();
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date);
        calendar.set(1, n5);
        calendar.set(2, month.getValue() - 1);
        calendar.set(5, n4);
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date evenHourDateAfterNow() {
        return DateBuilder.evenHourDate(null);
    }

    public static Date evenHourDate(Date date) {
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date != null ? date : new Date());
        calendar.setLenient(true);
        calendar.set(11, calendar.get(11) + 1);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date evenHourDateBefore(Date date) {
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date != null ? date : new Date());
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date evenMinuteDateAfterNow() {
        return DateBuilder.evenMinuteDate(null);
    }

    public static Date evenMinuteDate(Date date) {
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date != null ? date : new Date());
        calendar.setLenient(true);
        calendar.set(12, calendar.get(12) + 1);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date evenMinuteDateBefore(Date date) {
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date != null ? date : new Date());
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date evenSecondDateAfterNow() {
        return DateBuilder.evenSecondDate(null);
    }

    public static Date evenSecondDate(Date date) {
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date != null ? date : new Date());
        calendar.setLenient(true);
        calendar.set(13, calendar.get(13) + 1);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date evenSecondDateBefore(Date date) {
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date != null ? date : new Date());
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date nextGivenMinuteDate(Date date, int n) {
        if (n < 0 || n > 59) {
            throw new IllegalArgumentException("minuteBase must be >=0 and <= 59");
        }
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date != null ? date : new Date());
        calendar.setLenient(true);
        if (n == 0) {
            calendar.set(11, calendar.get(11) + 1);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
        } else {
            int n2 = calendar.get(12);
            int n3 = n2 / n;
            int n4 = n * (n3 + 1);
            if (n4 < 60) {
                calendar.set(12, n4);
                calendar.set(13, 0);
                calendar.set(14, 0);
            } else {
                calendar.set(11, calendar.get(11) + 1);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
        }
        return calendar.getTime();
    }

    public static Date nextGivenSecondDate(Date date, int n) {
        if (n < 0 || n > 59) {
            throw new IllegalArgumentException("secondBase must be >=0 and <= 59");
        }
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date != null ? date : new Date());
        calendar.setLenient(true);
        if (n == 0) {
            calendar.set(12, calendar.get(12) + 1);
            calendar.set(13, 0);
            calendar.set(14, 0);
        } else {
            int n2 = calendar.get(13);
            int n3 = n2 / n;
            int n4 = n * (n3 + 1);
            if (n4 < 60) {
                calendar.set(13, n4);
                calendar.set(14, 0);
            } else {
                calendar.set(12, calendar.get(12) + 1);
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
        }
        return calendar.getTime();
    }

    public static Date translateTime(Date date, TimeZone timeZone, TimeZone timeZone2) {
        Date date2 = new Date();
        int n = timeZone2.getOffset(date.getTime()) - timeZone.getOffset(date.getTime());
        date2.setTime(date.getTime() - (long)n);
        return date2;
    }

    public static void validateDayOfWeek(DayOfWeek dayOfWeek) {
        ValueEnforcer.notNull(dayOfWeek, "DayOfWeek");
    }

    public static void validateHour(int n) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException("Invalid hour (must be >= 0 and <= 23).");
        }
    }

    public static void validateMinute(int n) {
        if (n < 0 || n > 59) {
            throw new IllegalArgumentException("Invalid minute (must be >= 0 and <= 59).");
        }
    }

    public static void validateSecond(int n) {
        if (n < 0 || n > 59) {
            throw new IllegalArgumentException("Invalid second (must be >= 0 and <= 59).");
        }
    }

    public static void validateDayOfMonth(int n) {
        if (n < 1 || n > 31) {
            throw new IllegalArgumentException("Invalid day of month.");
        }
    }

    public static void validateMonth(Month month) {
        ValueEnforcer.notNull(month, "Month");
    }

    public static void validateYear(int n) {
        if (n < 0 || n > CQuartz.MAX_YEAR) {
            throw new IllegalArgumentException("Invalid year (must be >= 0 and <= " + CQuartz.MAX_YEAR);
        }
    }
}

