/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz;

import com.helger.quartz.SchedulerException;
import java.io.Serializable;
import java.util.Date;

public class SchedulerMetaData
implements Serializable {
    private final String m_sSchedName;
    private final String m_sSchedInst;
    private final Class<?> m_sSchedClass;
    private final boolean m_bStarted;
    private final boolean m_bIsInStandbyMode;
    private final boolean m_bShutdown;
    private final Date m_aStartTime;
    private final int m_nNumJobsExec;
    private final Class<?> m_aJsClass;
    private final boolean m_bJsPersistent;
    private final boolean m_bJsClustered;
    private final Class<?> m_aTpClass;
    private final int m_nTpSize;
    private final String m_sVersion;

    public SchedulerMetaData(String string, String string2, Class<?> clazz, boolean bl, boolean bl2, boolean bl3, Date date, int n, Class<?> clazz2, boolean bl4, boolean bl5, Class<?> clazz3, int n2, String string3) {
        this.m_sSchedName = string;
        this.m_sSchedInst = string2;
        this.m_sSchedClass = clazz;
        this.m_bStarted = bl;
        this.m_bIsInStandbyMode = bl2;
        this.m_bShutdown = bl3;
        this.m_aStartTime = date;
        this.m_nNumJobsExec = n;
        this.m_aJsClass = clazz2;
        this.m_bJsPersistent = bl4;
        this.m_bJsClustered = bl5;
        this.m_aTpClass = clazz3;
        this.m_nTpSize = n2;
        this.m_sVersion = string3;
    }

    public String getSchedulerName() {
        return this.m_sSchedName;
    }

    public String getSchedulerInstanceId() {
        return this.m_sSchedInst;
    }

    public Class<?> getSchedulerClass() {
        return this.m_sSchedClass;
    }

    public Date getRunningSince() {
        return this.m_aStartTime;
    }

    public int getNumberOfJobsExecuted() {
        return this.m_nNumJobsExec;
    }

    public boolean isStarted() {
        return this.m_bStarted;
    }

    public boolean isInStandbyMode() {
        return this.m_bIsInStandbyMode;
    }

    public boolean isShutdown() {
        return this.m_bShutdown;
    }

    public Class<?> getJobStoreClass() {
        return this.m_aJsClass;
    }

    public boolean isJobStoreSupportsPersistence() {
        return this.m_bJsPersistent;
    }

    public boolean isJobStoreClustered() {
        return this.m_bJsClustered;
    }

    public Class<?> getThreadPoolClass() {
        return this.m_aTpClass;
    }

    public int getThreadPoolSize() {
        return this.m_nTpSize;
    }

    public String getVersion() {
        return this.m_sVersion;
    }

    public String toString() {
        try {
            return this.getSummary();
        }
        catch (SchedulerException schedulerException) {
            return "SchedulerMetaData: undeterminable.";
        }
    }

    public String getSummary() throws SchedulerException {
        StringBuilder stringBuilder = new StringBuilder("Mini Quartz Scheduler (v");
        stringBuilder.append(this.getVersion());
        stringBuilder.append(") '");
        stringBuilder.append(this.getSchedulerName());
        stringBuilder.append("' with instanceId '");
        stringBuilder.append(this.getSchedulerInstanceId());
        stringBuilder.append("'\n");
        stringBuilder.append("  Scheduler class: '");
        stringBuilder.append(this.getSchedulerClass().getName());
        stringBuilder.append("'");
        stringBuilder.append(" - running locally.");
        stringBuilder.append("\n");
        if (!this.isShutdown()) {
            if (this.getRunningSince() != null) {
                stringBuilder.append("  Running since: ");
                stringBuilder.append(this.getRunningSince());
            } else {
                stringBuilder.append("  NOT STARTED.");
            }
            stringBuilder.append("\n");
            if (this.isInStandbyMode()) {
                stringBuilder.append("  Currently in standby mode.");
            } else {
                stringBuilder.append("  Not currently in standby mode.");
            }
        } else {
            stringBuilder.append("  Scheduler has been SHUTDOWN.");
        }
        stringBuilder.append("\n");
        stringBuilder.append("  Number of jobs executed: ");
        stringBuilder.append(this.getNumberOfJobsExecuted());
        stringBuilder.append("\n");
        stringBuilder.append("  Using thread pool '");
        stringBuilder.append(this.getThreadPoolClass().getName());
        stringBuilder.append("' - with ");
        stringBuilder.append(this.getThreadPoolSize());
        stringBuilder.append(" threads.");
        stringBuilder.append("\n");
        stringBuilder.append("  Using job-store '");
        stringBuilder.append(this.getJobStoreClass().getName());
        stringBuilder.append("' - which ");
        if (this.isJobStoreSupportsPersistence()) {
            stringBuilder.append("supports persistence.");
        } else {
            stringBuilder.append("does not support persistence.");
        }
        if (this.isJobStoreClustered()) {
            stringBuilder.append(" and is clustered.");
        } else {
            stringBuilder.append(" and is not clustered.");
        }
        stringBuilder.append("\n");
        return stringBuilder.toString();
    }
}

