/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz;

import com.helger.commons.datetime.PDTFactory;
import com.helger.commons.hashcode.HashCodeGenerator;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TimeOfDay
implements Serializable,
Comparable<TimeOfDay> {
    public static final TimeOfDay START_OF_DAY = new TimeOfDay(0, 0, 0);
    private final int m_nHour;
    private final int m_nMinute;
    private final int m_nSecond;

    public TimeOfDay(int n, int n2, int n3) {
        this.m_nHour = n;
        this.m_nMinute = n2;
        this.m_nSecond = n3;
        this._validate();
    }

    private void _validate() {
        if (this.m_nHour < 0 || this.m_nHour > 23) {
            throw new IllegalArgumentException("Hour must be from 0 to 23");
        }
        if (this.m_nMinute < 0 || this.m_nMinute > 59) {
            throw new IllegalArgumentException("Minute must be from 0 to 59");
        }
        if (this.m_nSecond < 0 || this.m_nSecond > 59) {
            throw new IllegalArgumentException("Second must be from 0 to 59");
        }
    }

    public int getHour() {
        return this.m_nHour;
    }

    public int getMinute() {
        return this.m_nMinute;
    }

    public int getSecond() {
        return this.m_nSecond;
    }

    @Override
    public int compareTo(@Nonnull TimeOfDay timeOfDay) {
        int n = this.m_nHour - timeOfDay.m_nHour;
        if (n == 0 && (n = this.m_nMinute - timeOfDay.m_nMinute) == 0) {
            n = this.m_nSecond - timeOfDay.m_nSecond;
        }
        return n;
    }

    public boolean before(TimeOfDay timeOfDay) {
        return this.compareTo(timeOfDay) < 0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        TimeOfDay timeOfDay = (TimeOfDay)object;
        return timeOfDay.m_nHour == this.m_nHour && timeOfDay.m_nMinute == this.m_nMinute && timeOfDay.m_nSecond == this.m_nSecond;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nHour).append(this.m_nMinute).append(this.m_nSecond).getHashCode();
    }

    @Nullable
    public Date getTimeOfDayForDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date);
        calendar.set(11, this.m_nHour);
        calendar.set(12, this.m_nMinute);
        calendar.set(13, this.m_nSecond);
        calendar.clear(14);
        return calendar.getTime();
    }

    public String toString() {
        return "TimeOfDay[" + this.m_nHour + ":" + this.m_nMinute + ":" + this.m_nSecond + "]";
    }

    @Nonnull
    public static TimeOfDay hourMinuteAndSecondOfDay(int n, int n2, int n3) {
        return new TimeOfDay(n, n2, n3);
    }

    @Nonnull
    public static TimeOfDay hourAndMinuteOfDay(int n, int n2) {
        return new TimeOfDay(n, n2, 0);
    }

    @Nonnull
    public static TimeOfDay hourOfDay(int n) {
        return new TimeOfDay(n, 0, 0);
    }

    @Nullable
    public static TimeOfDay hourAndMinuteAndSecondFromDate(@Nullable Date date) {
        return TimeOfDay.hourAndMinuteAndSecondFromDate(date, null);
    }

    @Nullable
    public static TimeOfDay hourAndMinuteAndSecondFromDate(@Nullable Date date, @Nullable TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date);
        if (timeZone != null) {
            calendar.setTimeZone(timeZone);
        }
        return new TimeOfDay(calendar.get(11), calendar.get(12), calendar.get(13));
    }

    @Nullable
    public static TimeOfDay hourAndMinuteFromDate(@Nullable Date date) {
        return TimeOfDay.hourAndMinuteFromDate(date, null);
    }

    @Nullable
    public static TimeOfDay hourAndMinuteFromDate(@Nullable Date date, @Nullable TimeZone timeZone) {
        if (date == null) {
            return null;
        }
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date);
        if (timeZone != null) {
            calendar.setTimeZone(timeZone);
        }
        return new TimeOfDay(calendar.get(11), calendar.get(12), 0);
    }
}

