/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz;

import com.helger.commons.lang.GenericReflection;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobKey;
import com.helger.quartz.SimpleScheduleBuilder;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.spi.IMutableTrigger;
import com.helger.quartz.utils.Key;
import java.util.Date;
import javax.annotation.Nonnull;

public class TriggerBuilder<T extends ITrigger> {
    private TriggerKey m_aKey;
    private String m_sDescription;
    private Date m_aStartTime = new Date();
    private Date m_aEndTime;
    private int m_nPriority = 5;
    private String m_sCalendarName;
    private JobKey m_aJobKey;
    private JobDataMap m_aJobDataMap = new JobDataMap();
    private IScheduleBuilder<? extends IMutableTrigger> m_aScheduleBuilder;

    private TriggerBuilder() {
    }

    @Nonnull
    public static TriggerBuilder<IMutableTrigger> newTrigger() {
        return new TriggerBuilder<IMutableTrigger>();
    }

    @Nonnull
    public T build() {
        if (this.m_aScheduleBuilder == null) {
            this.m_aScheduleBuilder = SimpleScheduleBuilder.simpleSchedule();
        }
        IMutableTrigger iMutableTrigger = this.m_aScheduleBuilder.build();
        iMutableTrigger.setCalendarName(this.m_sCalendarName);
        iMutableTrigger.setDescription(this.m_sDescription);
        iMutableTrigger.setStartTime(this.m_aStartTime);
        iMutableTrigger.setEndTime(this.m_aEndTime);
        if (this.m_aKey == null) {
            this.m_aKey = new TriggerKey(Key.createUniqueName(null), null);
        }
        iMutableTrigger.setKey(this.m_aKey);
        if (this.m_aJobKey != null) {
            iMutableTrigger.setJobKey(this.m_aJobKey);
        }
        iMutableTrigger.setPriority(this.m_nPriority);
        if (!this.m_aJobDataMap.isEmpty()) {
            iMutableTrigger.setJobDataMap(this.m_aJobDataMap);
        }
        return (T)((ITrigger)GenericReflection.uncheckedCast(iMutableTrigger));
    }

    @Nonnull
    public TriggerBuilder<T> withIdentity(String string) {
        this.m_aKey = new TriggerKey(string, null);
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> withIdentity(String string, String string2) {
        this.m_aKey = new TriggerKey(string, string2);
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> withIdentity(TriggerKey triggerKey) {
        this.m_aKey = triggerKey;
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> withDescription(String string) {
        this.m_sDescription = string;
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> withPriority(int n) {
        this.m_nPriority = n;
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> modifiedByCalendar(String string) {
        this.m_sCalendarName = string;
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> startAt(Date date) {
        this.m_aStartTime = date;
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> startNow() {
        return this.startAt(new Date());
    }

    @Nonnull
    public TriggerBuilder<T> endAt(Date date) {
        this.m_aEndTime = date;
        return this;
    }

    @Nonnull
    public <SBT extends IMutableTrigger> TriggerBuilder<SBT> withSchedule(IScheduleBuilder<SBT> iScheduleBuilder) {
        this.m_aScheduleBuilder = iScheduleBuilder;
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> forJob(JobKey jobKey) {
        this.m_aJobKey = jobKey;
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> forJob(String string) {
        this.m_aJobKey = new JobKey(string, null);
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> forJob(String string, String string2) {
        this.m_aJobKey = new JobKey(string, string2);
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> forJob(@Nonnull IJobDetail iJobDetail) {
        JobKey jobKey = iJobDetail.getKey();
        if (jobKey.getName() == null) {
            throw new IllegalArgumentException("The given job has not yet had a name assigned to it.");
        }
        this.m_aJobKey = jobKey;
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> usingJobData(String string, String string2) {
        this.m_aJobDataMap.put(string, string2);
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> usingJobData(String string, Integer n) {
        this.m_aJobDataMap.put(string, n);
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> usingJobData(String string, Long l) {
        this.m_aJobDataMap.put(string, l);
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> usingJobData(String string, Float f) {
        this.m_aJobDataMap.put(string, f);
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> usingJobData(String string, Double d) {
        this.m_aJobDataMap.put(string, d);
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> usingJobData(String string, Boolean bl) {
        this.m_aJobDataMap.put(string, bl);
        return this;
    }

    @Nonnull
    public TriggerBuilder<T> usingJobData(JobDataMap jobDataMap) {
        jobDataMap.putAll(this.m_aJobDataMap);
        this.m_aJobDataMap = jobDataMap;
        return this;
    }
}

