/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.quartz.ICalendar;
import com.helger.quartz.spi.IOperableTrigger;
import java.util.Date;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TriggerUtils {
    private TriggerUtils() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsList<Date> computeFireTimes(IOperableTrigger iOperableTrigger, ICalendar iCalendar, int n) {
        Date date;
        CommonsArrayList<Date> commonsArrayList = new CommonsArrayList<Date>();
        IOperableTrigger iOperableTrigger2 = iOperableTrigger.getClone();
        if (iOperableTrigger2.getNextFireTime() == null) {
            iOperableTrigger2.computeFirstFireTime(iCalendar);
        }
        for (int i = 0; i < n && (date = iOperableTrigger2.getNextFireTime()) != null; ++i) {
            commonsArrayList.add(date);
            iOperableTrigger2.triggered(iCalendar);
        }
        return commonsArrayList;
    }

    public static Date computeEndTimeToAllowParticularNumberOfFirings(IOperableTrigger iOperableTrigger, ICalendar iCalendar, int n) {
        Date date;
        IOperableTrigger iOperableTrigger2 = iOperableTrigger.getClone();
        if (iOperableTrigger2.getNextFireTime() == null) {
            iOperableTrigger2.computeFirstFireTime(iCalendar);
        }
        int n2 = 0;
        Date date2 = null;
        for (int i = 0; i < n && (date = iOperableTrigger2.getNextFireTime()) != null; ++i) {
            iOperableTrigger2.triggered(iCalendar);
            if (++n2 != n) continue;
            date2 = date;
        }
        if (date2 == null) {
            return null;
        }
        date2 = new Date(date2.getTime() + 1000L);
        return date2;
    }

    public static ICommonsList<Date> computeFireTimesBetween(IOperableTrigger iOperableTrigger, ICalendar iCalendar, Date date, Date date2) {
        Date date3;
        CommonsArrayList<Date> commonsArrayList = new CommonsArrayList<Date>();
        IOperableTrigger iOperableTrigger2 = iOperableTrigger.getClone();
        if (iOperableTrigger2.getNextFireTime() == null) {
            iOperableTrigger2.setStartTime(date);
            iOperableTrigger2.setEndTime(date2);
            iOperableTrigger2.computeFirstFireTime(iCalendar);
        }
        while ((date3 = iOperableTrigger2.getNextFireTime()) != null) {
            if (date3.before(date)) {
                iOperableTrigger2.triggered(iCalendar);
                continue;
            }
            if (date3.after(date2)) break;
            commonsArrayList.add(date3);
            iOperableTrigger2.triggered(iCalendar);
        }
        return commonsArrayList;
    }
}

