/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.core;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IJobListener;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.spi.IOperableTrigger;
import java.util.concurrent.atomic.AtomicInteger;

class ExecutingJobsManager
implements IJobListener {
    private final ICommonsMap<String, IJobExecutionContext> m_aExecutingJobs = new CommonsHashMap<String, IJobExecutionContext>();
    private final AtomicInteger m_aNumJobsFired = new AtomicInteger(0);

    ExecutingJobsManager() {
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumJobsCurrentlyExecuting() {
        ICommonsMap<String, IJobExecutionContext> iCommonsMap = this.m_aExecutingJobs;
        synchronized (iCommonsMap) {
            return this.m_aExecutingJobs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobToBeExecuted(IJobExecutionContext iJobExecutionContext) {
        this.m_aNumJobsFired.incrementAndGet();
        ICommonsMap<String, IJobExecutionContext> iCommonsMap = this.m_aExecutingJobs;
        synchronized (iCommonsMap) {
            this.m_aExecutingJobs.put(((IOperableTrigger)iJobExecutionContext.getTrigger()).getFireInstanceId(), iJobExecutionContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void jobWasExecuted(IJobExecutionContext iJobExecutionContext, JobExecutionException jobExecutionException) {
        ICommonsMap<String, IJobExecutionContext> iCommonsMap = this.m_aExecutingJobs;
        synchronized (iCommonsMap) {
            this.m_aExecutingJobs.remove(((IOperableTrigger)iJobExecutionContext.getTrigger()).getFireInstanceId());
        }
    }

    public int getNumJobsFired() {
        return this.m_aNumJobsFired.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommonsList<IJobExecutionContext> getExecutingJobs() {
        ICommonsMap<String, IJobExecutionContext> iCommonsMap = this.m_aExecutingJobs;
        synchronized (iCommonsMap) {
            return new CommonsArrayList(this.m_aExecutingJobs.values());
        }
    }

    @Override
    public void jobExecutionVetoed(IJobExecutionContext iJobExecutionContext) {
    }
}

