/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.core;

import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.quartz.ICalendar;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobKey;
import com.helger.quartz.SchedulerContext;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.UnableToInterruptJobException;
import com.helger.quartz.impl.matchers.GroupMatcher;
import com.helger.quartz.spi.IOperableTrigger;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface IQuartzScheduler
extends Serializable {
    public String getSchedulerName();

    public String getSchedulerInstanceId();

    public SchedulerContext getSchedulerContext() throws SchedulerException;

    public void start() throws SchedulerException;

    public void startDelayed(int var1) throws SchedulerException;

    public void standby();

    public boolean isInStandbyMode();

    public void shutdown();

    public void shutdown(boolean var1);

    public boolean isShutdown();

    public Date runningSince();

    public String getVersion();

    public int numJobsExecuted();

    public Class<?> getJobStoreClass();

    public boolean supportsPersistence();

    public boolean isClustered();

    public Class<?> getThreadPoolClass();

    public int getThreadPoolSize();

    public void clear() throws SchedulerException;

    public ICommonsList<IJobExecutionContext> getCurrentlyExecutingJobs() throws SchedulerException;

    public Date scheduleJob(IJobDetail var1, ITrigger var2) throws SchedulerException;

    public Date scheduleJob(ITrigger var1) throws SchedulerException;

    public void addJob(IJobDetail var1, boolean var2) throws SchedulerException;

    public void addJob(IJobDetail var1, boolean var2, boolean var3) throws SchedulerException;

    public boolean deleteJob(JobKey var1) throws SchedulerException;

    public boolean unscheduleJob(TriggerKey var1) throws SchedulerException;

    public Date rescheduleJob(TriggerKey var1, ITrigger var2) throws SchedulerException;

    public void triggerJob(JobKey var1, JobDataMap var2) throws SchedulerException;

    public void triggerJob(IOperableTrigger var1) throws SchedulerException;

    public void pauseTrigger(TriggerKey var1) throws SchedulerException;

    public void pauseTriggers(GroupMatcher<TriggerKey> var1) throws SchedulerException;

    public void pauseJob(JobKey var1) throws SchedulerException;

    public void pauseJobs(GroupMatcher<JobKey> var1) throws SchedulerException;

    public void resumeTrigger(TriggerKey var1) throws SchedulerException;

    public void resumeTriggers(GroupMatcher<TriggerKey> var1) throws SchedulerException;

    public ICommonsSet<String> getPausedTriggerGroups() throws SchedulerException;

    public void resumeJob(JobKey var1) throws SchedulerException;

    public void resumeJobs(GroupMatcher<JobKey> var1) throws SchedulerException;

    public void pauseAll() throws SchedulerException;

    public void resumeAll() throws SchedulerException;

    public ICommonsList<String> getJobGroupNames() throws SchedulerException;

    public ICommonsSet<JobKey> getJobKeys(GroupMatcher<JobKey> var1) throws SchedulerException;

    public ICommonsList<? extends ITrigger> getTriggersOfJob(JobKey var1) throws SchedulerException;

    public ICommonsList<String> getTriggerGroupNames() throws SchedulerException;

    public ICommonsSet<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> var1) throws SchedulerException;

    public IJobDetail getJobDetail(JobKey var1) throws SchedulerException;

    public ITrigger getTrigger(TriggerKey var1) throws SchedulerException;

    public ITrigger.ETriggerState getTriggerState(TriggerKey var1) throws SchedulerException;

    public void addCalendar(String var1, ICalendar var2, boolean var3, boolean var4) throws SchedulerException;

    public boolean deleteCalendar(String var1) throws SchedulerException;

    public ICalendar getCalendar(String var1) throws SchedulerException;

    public ICommonsList<String> getCalendarNames() throws SchedulerException;

    public boolean interrupt(JobKey var1) throws UnableToInterruptJobException;

    public boolean interrupt(String var1) throws UnableToInterruptJobException;

    public boolean checkExists(JobKey var1) throws SchedulerException;

    public boolean checkExists(TriggerKey var1) throws SchedulerException;

    public boolean deleteJobs(List<JobKey> var1) throws SchedulerException;

    public void scheduleJobs(Map<IJobDetail, Set<? extends ITrigger>> var1, boolean var2) throws SchedulerException;

    public void scheduleJob(IJobDetail var1, Set<? extends ITrigger> var2, boolean var3) throws SchedulerException;

    public boolean unscheduleJobs(List<TriggerKey> var1) throws SchedulerException;
}

