/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.core;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsLinkedList;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.lang.NonBlockingProperties;
import com.helger.commons.lang.PropertiesHelper;
import com.helger.commons.string.StringHelper;
import com.helger.quartz.ICalendar;
import com.helger.quartz.IInterruptableJob;
import com.helger.quartz.IJob;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IJobListener;
import com.helger.quartz.IListenerManager;
import com.helger.quartz.IMatcher;
import com.helger.quartz.ISchedulerListener;
import com.helger.quartz.ITrigger;
import com.helger.quartz.ITriggerListener;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.JobKey;
import com.helger.quartz.ObjectAlreadyExistsException;
import com.helger.quartz.SchedulerContext;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.SchedulerMetaData;
import com.helger.quartz.TriggerBuilder;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.UnableToInterruptJobException;
import com.helger.quartz.core.ErrorLogger;
import com.helger.quartz.core.ExecutingJobsManager;
import com.helger.quartz.core.IQuartzScheduler;
import com.helger.quartz.core.ListenerManager;
import com.helger.quartz.core.QuartzSchedulerResources;
import com.helger.quartz.core.QuartzSchedulerThread;
import com.helger.quartz.core.SchedulerSignaler;
import com.helger.quartz.impl.SchedulerRepository;
import com.helger.quartz.impl.matchers.GroupMatcher;
import com.helger.quartz.simpl.PropertySettingJobFactory;
import com.helger.quartz.spi.IJobFactory;
import com.helger.quartz.spi.IOperableTrigger;
import com.helger.quartz.spi.ISchedulerPlugin;
import com.helger.quartz.spi.ISchedulerSignaler;
import com.helger.quartz.spi.IThreadExecutor;
import com.helger.quartz.utils.Key;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuartzScheduler
implements IQuartzScheduler {
    private static final Logger LOGGER = LoggerFactory.getLogger(QuartzScheduler.class);
    private static final String VERSION_MAJOR;
    private static final String VERSION_MINOR;
    private static final String VERSION_ITERATION;
    private final QuartzSchedulerResources m_aResources;
    private final QuartzSchedulerThread m_aSchedThread;
    private ThreadGroup m_aThreadGroup;
    private final SchedulerContext m_aContext = new SchedulerContext();
    private final IListenerManager m_aListenerManager = new ListenerManager();
    private final ICommonsMap<String, IJobListener> m_aInternalJobListeners = new CommonsHashMap<String, IJobListener>(10);
    private final ICommonsMap<String, ITriggerListener> m_aInternalTriggerListeners = new CommonsHashMap<String, ITriggerListener>(10);
    private final ICommonsList<ISchedulerListener> m_aInternalSchedulerListeners = new CommonsArrayList<int>(10);
    private IJobFactory m_aJobFactory = new PropertySettingJobFactory();
    private final ExecutingJobsManager m_aJobMgr;
    private final ErrorLogger m_aErrLogger;
    private final ISchedulerSignaler m_aSignaler;
    private final Random m_aRandom = new Random();
    private final ICommonsList<Object> holdToPreventGC = new CommonsArrayList<int>(5);
    private boolean m_bSignalOnSchedulingChange = true;
    private volatile boolean m_bClosed = false;
    private volatile boolean m_bShuttingDown = false;
    private Date m_aInitialStart;

    public QuartzScheduler(QuartzSchedulerResources quartzSchedulerResources, long l) throws SchedulerException {
        this.m_aResources = quartzSchedulerResources;
        if (quartzSchedulerResources.getJobStore() instanceof IJobListener) {
            this.addInternalJobListener((IJobListener)((Object)quartzSchedulerResources.getJobStore()));
        }
        this.m_aSchedThread = new QuartzSchedulerThread(this, quartzSchedulerResources);
        IThreadExecutor iThreadExecutor = quartzSchedulerResources.getThreadExecutor();
        iThreadExecutor.execute(this.m_aSchedThread);
        if (l > 0L) {
            this.m_aSchedThread.setIdleWaitTime(l);
        }
        this.m_aJobMgr = new ExecutingJobsManager();
        this.addInternalJobListener(this.m_aJobMgr);
        this.m_aErrLogger = new ErrorLogger();
        this.addInternalSchedulerListener(this.m_aErrLogger);
        this.m_aSignaler = new SchedulerSignaler(this, this.m_aSchedThread);
        LOGGER.info("Mini Quartz Scheduler v." + this.getVersion() + " created.");
    }

    public void initialize() throws SchedulerException {
        LOGGER.info("Scheduler meta-data: " + new SchedulerMetaData(this.getSchedulerName(), this.getSchedulerInstanceId(), this.getClass(), this.runningSince() != null, this.isInStandbyMode(), this.isShutdown(), this.runningSince(), this.numJobsExecuted(), this.getJobStoreClass(), this.supportsPersistence(), this.isClustered(), this.getThreadPoolClass(), this.getThreadPoolSize(), this.getVersion()).toString());
    }

    @Override
    public String getVersion() {
        return QuartzScheduler.getVersionMajor() + "." + QuartzScheduler.getVersionMinor() + "." + QuartzScheduler.getVersionIteration();
    }

    public static String getVersionMajor() {
        return VERSION_MAJOR;
    }

    public static String getVersionMinor() {
        return VERSION_MINOR;
    }

    public static String getVersionIteration() {
        return VERSION_ITERATION;
    }

    public ISchedulerSignaler getSchedulerSignaler() {
        return this.m_aSignaler;
    }

    @Override
    public String getSchedulerName() {
        return this.m_aResources.getName();
    }

    @Override
    public String getSchedulerInstanceId() {
        return this.m_aResources.getInstanceId();
    }

    public ThreadGroup getSchedulerThreadGroup() {
        if (this.m_aThreadGroup == null) {
            this.m_aThreadGroup = new ThreadGroup("MiniQuartzScheduler:" + this.getSchedulerName());
            if (this.m_aResources.getMakeSchedulerThreadDaemon()) {
                this.m_aThreadGroup.setDaemon(true);
            }
        }
        return this.m_aThreadGroup;
    }

    public void addNoGCObject(Object object) {
        this.holdToPreventGC.add(object);
    }

    public boolean removeNoGCObject(Object object) {
        return this.holdToPreventGC.remove(object);
    }

    @Override
    public SchedulerContext getSchedulerContext() throws SchedulerException {
        return this.m_aContext;
    }

    public boolean isSignalOnSchedulingChange() {
        return this.m_bSignalOnSchedulingChange;
    }

    public void setSignalOnSchedulingChange(boolean bl) {
        this.m_bSignalOnSchedulingChange = bl;
    }

    @Override
    public void start() throws SchedulerException {
        if (this.m_bShuttingDown || this.m_bClosed) {
            throw new SchedulerException("The Scheduler cannot be restarted after shutdown() has been called.");
        }
        this.notifySchedulerListenersStarting();
        if (this.m_aInitialStart == null) {
            this.m_aInitialStart = new Date();
            this.m_aResources.getJobStore().schedulerStarted();
            this._startPlugins();
        } else {
            this.m_aResources.getJobStore().schedulerResumed();
        }
        this.m_aSchedThread.togglePause(false);
        LOGGER.info("Scheduler " + this.m_aResources.getUniqueIdentifier() + " started.");
        this.notifySchedulerListenersStarted();
    }

    @Override
    public void startDelayed(int n) throws SchedulerException {
        if (this.m_bShuttingDown || this.m_bClosed) {
            throw new SchedulerException("The Scheduler cannot be restarted after shutdown() has been called.");
        }
        Thread thread = new Thread(() -> {
            try {
                Thread.sleep((long)n * 1000L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            try {
                this.start();
            }
            catch (SchedulerException schedulerException) {
                LOGGER.error("Unable to start secheduler after startup delay.", schedulerException);
            }
        });
        thread.start();
    }

    @Override
    public void standby() {
        this.m_aResources.getJobStore().schedulerPaused();
        this.m_aSchedThread.togglePause(true);
        LOGGER.info("Scheduler " + this.m_aResources.getUniqueIdentifier() + " paused.");
        this.notifySchedulerListenersInStandbyMode();
    }

    @Override
    public boolean isInStandbyMode() {
        return this.m_aSchedThread.isPaused();
    }

    @Override
    public Date runningSince() {
        if (this.m_aInitialStart == null) {
            return null;
        }
        return new Date(this.m_aInitialStart.getTime());
    }

    @Override
    public int numJobsExecuted() {
        return this.m_aJobMgr.getNumJobsFired();
    }

    @Override
    public Class<?> getJobStoreClass() {
        return this.m_aResources.getJobStore().getClass();
    }

    @Override
    public boolean supportsPersistence() {
        return this.m_aResources.getJobStore().supportsPersistence();
    }

    @Override
    public boolean isClustered() {
        return this.m_aResources.getJobStore().isClustered();
    }

    @Override
    public Class<?> getThreadPoolClass() {
        return this.m_aResources.getThreadPool().getClass();
    }

    @Override
    public int getThreadPoolSize() {
        return this.m_aResources.getThreadPool().getPoolSize();
    }

    @Override
    public void shutdown() {
        this.shutdown(false);
    }

    @Override
    public void shutdown(boolean bl) {
        if (this.m_bShuttingDown || this.m_bClosed) {
            return;
        }
        this.m_bShuttingDown = true;
        LOGGER.info("Scheduler " + this.m_aResources.getUniqueIdentifier() + " shutting down.");
        this.standby();
        this.m_aSchedThread.halt(bl);
        this.notifySchedulerListenersShuttingdown();
        if (this.m_aResources.isInterruptJobsOnShutdown() && !bl || this.m_aResources.isInterruptJobsOnShutdownWithWait() && bl) {
            ICommonsList<IJobExecutionContext> iCommonsList = this.getCurrentlyExecutingJobs();
            for (IJobExecutionContext iJobExecutionContext : iCommonsList) {
                if (!(iJobExecutionContext.getJobInstance() instanceof IInterruptableJob)) continue;
                try {
                    ((IInterruptableJob)iJobExecutionContext.getJobInstance()).interrupt();
                }
                catch (Exception exception) {
                    LOGGER.warn("Encountered error when interrupting job " + iJobExecutionContext.getJobDetail().getKey() + " during shutdown", exception);
                }
            }
        }
        this.m_aResources.getThreadPool().shutdown(bl);
        this.m_bClosed = true;
        this._shutdownPlugins();
        this.m_aResources.getJobStore().shutdown();
        this.notifySchedulerListenersShutdown();
        SchedulerRepository.getInstance().remove(this.m_aResources.getName());
        this.holdToPreventGC.clear();
        LOGGER.info("Scheduler " + this.m_aResources.getUniqueIdentifier() + " shutdown complete.");
    }

    @Override
    public boolean isShutdown() {
        return this.m_bClosed;
    }

    public boolean isShuttingDown() {
        return this.m_bShuttingDown;
    }

    public boolean isStarted() {
        return !this.m_bShuttingDown && !this.m_bClosed && !this.isInStandbyMode() && this.m_aInitialStart != null;
    }

    public void validateState() throws SchedulerException {
        if (this.isShutdown()) {
            throw new SchedulerException("The Scheduler has been shutdown.");
        }
    }

    @Override
    public ICommonsList<IJobExecutionContext> getCurrentlyExecutingJobs() {
        return this.m_aJobMgr.getExecutingJobs();
    }

    @Override
    public Date scheduleJob(IJobDetail iJobDetail, ITrigger iTrigger) throws SchedulerException {
        Date date;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("scheduleJob (" + iJobDetail + ", " + iTrigger + ")");
        }
        this.validateState();
        if (iJobDetail == null) {
            throw new SchedulerException("JobDetail cannot be null");
        }
        if (iTrigger == null) {
            throw new SchedulerException("Trigger cannot be null");
        }
        if (iJobDetail.getKey() == null) {
            throw new SchedulerException("Job's key cannot be null");
        }
        if (iJobDetail.getJobClass() == null) {
            throw new SchedulerException("Job's class cannot be null");
        }
        IOperableTrigger iOperableTrigger = (IOperableTrigger)iTrigger;
        if (iTrigger.getJobKey() == null) {
            iOperableTrigger.setJobKey(iJobDetail.getKey());
        } else if (!iTrigger.getJobKey().equals(iJobDetail.getKey())) {
            throw new SchedulerException("Trigger does not reference given job!");
        }
        iOperableTrigger.validate();
        ICalendar iCalendar = null;
        if (iTrigger.getCalendarName() != null) {
            iCalendar = this.m_aResources.getJobStore().retrieveCalendar(iTrigger.getCalendarName());
        }
        if ((date = iOperableTrigger.computeFirstFireTime(iCalendar)) == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger '" + iTrigger.getKey() + "' will never fire.");
        }
        this.m_aResources.getJobStore().storeJobAndTrigger(iJobDetail, iOperableTrigger);
        this.notifySchedulerListenersJobAdded(iJobDetail);
        this.notifySchedulerThread(iTrigger.getNextFireTime().getTime());
        this.notifySchedulerListenersSchduled(iTrigger);
        return date;
    }

    @Override
    public Date scheduleJob(ITrigger iTrigger) throws SchedulerException {
        this.validateState();
        if (iTrigger == null) {
            throw new SchedulerException("Trigger cannot be null");
        }
        IOperableTrigger iOperableTrigger = (IOperableTrigger)iTrigger;
        iOperableTrigger.validate();
        ICalendar iCalendar = null;
        if (iTrigger.getCalendarName() != null && (iCalendar = this.m_aResources.getJobStore().retrieveCalendar(iTrigger.getCalendarName())) == null) {
            throw new SchedulerException("Calendar not found: " + iTrigger.getCalendarName());
        }
        Date date = iOperableTrigger.computeFirstFireTime(iCalendar);
        if (date == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger '" + iTrigger.getKey() + "' will never fire.");
        }
        this.m_aResources.getJobStore().storeTrigger(iOperableTrigger, false);
        this.notifySchedulerThread(iTrigger.getNextFireTime().getTime());
        this.notifySchedulerListenersSchduled(iTrigger);
        return date;
    }

    @Override
    public void addJob(IJobDetail iJobDetail, boolean bl) throws SchedulerException {
        this.addJob(iJobDetail, bl, false);
    }

    @Override
    public void addJob(IJobDetail iJobDetail, boolean bl, boolean bl2) throws SchedulerException {
        this.validateState();
        if (!bl2 && !iJobDetail.isDurable()) {
            throw new SchedulerException("Jobs added with no trigger must be durable.");
        }
        this.m_aResources.getJobStore().storeJob(iJobDetail, bl);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersJobAdded(iJobDetail);
    }

    @Override
    public boolean deleteJob(JobKey jobKey) throws SchedulerException {
        this.validateState();
        boolean bl = false;
        ICommonsList<? extends ITrigger> iCommonsList = this.getTriggersOfJob(jobKey);
        for (ITrigger iTrigger : iCommonsList) {
            if (!this.unscheduleJob(iTrigger.getKey())) {
                StringBuilder stringBuilder = new StringBuilder().append("Unable to unschedule trigger [").append(iTrigger.getKey()).append("] while deleting job [").append(jobKey).append("]");
                throw new SchedulerException(stringBuilder.toString());
            }
            bl = true;
        }
        boolean bl2 = bl = this.m_aResources.getJobStore().removeJob(jobKey) || bl;
        if (bl) {
            this.notifySchedulerThread(0L);
            this.notifySchedulerListenersJobDeleted(jobKey);
        }
        return bl;
    }

    @Override
    public boolean deleteJobs(List<JobKey> list) throws SchedulerException {
        this.validateState();
        boolean bl = false;
        bl = this.m_aResources.getJobStore().removeJobs(list);
        this.notifySchedulerThread(0L);
        for (JobKey jobKey : list) {
            this.notifySchedulerListenersJobDeleted(jobKey);
        }
        return bl;
    }

    @Override
    public void scheduleJobs(Map<IJobDetail, Set<? extends ITrigger>> map, boolean bl) throws SchedulerException {
        this.validateState();
        for (Map.Entry<IJobDetail, Set<? extends ITrigger>> entry : map.entrySet()) {
            Set<? extends ITrigger> set;
            IJobDetail iJobDetail = entry.getKey();
            if (iJobDetail == null || (set = entry.getValue()) == null) continue;
            for (ITrigger iTrigger : set) {
                IOperableTrigger iOperableTrigger = (IOperableTrigger)iTrigger;
                iOperableTrigger.setJobKey(iJobDetail.getKey());
                iOperableTrigger.validate();
                ICalendar iCalendar = null;
                if (iTrigger.getCalendarName() != null && (iCalendar = this.m_aResources.getJobStore().retrieveCalendar(iTrigger.getCalendarName())) == null) {
                    throw new SchedulerException("Calendar '" + iTrigger.getCalendarName() + "' not found for trigger: " + iTrigger.getKey());
                }
                Date date = iOperableTrigger.computeFirstFireTime(iCalendar);
                if (date != null) continue;
                throw new SchedulerException("Based on configured schedule, the given trigger will never fire.");
            }
        }
        this.m_aResources.getJobStore().storeJobsAndTriggers(map, bl);
        this.notifySchedulerThread(0L);
        for (IJobDetail iJobDetail : map.keySet()) {
            this.notifySchedulerListenersJobAdded(iJobDetail);
        }
    }

    @Override
    public void scheduleJob(IJobDetail iJobDetail, Set<? extends ITrigger> set, boolean bl) throws SchedulerException {
        CommonsHashMap<IJobDetail, Set<? extends ITrigger>> commonsHashMap = new CommonsHashMap<IJobDetail, Set<? extends ITrigger>>();
        commonsHashMap.put(iJobDetail, set);
        this.scheduleJobs(commonsHashMap, bl);
    }

    @Override
    public boolean unscheduleJobs(List<TriggerKey> list) throws SchedulerException {
        this.validateState();
        boolean bl = false;
        bl = this.m_aResources.getJobStore().removeTriggers(list);
        this.notifySchedulerThread(0L);
        for (TriggerKey triggerKey : list) {
            this.notifySchedulerListenersUnscheduled(triggerKey);
        }
        return bl;
    }

    @Override
    public boolean unscheduleJob(TriggerKey triggerKey) throws SchedulerException {
        this.validateState();
        if (!this.m_aResources.getJobStore().removeTrigger(triggerKey)) {
            return false;
        }
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersUnscheduled(triggerKey);
        return true;
    }

    @Override
    public Date rescheduleJob(TriggerKey triggerKey, ITrigger iTrigger) throws SchedulerException {
        Date date;
        this.validateState();
        if (triggerKey == null) {
            throw new IllegalArgumentException("triggerKey cannot be null");
        }
        if (iTrigger == null) {
            throw new IllegalArgumentException("newTrigger cannot be null");
        }
        IOperableTrigger iOperableTrigger = (IOperableTrigger)iTrigger;
        ITrigger iTrigger2 = this.getTrigger(triggerKey);
        if (iTrigger2 == null) {
            return null;
        }
        iOperableTrigger.setJobKey(iTrigger2.getJobKey());
        iOperableTrigger.validate();
        ICalendar iCalendar = null;
        if (iTrigger.getCalendarName() != null) {
            iCalendar = this.m_aResources.getJobStore().retrieveCalendar(iTrigger.getCalendarName());
        }
        if ((date = iOperableTrigger.computeFirstFireTime(iCalendar)) == null) {
            throw new SchedulerException("Based on configured schedule, the given trigger will never fire.");
        }
        if (!this.m_aResources.getJobStore().replaceTrigger(triggerKey, iOperableTrigger)) {
            return null;
        }
        this.notifySchedulerThread(iTrigger.getNextFireTime().getTime());
        this.notifySchedulerListenersUnscheduled(triggerKey);
        this.notifySchedulerListenersSchduled(iTrigger);
        return date;
    }

    private String _newTriggerId() {
        long l = this.m_aRandom.nextLong();
        if (l < 0L) {
            l = -l;
        }
        return "MT_" + Long.toString(l, 30 + (int)(System.currentTimeMillis() % 7L));
    }

    @Override
    public void triggerJob(JobKey jobKey, JobDataMap jobDataMap) throws SchedulerException {
        this.validateState();
        IOperableTrigger iOperableTrigger = (IOperableTrigger)TriggerBuilder.newTrigger().withIdentity(this._newTriggerId(), "DEFAULT").forJob(jobKey).build();
        iOperableTrigger.computeFirstFireTime(null);
        if (jobDataMap != null) {
            iOperableTrigger.setJobDataMap(jobDataMap);
        }
        boolean bl = true;
        while (bl) {
            try {
                this.m_aResources.getJobStore().storeTrigger(iOperableTrigger, false);
                bl = false;
            }
            catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                iOperableTrigger.setKey(new TriggerKey(this._newTriggerId(), "DEFAULT"));
            }
        }
        this.notifySchedulerThread(iOperableTrigger.getNextFireTime().getTime());
        this.notifySchedulerListenersSchduled(iOperableTrigger);
    }

    @Override
    public void triggerJob(IOperableTrigger iOperableTrigger) throws SchedulerException {
        this.validateState();
        iOperableTrigger.computeFirstFireTime(null);
        boolean bl = true;
        while (bl) {
            try {
                this.m_aResources.getJobStore().storeTrigger(iOperableTrigger, false);
                bl = false;
            }
            catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                iOperableTrigger.setKey(new TriggerKey(this._newTriggerId(), "DEFAULT"));
            }
        }
        this.notifySchedulerThread(iOperableTrigger.getNextFireTime().getTime());
        this.notifySchedulerListenersSchduled(iOperableTrigger);
    }

    @Override
    public void pauseTrigger(TriggerKey triggerKey) throws SchedulerException {
        this.validateState();
        this.m_aResources.getJobStore().pauseTrigger(triggerKey);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersPausedTrigger(triggerKey);
    }

    private static <T extends Key<T>> GroupMatcher<T> _getOrDefault(GroupMatcher<T> groupMatcher) {
        return groupMatcher != null ? groupMatcher : GroupMatcher.groupEquals("DEFAULT");
    }

    @Override
    public void pauseTriggers(GroupMatcher<TriggerKey> groupMatcher) throws SchedulerException {
        this.validateState();
        ICommonsCollection<String> iCommonsCollection = this.m_aResources.getJobStore().pauseTriggers(QuartzScheduler._getOrDefault(groupMatcher));
        this.notifySchedulerThread(0L);
        for (String string : iCommonsCollection) {
            this.notifySchedulerListenersPausedTriggers(string);
        }
    }

    @Override
    public void pauseJob(JobKey jobKey) throws SchedulerException {
        this.validateState();
        this.m_aResources.getJobStore().pauseJob(jobKey);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersPausedJob(jobKey);
    }

    @Override
    public void pauseJobs(GroupMatcher<JobKey> groupMatcher) throws SchedulerException {
        this.validateState();
        ICommonsCollection<String> iCommonsCollection = this.m_aResources.getJobStore().pauseJobs(QuartzScheduler._getOrDefault(groupMatcher));
        this.notifySchedulerThread(0L);
        for (String string : iCommonsCollection) {
            this.notifySchedulerListenersPausedJobs(string);
        }
    }

    @Override
    public void resumeTrigger(TriggerKey triggerKey) throws SchedulerException {
        this.validateState();
        this.m_aResources.getJobStore().resumeTrigger(triggerKey);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersResumedTrigger(triggerKey);
    }

    @Override
    public void resumeTriggers(GroupMatcher<TriggerKey> groupMatcher) throws SchedulerException {
        this.validateState();
        ICommonsCollection<String> iCommonsCollection = this.m_aResources.getJobStore().resumeTriggers(QuartzScheduler._getOrDefault(groupMatcher));
        this.notifySchedulerThread(0L);
        for (String string : iCommonsCollection) {
            this.notifySchedulerListenersResumedTriggers(string);
        }
    }

    @Override
    public ICommonsSet<String> getPausedTriggerGroups() throws SchedulerException {
        return this.m_aResources.getJobStore().getPausedTriggerGroups();
    }

    @Override
    public void resumeJob(JobKey jobKey) throws SchedulerException {
        this.validateState();
        this.m_aResources.getJobStore().resumeJob(jobKey);
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersResumedJob(jobKey);
    }

    @Override
    public void resumeJobs(GroupMatcher<JobKey> groupMatcher) throws SchedulerException {
        this.validateState();
        ICommonsCollection<String> iCommonsCollection = this.m_aResources.getJobStore().resumeJobs(QuartzScheduler._getOrDefault(groupMatcher));
        this.notifySchedulerThread(0L);
        for (String string : iCommonsCollection) {
            this.notifySchedulerListenersResumedJobs(string);
        }
    }

    @Override
    public void pauseAll() throws SchedulerException {
        this.validateState();
        this.m_aResources.getJobStore().pauseAll();
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersPausedTriggers(null);
    }

    @Override
    public void resumeAll() throws SchedulerException {
        this.validateState();
        this.m_aResources.getJobStore().resumeAll();
        this.notifySchedulerThread(0L);
        this.notifySchedulerListenersResumedTrigger(null);
    }

    @Override
    public ICommonsList<String> getJobGroupNames() throws SchedulerException {
        this.validateState();
        return this.m_aResources.getJobStore().getJobGroupNames();
    }

    @Override
    public ICommonsSet<JobKey> getJobKeys(GroupMatcher<JobKey> groupMatcher) throws SchedulerException {
        this.validateState();
        return this.m_aResources.getJobStore().getJobKeys(QuartzScheduler._getOrDefault(groupMatcher));
    }

    @Override
    public ICommonsList<? extends ITrigger> getTriggersOfJob(JobKey jobKey) throws SchedulerException {
        this.validateState();
        return this.m_aResources.getJobStore().getTriggersForJob(jobKey);
    }

    @Override
    public ICommonsList<String> getTriggerGroupNames() throws SchedulerException {
        this.validateState();
        return this.m_aResources.getJobStore().getTriggerGroupNames();
    }

    @Override
    public ICommonsSet<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> groupMatcher) throws SchedulerException {
        this.validateState();
        return this.m_aResources.getJobStore().getTriggerKeys(QuartzScheduler._getOrDefault(groupMatcher));
    }

    @Override
    public IJobDetail getJobDetail(JobKey jobKey) throws SchedulerException {
        this.validateState();
        return this.m_aResources.getJobStore().retrieveJob(jobKey);
    }

    @Override
    public ITrigger getTrigger(TriggerKey triggerKey) throws SchedulerException {
        this.validateState();
        return this.m_aResources.getJobStore().retrieveTrigger(triggerKey);
    }

    @Override
    public boolean checkExists(JobKey jobKey) throws SchedulerException {
        this.validateState();
        return this.m_aResources.getJobStore().checkExists(jobKey);
    }

    @Override
    public boolean checkExists(TriggerKey triggerKey) throws SchedulerException {
        this.validateState();
        return this.m_aResources.getJobStore().checkExists(triggerKey);
    }

    @Override
    public void clear() throws SchedulerException {
        this.validateState();
        this.m_aResources.getJobStore().clearAllSchedulingData();
        this.notifySchedulerListenersUnscheduled(null);
    }

    @Override
    public ITrigger.ETriggerState getTriggerState(TriggerKey triggerKey) throws SchedulerException {
        this.validateState();
        return this.m_aResources.getJobStore().getTriggerState(triggerKey);
    }

    @Override
    public void addCalendar(String string, ICalendar iCalendar, boolean bl, boolean bl2) throws SchedulerException {
        this.validateState();
        this.m_aResources.getJobStore().storeCalendar(string, iCalendar, bl, bl2);
    }

    @Override
    public boolean deleteCalendar(String string) throws SchedulerException {
        this.validateState();
        return this.m_aResources.getJobStore().removeCalendar(string);
    }

    @Override
    public ICalendar getCalendar(String string) throws SchedulerException {
        this.validateState();
        return this.m_aResources.getJobStore().retrieveCalendar(string);
    }

    @Override
    public ICommonsList<String> getCalendarNames() throws SchedulerException {
        this.validateState();
        return this.m_aResources.getJobStore().getCalendarNames();
    }

    @Nonnull
    public IListenerManager getListenerManager() {
        return this.m_aListenerManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInternalJobListener(IJobListener iJobListener) {
        ValueEnforcer.notNull(iJobListener, "JobListener");
        ValueEnforcer.notEmpty(iJobListener.getName(), "JobListener.getName()");
        ICommonsMap<String, IJobListener> iCommonsMap = this.m_aInternalJobListeners;
        synchronized (iCommonsMap) {
            this.m_aInternalJobListeners.put(iJobListener.getName(), iJobListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInternalJobListener(String string) {
        ICommonsMap<String, IJobListener> iCommonsMap = this.m_aInternalJobListeners;
        synchronized (iCommonsMap) {
            return this.m_aInternalJobListeners.remove(string) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IJobListener> getInternalJobListeners() {
        ICommonsMap<String, IJobListener> iCommonsMap = this.m_aInternalJobListeners;
        synchronized (iCommonsMap) {
            return new CommonsLinkedList(this.m_aInternalJobListeners.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public IJobListener getInternalJobListener(String string) {
        ICommonsMap<String, IJobListener> iCommonsMap = this.m_aInternalJobListeners;
        synchronized (iCommonsMap) {
            return (IJobListener)this.m_aInternalJobListeners.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInternalTriggerListener(ITriggerListener iTriggerListener) {
        ValueEnforcer.notNull(iTriggerListener, "TriggerListener");
        ValueEnforcer.notEmpty(iTriggerListener.getName(), "TriggerListener.getName()");
        ICommonsMap<String, ITriggerListener> iCommonsMap = this.m_aInternalTriggerListeners;
        synchronized (iCommonsMap) {
            this.m_aInternalTriggerListeners.put(iTriggerListener.getName(), iTriggerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeinternalTriggerListener(String string) {
        ICommonsMap<String, ITriggerListener> iCommonsMap = this.m_aInternalTriggerListeners;
        synchronized (iCommonsMap) {
            return this.m_aInternalTriggerListeners.remove(string) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<ITriggerListener> getInternalTriggerListeners() {
        ICommonsMap<String, ITriggerListener> iCommonsMap = this.m_aInternalTriggerListeners;
        synchronized (iCommonsMap) {
            return new CommonsLinkedList(this.m_aInternalTriggerListeners.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ITriggerListener getInternalTriggerListener(String string) {
        ICommonsMap<String, ITriggerListener> iCommonsMap = this.m_aInternalTriggerListeners;
        synchronized (iCommonsMap) {
            return (ITriggerListener)this.m_aInternalTriggerListeners.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInternalSchedulerListener(ISchedulerListener iSchedulerListener) {
        ICommonsList<ISchedulerListener> iCommonsList = this.m_aInternalSchedulerListeners;
        synchronized (iCommonsList) {
            this.m_aInternalSchedulerListeners.add(iSchedulerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeInternalSchedulerListener(ISchedulerListener iSchedulerListener) {
        ICommonsList<ISchedulerListener> iCommonsList = this.m_aInternalSchedulerListeners;
        synchronized (iCommonsList) {
            return this.m_aInternalSchedulerListeners.remove(iSchedulerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommonsList<ISchedulerListener> getInternalSchedulerListeners() {
        ICommonsList<ISchedulerListener> iCommonsList = this.m_aInternalSchedulerListeners;
        synchronized (iCommonsList) {
            return new CommonsArrayList<ICommonsList<ISchedulerListener>>(this.m_aInternalSchedulerListeners);
        }
    }

    protected void notifyJobStoreJobComplete(IOperableTrigger iOperableTrigger, IJobDetail iJobDetail, ITrigger.ECompletedExecutionInstruction eCompletedExecutionInstruction) {
        this.m_aResources.getJobStore().triggeredJobComplete(iOperableTrigger, iJobDetail, eCompletedExecutionInstruction);
    }

    protected void notifyJobStoreJobVetoed(IOperableTrigger iOperableTrigger, IJobDetail iJobDetail, ITrigger.ECompletedExecutionInstruction eCompletedExecutionInstruction) {
        this.m_aResources.getJobStore().triggeredJobComplete(iOperableTrigger, iJobDetail, eCompletedExecutionInstruction);
    }

    protected void notifySchedulerThread(long l) {
        if (this.isSignalOnSchedulingChange()) {
            this.m_aSignaler.signalSchedulingChange(l);
        }
    }

    private ICommonsList<ITriggerListener> _buildTriggerListenerList() {
        CommonsLinkedList<ITriggerListener> commonsLinkedList = new CommonsLinkedList<ITriggerListener>();
        commonsLinkedList.addAll(this.getListenerManager().getTriggerListeners());
        commonsLinkedList.addAll(this.getInternalTriggerListeners());
        return commonsLinkedList;
    }

    private ICommonsList<IJobListener> _buildJobListenerList() {
        CommonsLinkedList<IJobListener> commonsLinkedList = new CommonsLinkedList<IJobListener>();
        commonsLinkedList.addAll(this.getListenerManager().getJobListeners());
        commonsLinkedList.addAll(this.getInternalJobListeners());
        return commonsLinkedList;
    }

    private ICommonsList<ISchedulerListener> _buildSchedulerListenerList() {
        CommonsArrayList<ISchedulerListener> commonsArrayList = new CommonsArrayList<ISchedulerListener>();
        commonsArrayList.addAll(this.getListenerManager().getSchedulerListeners());
        commonsArrayList.addAll(this.getInternalSchedulerListeners());
        return commonsArrayList;
    }

    private boolean _matchJobListener(IJobListener iJobListener, JobKey jobKey) {
        ICommonsList<IMatcher<JobKey>> iCommonsList = this.getListenerManager().getJobListenerMatchers(iJobListener.getName());
        if (iCommonsList == null) {
            return true;
        }
        for (IMatcher iMatcher : iCommonsList) {
            if (!iMatcher.isMatch(jobKey)) continue;
            return true;
        }
        return false;
    }

    private boolean _matchTriggerListener(ITriggerListener iTriggerListener, TriggerKey triggerKey) {
        ICommonsList<IMatcher<TriggerKey>> iCommonsList = this.getListenerManager().getTriggerListenerMatchers(iTriggerListener.getName());
        if (iCommonsList == null) {
            return true;
        }
        for (IMatcher iMatcher : iCommonsList) {
            if (!iMatcher.isMatch(triggerKey)) continue;
            return true;
        }
        return false;
    }

    public boolean notifyTriggerListenersFired(IJobExecutionContext iJobExecutionContext) throws SchedulerException {
        boolean bl = false;
        ICommonsList<ITriggerListener> iCommonsList = this._buildTriggerListenerList();
        for (ITriggerListener iTriggerListener : iCommonsList) {
            try {
                if (!this._matchTriggerListener(iTriggerListener, iJobExecutionContext.getTrigger().getKey())) continue;
                iTriggerListener.triggerFired(iJobExecutionContext.getTrigger(), iJobExecutionContext);
                if (!iTriggerListener.vetoJobExecution(iJobExecutionContext.getTrigger(), iJobExecutionContext)) continue;
                bl = true;
            }
            catch (Exception exception) {
                throw new SchedulerException("TriggerListener '" + iTriggerListener.getName() + "' threw exception: " + exception.getMessage(), exception);
            }
        }
        return bl;
    }

    public void notifyTriggerListenersMisfired(ITrigger iTrigger) throws SchedulerException {
        ICommonsList<ITriggerListener> iCommonsList = this._buildTriggerListenerList();
        for (ITriggerListener iTriggerListener : iCommonsList) {
            try {
                if (!this._matchTriggerListener(iTriggerListener, iTrigger.getKey())) continue;
                iTriggerListener.triggerMisfired(iTrigger);
            }
            catch (Exception exception) {
                throw new SchedulerException("TriggerListener '" + iTriggerListener.getName() + "' threw exception: " + exception.getMessage(), exception);
            }
        }
    }

    public void notifyTriggerListenersComplete(IJobExecutionContext iJobExecutionContext, ITrigger.ECompletedExecutionInstruction eCompletedExecutionInstruction) throws SchedulerException {
        ICommonsList<ITriggerListener> iCommonsList = this._buildTriggerListenerList();
        for (ITriggerListener iTriggerListener : iCommonsList) {
            try {
                if (!this._matchTriggerListener(iTriggerListener, iJobExecutionContext.getTrigger().getKey())) continue;
                iTriggerListener.triggerComplete(iJobExecutionContext.getTrigger(), iJobExecutionContext, eCompletedExecutionInstruction);
            }
            catch (Exception exception) {
                throw new SchedulerException("TriggerListener '" + iTriggerListener.getName() + "' threw exception: " + exception.getMessage(), exception);
            }
        }
    }

    public void notifyJobListenersToBeExecuted(IJobExecutionContext iJobExecutionContext) throws SchedulerException {
        ICommonsList<IJobListener> iCommonsList = this._buildJobListenerList();
        for (IJobListener iJobListener : iCommonsList) {
            try {
                if (!this._matchJobListener(iJobListener, iJobExecutionContext.getJobDetail().getKey())) continue;
                iJobListener.jobToBeExecuted(iJobExecutionContext);
            }
            catch (Exception exception) {
                throw new SchedulerException("JobListener '" + iJobListener.getName() + "' threw exception: " + exception.getMessage(), exception);
            }
        }
    }

    public void notifyJobListenersWasVetoed(IJobExecutionContext iJobExecutionContext) throws SchedulerException {
        ICommonsList<IJobListener> iCommonsList = this._buildJobListenerList();
        for (IJobListener iJobListener : iCommonsList) {
            try {
                if (!this._matchJobListener(iJobListener, iJobExecutionContext.getJobDetail().getKey())) continue;
                iJobListener.jobExecutionVetoed(iJobExecutionContext);
            }
            catch (Exception exception) {
                throw new SchedulerException("JobListener '" + iJobListener.getName() + "' threw exception: " + exception.getMessage(), exception);
            }
        }
    }

    public void notifyJobListenersWasExecuted(IJobExecutionContext iJobExecutionContext, JobExecutionException jobExecutionException) throws SchedulerException {
        ICommonsList<IJobListener> iCommonsList = this._buildJobListenerList();
        for (IJobListener iJobListener : iCommonsList) {
            try {
                if (!this._matchJobListener(iJobListener, iJobExecutionContext.getJobDetail().getKey())) continue;
                iJobListener.jobWasExecuted(iJobExecutionContext, jobExecutionException);
            }
            catch (Exception exception) {
                throw new SchedulerException("JobListener '" + iJobListener.getName() + "' threw exception: " + exception.getMessage(), exception);
            }
        }
    }

    public void notifySchedulerListenersError(String string, SchedulerException schedulerException) {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.schedulerError(string, schedulerException);
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of error: ", exception);
                LOGGER.error("  Original error (for notification) was: " + string, schedulerException);
            }
        }
    }

    public void notifySchedulerListenersSchduled(ITrigger iTrigger) {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.jobScheduled(iTrigger);
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of scheduled job.  Triger=" + iTrigger.getKey(), exception);
            }
        }
    }

    public void notifySchedulerListenersUnscheduled(TriggerKey triggerKey) {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                if (triggerKey == null) {
                    iSchedulerListener.schedulingDataCleared();
                    continue;
                }
                iSchedulerListener.jobUnscheduled(triggerKey);
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of unscheduled job.  Triger=" + (triggerKey == null ? "ALL DATA" : triggerKey), exception);
            }
        }
    }

    public void notifySchedulerListenersFinalized(ITrigger iTrigger) {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.triggerFinalized(iTrigger);
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of finalized trigger.  Triger=" + iTrigger.getKey(), exception);
            }
        }
    }

    public void notifySchedulerListenersPausedTrigger(TriggerKey triggerKey) {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.triggerPaused(triggerKey);
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of paused trigger: " + triggerKey, exception);
            }
        }
    }

    public void notifySchedulerListenersPausedTriggers(String string) {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.triggersPaused(string);
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of paused trigger group." + string, exception);
            }
        }
    }

    public void notifySchedulerListenersResumedTrigger(TriggerKey triggerKey) {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.triggerResumed(triggerKey);
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of resumed trigger: " + triggerKey, exception);
            }
        }
    }

    public void notifySchedulerListenersResumedTriggers(String string) {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.triggersResumed(string);
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of resumed group: " + string, exception);
            }
        }
    }

    public void notifySchedulerListenersPausedJob(JobKey jobKey) {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.jobPaused(jobKey);
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of paused job: " + jobKey, exception);
            }
        }
    }

    public void notifySchedulerListenersPausedJobs(String string) {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.jobsPaused(string);
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of paused job group: " + string, exception);
            }
        }
    }

    public void notifySchedulerListenersResumedJob(JobKey jobKey) {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.jobResumed(jobKey);
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of resumed job: " + jobKey, exception);
            }
        }
    }

    public void notifySchedulerListenersResumedJobs(String string) {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.jobsResumed(string);
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of resumed job group: " + string, exception);
            }
        }
    }

    public void notifySchedulerListenersInStandbyMode() {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.schedulerInStandbyMode();
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of inStandByMode.", exception);
            }
        }
    }

    public void notifySchedulerListenersStarted() {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.schedulerStarted();
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of startup.", exception);
            }
        }
    }

    public void notifySchedulerListenersStarting() {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.schedulerStarting();
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of startup.", exception);
            }
        }
    }

    public void notifySchedulerListenersShutdown() {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.schedulerShutdown();
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of shutdown.", exception);
            }
        }
    }

    public void notifySchedulerListenersShuttingdown() {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.schedulerShuttingdown();
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of shutdown.", exception);
            }
        }
    }

    public void notifySchedulerListenersJobAdded(IJobDetail iJobDetail) {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.jobAdded(iJobDetail);
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of JobAdded.", exception);
            }
        }
    }

    public void notifySchedulerListenersJobDeleted(JobKey jobKey) {
        ICommonsList<ISchedulerListener> iCommonsList = this._buildSchedulerListenerList();
        for (ISchedulerListener iSchedulerListener : iCommonsList) {
            try {
                iSchedulerListener.jobDeleted(jobKey);
            }
            catch (Exception exception) {
                LOGGER.error("Error while notifying SchedulerListener of JobAdded.", exception);
            }
        }
    }

    public void setJobFactory(IJobFactory iJobFactory) throws SchedulerException {
        ValueEnforcer.notNull(iJobFactory, "JobFactory");
        LOGGER.info("JobFactory set to: " + iJobFactory.toString());
        this.m_aJobFactory = iJobFactory;
    }

    public IJobFactory getJobFactory() {
        return this.m_aJobFactory;
    }

    @Override
    public boolean interrupt(JobKey jobKey) throws UnableToInterruptJobException {
        ICommonsList<IJobExecutionContext> iCommonsList = this.getCurrentlyExecutingJobs();
        IJobDetail iJobDetail = null;
        IJob iJob = null;
        boolean bl = false;
        for (IJobExecutionContext iJobExecutionContext : iCommonsList) {
            iJobDetail = iJobExecutionContext.getJobDetail();
            if (!jobKey.equals(iJobDetail.getKey())) continue;
            iJob = iJobExecutionContext.getJobInstance();
            if (iJob instanceof IInterruptableJob) {
                ((IInterruptableJob)iJob).interrupt();
                bl = true;
                continue;
            }
            throw new UnableToInterruptJobException("Job " + iJobDetail.getKey() + " can not be interrupted, since it does not implement " + IInterruptableJob.class.getName());
        }
        return bl;
    }

    @Override
    public boolean interrupt(String string) throws UnableToInterruptJobException {
        ICommonsList<IJobExecutionContext> iCommonsList = this.getCurrentlyExecutingJobs();
        IJob iJob = null;
        for (IJobExecutionContext iJobExecutionContext : iCommonsList) {
            if (!iJobExecutionContext.getFireInstanceId().equals(string)) continue;
            iJob = iJobExecutionContext.getJobInstance();
            if (iJob instanceof IInterruptableJob) {
                ((IInterruptableJob)iJob).interrupt();
                return true;
            }
            throw new UnableToInterruptJobException("Job " + iJobExecutionContext.getJobDetail().getKey() + " can not be interrupted, since it does not implement " + IInterruptableJob.class.getName());
        }
        return false;
    }

    private void _shutdownPlugins() {
        this.m_aResources.getSchedulerPlugins().forEach(ISchedulerPlugin::shutdown);
    }

    private void _startPlugins() {
        this.m_aResources.getSchedulerPlugins().forEach(ISchedulerPlugin::start);
    }

    static {
        String string = "UNKNOWN";
        String string2 = "UNKNOWN";
        String string3 = "UNKNOWN";
        NonBlockingProperties nonBlockingProperties = PropertiesHelper.loadProperties(new ClassPathResource("quartz/quartz-build.properties"));
        if (nonBlockingProperties != null) {
            String string4 = (String)nonBlockingProperties.get("version");
            if (string4 != null) {
                String[] stringArray = StringHelper.getExplodedArray('.', string4);
                string = stringArray[0];
                string2 = stringArray.length > 1 ? stringArray[1] : "0";
                string3 = stringArray.length > 2 ? stringArray[2] : "0";
            } else {
                LoggerFactory.getLogger(QuartzScheduler.class).error("Can't parse Quartz version from quartz-build.properties");
            }
        }
        VERSION_MAJOR = string;
        VERSION_MINOR = string2;
        VERSION_ITERATION = string3;
    }
}

