/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.core;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.quartz.core.IJobRunShellFactory;
import com.helger.quartz.spi.IJobStore;
import com.helger.quartz.spi.ISchedulerPlugin;
import com.helger.quartz.spi.IThreadExecutor;
import com.helger.quartz.spi.IThreadPool;
import java.util.List;

public class QuartzSchedulerResources {
    public static final String CREATE_REGISTRY_NEVER = "never";
    public static final String CREATE_REGISTRY_ALWAYS = "always";
    public static final String CREATE_REGISTRY_AS_NEEDED = "as_needed";
    private String m_sName;
    private String m_sInstanceId;
    private String m_sThreadName;
    private IThreadPool m_aThreadPool;
    private IJobStore m_aJobStore;
    private IJobRunShellFactory m_aJobRunShellFactory;
    private final ICommonsList<ISchedulerPlugin> m_aSchedulerPlugins = new CommonsArrayList<int>(10);
    private boolean m_bMakeSchedulerThreadDaemon = false;
    private boolean m_bThreadsInheritInitializersClassLoadContext = false;
    private IThreadExecutor m_aThreadExecutor;
    private long m_nBatchTimeWindow = 0L;
    private int m_nMaxBatchSize = 1;
    private boolean m_bInterruptJobsOnShutdown = false;
    private boolean m_bInterruptJobsOnShutdownWithWait = false;

    public String getName() {
        return this.m_sName;
    }

    public void setName(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Scheduler name cannot be empty.");
        }
        this.m_sName = string;
        if (this.m_sThreadName == null) {
            this.setThreadName(string + "_QuartzSchedulerThread");
        }
    }

    public String getInstanceId() {
        return this.m_sInstanceId;
    }

    public void setInstanceId(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Scheduler instanceId cannot be empty.");
        }
        this.m_sInstanceId = string;
    }

    public static String getUniqueIdentifier(String string, String string2) {
        return string + "_$_" + string2;
    }

    public String getUniqueIdentifier() {
        return QuartzSchedulerResources.getUniqueIdentifier(this.m_sName, this.m_sInstanceId);
    }

    public String getThreadName() {
        return this.m_sThreadName;
    }

    public void setThreadName(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("Scheduler thread name cannot be empty.");
        }
        this.m_sThreadName = string;
    }

    public IThreadPool getThreadPool() {
        return this.m_aThreadPool;
    }

    public void setThreadPool(IThreadPool iThreadPool) {
        if (iThreadPool == null) {
            throw new IllegalArgumentException("ThreadPool cannot be null.");
        }
        this.m_aThreadPool = iThreadPool;
    }

    public IJobStore getJobStore() {
        return this.m_aJobStore;
    }

    public void setJobStore(IJobStore iJobStore) {
        if (iJobStore == null) {
            throw new IllegalArgumentException("JobStore cannot be null.");
        }
        this.m_aJobStore = iJobStore;
    }

    public IJobRunShellFactory getJobRunShellFactory() {
        return this.m_aJobRunShellFactory;
    }

    public void setJobRunShellFactory(IJobRunShellFactory iJobRunShellFactory) {
        if (iJobRunShellFactory == null) {
            throw new IllegalArgumentException("JobRunShellFactory cannot be null.");
        }
        this.m_aJobRunShellFactory = iJobRunShellFactory;
    }

    public void addSchedulerPlugin(ISchedulerPlugin iSchedulerPlugin) {
        this.m_aSchedulerPlugins.add(iSchedulerPlugin);
    }

    public List<ISchedulerPlugin> getSchedulerPlugins() {
        return this.m_aSchedulerPlugins;
    }

    public boolean getMakeSchedulerThreadDaemon() {
        return this.m_bMakeSchedulerThreadDaemon;
    }

    public void setMakeSchedulerThreadDaemon(boolean bl) {
        this.m_bMakeSchedulerThreadDaemon = bl;
    }

    public boolean isThreadsInheritInitializersClassLoadContext() {
        return this.m_bThreadsInheritInitializersClassLoadContext;
    }

    public void setThreadsInheritInitializersClassLoadContext(boolean bl) {
        this.m_bThreadsInheritInitializersClassLoadContext = bl;
    }

    public IThreadExecutor getThreadExecutor() {
        return this.m_aThreadExecutor;
    }

    public void setThreadExecutor(IThreadExecutor iThreadExecutor) {
        this.m_aThreadExecutor = iThreadExecutor;
    }

    public long getBatchTimeWindow() {
        return this.m_nBatchTimeWindow;
    }

    public void setBatchTimeWindow(long l) {
        this.m_nBatchTimeWindow = l;
    }

    public int getMaxBatchSize() {
        return this.m_nMaxBatchSize;
    }

    public void setMaxBatchSize(int n) {
        this.m_nMaxBatchSize = n;
    }

    public boolean isInterruptJobsOnShutdown() {
        return this.m_bInterruptJobsOnShutdown;
    }

    public void setInterruptJobsOnShutdown(boolean bl) {
        this.m_bInterruptJobsOnShutdown = bl;
    }

    public boolean isInterruptJobsOnShutdownWithWait() {
        return this.m_bInterruptJobsOnShutdownWithWait;
    }

    public void setInterruptJobsOnShutdownWithWait(boolean bl) {
        this.m_bInterruptJobsOnShutdownWithWait = bl;
    }
}

