/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.core;

import com.helger.quartz.ITrigger;
import com.helger.quartz.JobKey;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.core.QuartzScheduler;
import com.helger.quartz.core.QuartzSchedulerThread;
import com.helger.quartz.spi.ISchedulerSignaler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerSignaler
implements ISchedulerSignaler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerSignaler.class);
    protected QuartzScheduler m_aScheduler;
    protected QuartzSchedulerThread m_aSchedulerThread;

    public SchedulerSignaler(QuartzScheduler quartzScheduler, QuartzSchedulerThread quartzSchedulerThread) {
        this.m_aScheduler = quartzScheduler;
        this.m_aSchedulerThread = quartzSchedulerThread;
        LOGGER.info("Initialized Scheduler Signaller of type: " + this.getClass());
    }

    @Override
    public void notifyTriggerListenersMisfired(ITrigger iTrigger) {
        try {
            this.m_aScheduler.notifyTriggerListenersMisfired(iTrigger);
        }
        catch (SchedulerException schedulerException) {
            LOGGER.error("Error notifying listeners of trigger misfire.", schedulerException);
            this.m_aScheduler.notifySchedulerListenersError("Error notifying listeners of trigger misfire.", schedulerException);
        }
    }

    @Override
    public void notifySchedulerListenersFinalized(ITrigger iTrigger) {
        this.m_aScheduler.notifySchedulerListenersFinalized(iTrigger);
    }

    @Override
    public void signalSchedulingChange(long l) {
        this.m_aSchedulerThread.signalSchedulingChange(l);
    }

    @Override
    public void notifySchedulerListenersJobDeleted(JobKey jobKey) {
        this.m_aScheduler.notifySchedulerListenersJobDeleted(jobKey);
    }

    @Override
    public void notifySchedulerListenersError(String string, SchedulerException schedulerException) {
        this.m_aScheduler.notifySchedulerListenersError(string, schedulerException);
    }
}

