/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.quartz.IScheduler;
import com.helger.quartz.SchedulerException;
import javax.annotation.Nonnull;

public class SchedulerRepository {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final ICommonsMap<String, IScheduler> m_aSchedulers = new CommonsHashMap<String, IScheduler>();

    private SchedulerRepository() {
    }

    @Nonnull
    public static SchedulerRepository getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void bind(IScheduler iScheduler) throws SchedulerException {
        String string = iScheduler.getSchedulerName();
        this.m_aRWLock.writeLockedThrowing(() -> {
            if (this.m_aSchedulers.containsKey(string)) {
                throw new SchedulerException("Scheduler with name '" + string + "' already exists.");
            }
            this.m_aSchedulers.put(string, iScheduler);
        });
    }

    public boolean remove(String string) {
        return this.m_aRWLock.writeLockedBoolean(() -> this.m_aSchedulers.remove(string) != null);
    }

    public IScheduler lookup(String string) {
        return this.m_aRWLock.readLockedGet(() -> (IScheduler)this.m_aSchedulers.get(string));
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<IScheduler> lookupAll() {
        return this.m_aRWLock.readLockedGet(this.m_aSchedulers::copyOfValues);
    }

    private static final class SingletonHolder {
        static final SchedulerRepository INSTANCE = new SchedulerRepository();

        private SingletonHolder() {
        }
    }
}

