/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.stream.NonBlockingBufferedInputStream;
import com.helger.commons.lang.NonBlockingProperties;
import com.helger.commons.system.SystemProperties;
import com.helger.quartz.IJobListener;
import com.helger.quartz.IMatcher;
import com.helger.quartz.IScheduler;
import com.helger.quartz.ISchedulerFactory;
import com.helger.quartz.ITriggerListener;
import com.helger.quartz.JobKey;
import com.helger.quartz.SchedulerConfigException;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.core.IJobRunShellFactory;
import com.helger.quartz.core.QuartzScheduler;
import com.helger.quartz.core.QuartzSchedulerResources;
import com.helger.quartz.impl.DefaultThreadExecutor;
import com.helger.quartz.impl.SchedulerRepository;
import com.helger.quartz.impl.StdJobRunShellFactory;
import com.helger.quartz.impl.StdScheduler;
import com.helger.quartz.impl.matchers.EverythingMatcher;
import com.helger.quartz.simpl.CascadingClassLoadHelper;
import com.helger.quartz.simpl.RAMJobStore;
import com.helger.quartz.simpl.SimpleInstanceIdGenerator;
import com.helger.quartz.simpl.SimpleThreadPool;
import com.helger.quartz.simpl.SystemPropertyInstanceIdGenerator;
import com.helger.quartz.spi.IClassLoadHelper;
import com.helger.quartz.spi.IInstanceIdGenerator;
import com.helger.quartz.spi.IJobFactory;
import com.helger.quartz.spi.IJobStore;
import com.helger.quartz.spi.ISchedulerPlugin;
import com.helger.quartz.spi.IThreadExecutor;
import com.helger.quartz.spi.IThreadPool;
import com.helger.quartz.utils.PropertiesParser;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.annotation.Nonnull;
import javax.annotation.WillNotClose;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StdSchedulerFactory
implements ISchedulerFactory {
    public static final String PROP_PROPERTIES_FILE = "org.quartz.properties";
    public static final String PROP_SCHED_INSTANCE_NAME = "org.quartz.scheduler.instanceName";
    public static final String PROP_SCHED_INSTANCE_ID = "org.quartz.scheduler.instanceId";
    public static final String PROP_SCHED_INSTANCE_ID_GENERATOR_PREFIX = "org.quartz.scheduler.instanceIdGenerator";
    public static final String PROP_SCHED_INSTANCE_ID_GENERATOR_CLASS = "org.quartz.scheduler.instanceIdGenerator.class";
    public static final String PROP_SCHED_THREAD_NAME = "org.quartz.scheduler.threadName";
    public static final String PROP_SCHED_BATCH_TIME_WINDOW = "org.quartz.scheduler.batchTriggerAcquisitionFireAheadTimeWindow";
    public static final String PROP_SCHED_MAX_BATCH_SIZE = "org.quartz.scheduler.batchTriggerAcquisitionMaxCount";
    public static final String PROP_SCHED_IDLE_WAIT_TIME = "org.quartz.scheduler.idleWaitTime";
    public static final String PROP_SCHED_MAKE_SCHEDULER_THREAD_DAEMON = "org.quartz.scheduler.makeSchedulerThreadDaemon";
    public static final String PROP_SCHED_SCHEDULER_THREADS_INHERIT_CONTEXT_CLASS_LOADER_OF_INITIALIZING_THREAD = "org.quartz.scheduler.threadsInheritContextClassLoaderOfInitializer";
    public static final String PROP_SCHED_CLASS_LOAD_HELPER_CLASS = "org.quartz.scheduler.classLoadHelper.class";
    public static final String PROP_SCHED_JOB_FACTORY_CLASS = "org.quartz.scheduler.jobFactory.class";
    public static final String PROP_SCHED_JOB_FACTORY_PREFIX = "org.quartz.scheduler.jobFactory";
    public static final String PROP_SCHED_INTERRUPT_JOBS_ON_SHUTDOWN = "org.quartz.scheduler.interruptJobsOnShutdown";
    public static final String PROP_SCHED_INTERRUPT_JOBS_ON_SHUTDOWN_WITH_WAIT = "org.quartz.scheduler.interruptJobsOnShutdownWithWait";
    public static final String PROP_SCHED_CONTEXT_PREFIX = "org.quartz.context.key";
    public static final String PROP_THREAD_POOL_PREFIX = "org.quartz.threadPool";
    public static final String PROP_THREAD_POOL_CLASS = "org.quartz.threadPool.class";
    public static final String PROP_JOB_STORE_PREFIX = "org.quartz.jobStore";
    public static final String PROP_JOB_STORE_LOCK_HANDLER_PREFIX = "org.quartz.jobStore.lockHandler";
    public static final String PROP_JOB_STORE_LOCK_HANDLER_CLASS = "org.quartz.jobStore.lockHandler.class";
    public static final String PROP_JOB_STORE_CLASS = "org.quartz.jobStore.class";
    public static final String PROP_JOB_STORE_USE_PROP = "org.quartz.jobStore.useProperties";
    public static final String PROP_PLUGIN_PREFIX = "org.quartz.plugin";
    public static final String PROP_PLUGIN_CLASS = "class";
    public static final String PROP_JOB_LISTENER_PREFIX = "org.quartz.jobListener";
    public static final String PROP_TRIGGER_LISTENER_PREFIX = "org.quartz.triggerListener";
    public static final String PROP_LISTENER_CLASS = "class";
    public static final String DEFAULT_INSTANCE_ID = "NON_CLUSTERED";
    public static final String AUTO_GENERATE_INSTANCE_ID = "AUTO";
    public static final String PROP_THREAD_EXECUTOR = "org.quartz.threadExecutor";
    public static final String PROP_THREAD_EXECUTOR_CLASS = "org.quartz.threadExecutor.class";
    public static final String SYSTEM_PROPERTY_AS_INSTANCE_ID = "SYS_PROP";
    public static final String DEFAULT_FILENAME = "quartz.properties";
    private static final Logger LOGGER = LoggerFactory.getLogger(StdSchedulerFactory.class);
    private SchedulerException m_aInitException;
    private String m_sPropSrc;
    private PropertiesParser m_aCfg;

    @Nonnull
    public StdSchedulerFactory initialize() throws SchedulerException {
        NonBlockingProperties nonBlockingProperties;
        block51: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("StdSchedulerFactory.initalize");
            }
            if (this.m_aCfg != null) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("StdSchedulerFactory already initalized");
                }
                return this;
            }
            if (this.m_aInitException != null) {
                throw this.m_aInitException;
            }
            String string = SystemProperties.getPropertyValueOrNull(PROP_PROPERTIES_FILE);
            String string2 = string != null ? string : DEFAULT_FILENAME;
            File file = new File(string2);
            nonBlockingProperties = new NonBlockingProperties();
            if (file.exists()) {
                try {
                    this.m_sPropSrc = string != null ? "specified file: '" + string + "'" : "default file in current working dir: 'quartz.properties'";
                    try (NonBlockingBufferedInputStream nonBlockingBufferedInputStream = new NonBlockingBufferedInputStream(new FileInputStream(string2));){
                        nonBlockingProperties.load(nonBlockingBufferedInputStream);
                        break block51;
                    }
                }
                catch (IOException iOException) {
                    this.m_aInitException = new SchedulerException("Properties file: '" + string2 + "' could not be read.", iOException);
                    throw this.m_aInitException;
                }
            }
            if (string != null) {
                InputStream inputStream = ClassPathResource.getInputStream(string);
                if (inputStream == null) {
                    this.m_aInitException = new SchedulerException("Properties file: '" + string + "' could not be found.");
                    throw this.m_aInitException;
                }
                this.m_sPropSrc = "specified file: '" + string + "' in the class resource path.";
                try (NonBlockingBufferedInputStream nonBlockingBufferedInputStream = new NonBlockingBufferedInputStream(inputStream);){
                    nonBlockingProperties.load(nonBlockingBufferedInputStream);
                    break block51;
                }
                catch (IOException iOException) {
                    this.m_aInitException = new SchedulerException("Properties file: '" + string + "' could not be read.", iOException);
                    throw this.m_aInitException;
                }
            }
            this.m_sPropSrc = "default resource file in Quartz package: 'quartz.properties'";
            InputStream inputStream = ClassPathResource.getInputStream(DEFAULT_FILENAME);
            if (inputStream == null) {
                inputStream = ClassPathResource.getInputStream("quartz/quartz.properties");
            }
            if (inputStream == null) {
                this.m_aInitException = new SchedulerException("Default quartz.properties not found in class path");
                throw this.m_aInitException;
            }
            try (NonBlockingBufferedInputStream nonBlockingBufferedInputStream = new NonBlockingBufferedInputStream(inputStream);){
                nonBlockingProperties.load(nonBlockingBufferedInputStream);
            }
            catch (IOException iOException) {
                this.m_aInitException = new SchedulerException("Resource properties file: quartz.properties could not be read from the classpath.", iOException);
                throw this.m_aInitException;
            }
        }
        return this.initialize(StdSchedulerFactory._overrideWithSysProps(nonBlockingProperties));
    }

    @Nonnull
    private static NonBlockingProperties _overrideWithSysProps(@Nonnull NonBlockingProperties nonBlockingProperties) {
        Properties properties = null;
        try {
            properties = System.getProperties();
        }
        catch (AccessControlException accessControlException) {
            LOGGER.warn("Skipping overriding MiniQuartz properties with System properties during initialization because of an AccessControlException.  This is likely due to not having read/write access for java.util.PropertyPermission as required by java.lang.System.getProperties().  To resolve this warning, either add this permission to your policy file or use a non-default version of initialize().", accessControlException);
        }
        if (properties != null) {
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                nonBlockingProperties.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return nonBlockingProperties;
    }

    @Nonnull
    public StdSchedulerFactory initialize(String string) throws SchedulerException {
        if (this.m_aCfg != null) {
            return this;
        }
        if (this.m_aInitException != null) {
            throw this.m_aInitException;
        }
        NonBlockingProperties nonBlockingProperties = new NonBlockingProperties();
        try {
            InputStream inputStream = ClassPathResource.getInputStream(string);
            if (inputStream != null) {
                this.m_sPropSrc = "the specified file : '" + string + "' from the class resource path.";
            } else {
                inputStream = FileHelper.getInputStream(new File(string));
                this.m_sPropSrc = "the specified file : '" + string + "'";
            }
            try (NonBlockingBufferedInputStream nonBlockingBufferedInputStream = new NonBlockingBufferedInputStream(inputStream);){
                nonBlockingProperties.load(inputStream);
            }
        }
        catch (IOException iOException) {
            this.m_aInitException = new SchedulerException("Properties file: '" + string + "' could not be read.", iOException);
            throw this.m_aInitException;
        }
        return this.initialize(nonBlockingProperties);
    }

    @Nonnull
    public StdSchedulerFactory initialize(@Nonnull @WillNotClose InputStream inputStream) throws SchedulerException {
        if (this.m_aCfg != null) {
            return this;
        }
        if (this.m_aInitException != null) {
            throw this.m_aInitException;
        }
        NonBlockingProperties nonBlockingProperties = new NonBlockingProperties();
        if (inputStream != null) {
            try {
                nonBlockingProperties.load(inputStream);
                this.m_sPropSrc = "an externally opened InputStream.";
            }
            catch (IOException iOException) {
                this.m_aInitException = new SchedulerException("Error loading property data from InputStream", iOException);
                throw this.m_aInitException;
            }
        } else {
            this.m_aInitException = new SchedulerException("Error loading property data from InputStream - InputStream is null.");
            throw this.m_aInitException;
        }
        return this.initialize(nonBlockingProperties);
    }

    @Nonnull
    public StdSchedulerFactory initialize(NonBlockingProperties nonBlockingProperties) throws SchedulerException {
        if (this.m_sPropSrc == null) {
            this.m_sPropSrc = "an externally provided properties instance.";
        }
        this.m_aCfg = new PropertiesParser(nonBlockingProperties);
        return this;
    }

    private IScheduler _instantiate() throws SchedulerException {
        IThreadExecutor iThreadExecutor;
        Object exception;
        Object object;
        String bl7;
        Object bl6;
        Object object22;
        Object object3;
        Cloneable cloneable;
        String string2;
        NonBlockingProperties nonBlockingProperties;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("StdSchedulerFactory._instantiate");
        }
        if (this.m_aCfg == null) {
            this.initialize();
        }
        if (this.m_aInitException != null) {
            throw this.m_aInitException;
        }
        IJobStore iJobStore = null;
        IThreadPool iThreadPool = null;
        QuartzScheduler quartzScheduler = null;
        String string3 = null;
        boolean bl = false;
        long l = -1L;
        SchedulerRepository schedulerRepository = SchedulerRepository.getInstance();
        String string4 = this.m_aCfg.getStringProperty(PROP_SCHED_INSTANCE_NAME, "MiniQuartzScheduler");
        String string5 = this.m_aCfg.getStringProperty(PROP_SCHED_THREAD_NAME, string4 + "_MiniQuartzSchedulerThread");
        String string6 = this.m_aCfg.getStringProperty(PROP_SCHED_INSTANCE_ID, DEFAULT_INSTANCE_ID);
        if (string6.equals(AUTO_GENERATE_INSTANCE_ID)) {
            bl = true;
            string3 = this.m_aCfg.getStringProperty(PROP_SCHED_INSTANCE_ID_GENERATOR_CLASS, SimpleInstanceIdGenerator.class.getName());
        } else if (string6.equals(SYSTEM_PROPERTY_AS_INSTANCE_ID)) {
            bl = true;
            string3 = SystemPropertyInstanceIdGenerator.class.getName();
        }
        String string7 = this.m_aCfg.getStringProperty(PROP_SCHED_CLASS_LOAD_HELPER_CLASS, CascadingClassLoadHelper.class.getName());
        String string8 = this.m_aCfg.getStringProperty(PROP_SCHED_JOB_FACTORY_CLASS, null);
        l = this.m_aCfg.getLongProperty(PROP_SCHED_IDLE_WAIT_TIME, l);
        if (l > -1L && l < 1000L) {
            throw new SchedulerException("org.quartz.scheduler.idleWaitTime of less than 1000ms is not legal.");
        }
        boolean bl2 = this.m_aCfg.getBooleanProperty(PROP_SCHED_MAKE_SCHEDULER_THREAD_DAEMON);
        boolean bl3 = this.m_aCfg.getBooleanProperty(PROP_SCHED_SCHEDULER_THREADS_INHERIT_CONTEXT_CLASS_LOADER_OF_INITIALIZING_THREAD);
        long l2 = this.m_aCfg.getLongProperty(PROP_SCHED_BATCH_TIME_WINDOW, 0L);
        int n = this.m_aCfg.getIntProperty(PROP_SCHED_MAX_BATCH_SIZE, 1);
        boolean bl4 = this.m_aCfg.getBooleanProperty(PROP_SCHED_INTERRUPT_JOBS_ON_SHUTDOWN, false);
        boolean bl5 = this.m_aCfg.getBooleanProperty(PROP_SCHED_INTERRUPT_JOBS_ON_SHUTDOWN_WITH_WAIT, false);
        NonBlockingProperties nonBlockingProperties2 = this.m_aCfg.getPropertyGroup(PROP_SCHED_CONTEXT_PREFIX, true);
        IClassLoadHelper iClassLoadHelper = null;
        try {
            iClassLoadHelper = (IClassLoadHelper)this._loadClass(string7).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception2) {
            throw new SchedulerConfigException("Unable to instantiate class load helper class: " + exception2.getMessage(), exception2);
        }
        iClassLoadHelper.initialize();
        IJobFactory iJobFactory = null;
        if (string8 != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating jobFactoryClass " + string8);
            }
            try {
                iJobFactory = (IJobFactory)iClassLoadHelper.loadClass(string8).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception3) {
                throw new SchedulerConfigException("Unable to instantiate JobFactory class: " + exception3.getMessage(), exception3);
            }
            nonBlockingProperties = this.m_aCfg.getPropertyGroup(PROP_SCHED_JOB_FACTORY_PREFIX, true);
            try {
                this._setBeanProps(iJobFactory, nonBlockingProperties);
            }
            catch (Exception exception4) {
                this.m_aInitException = new SchedulerException("JobFactory class '" + string8 + "' props could not be configured.", exception4);
                throw this.m_aInitException;
            }
        }
        IInstanceIdGenerator iInstanceIdGenerator = null;
        if (string3 != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating instanceIdGeneratorClass " + string3);
            }
            try {
                iInstanceIdGenerator = (IInstanceIdGenerator)iClassLoadHelper.loadClass(string3).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception5) {
                throw new SchedulerConfigException("Unable to instantiate InstanceIdGenerator class: " + exception5.getMessage(), exception5);
            }
            nonBlockingProperties = this.m_aCfg.getPropertyGroup(PROP_SCHED_INSTANCE_ID_GENERATOR_PREFIX, true);
            try {
                this._setBeanProps(iInstanceIdGenerator, nonBlockingProperties);
            }
            catch (Exception exception6) {
                this.m_aInitException = new SchedulerException("InstanceIdGenerator class '" + string3 + "' props could not be configured.", exception6);
                throw this.m_aInitException;
            }
        }
        if ((string2 = this.m_aCfg.getStringProperty(PROP_THREAD_POOL_CLASS, SimpleThreadPool.class.getName())) == null) {
            this.m_aInitException = new SchedulerException("ThreadPool class not specified. ");
            throw this.m_aInitException;
        }
        try {
            iThreadPool = (IThreadPool)iClassLoadHelper.loadClass(string2).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception7) {
            this.m_aInitException = new SchedulerException("ThreadPool class '" + string2 + "' could not be instantiated.", exception7);
            throw this.m_aInitException;
        }
        nonBlockingProperties = this.m_aCfg.getPropertyGroup(PROP_THREAD_POOL_PREFIX, true);
        try {
            this._setBeanProps(iThreadPool, nonBlockingProperties);
        }
        catch (Exception exception8) {
            this.m_aInitException = new SchedulerException("ThreadPool class '" + string2 + "' props could not be configured.", exception8);
            throw this.m_aInitException;
        }
        String string9 = this.m_aCfg.getStringProperty(PROP_JOB_STORE_CLASS, RAMJobStore.class.getName());
        if (string9 == null) {
            this.m_aInitException = new SchedulerException("JobStore class not specified. ");
            throw this.m_aInitException;
        }
        try {
            iJobStore = (IJobStore)iClassLoadHelper.loadClass(string9).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception9) {
            this.m_aInitException = new SchedulerException("JobStore class '" + string9 + "' could not be instantiated.", exception9);
            throw this.m_aInitException;
        }
        iJobStore.setInstanceName(string4);
        iJobStore.setInstanceId(string6);
        nonBlockingProperties = this.m_aCfg.getPropertyGroup(PROP_JOB_STORE_PREFIX, true, new String[]{PROP_JOB_STORE_LOCK_HANDLER_PREFIX});
        try {
            this._setBeanProps(iJobStore, nonBlockingProperties);
        }
        catch (Exception exception10) {
            this.m_aInitException = new SchedulerException("JobStore class '" + string9 + "' props could not be configured.", exception10);
            throw this.m_aInitException;
        }
        ICommonsList<String> iCommonsList = this.m_aCfg.getPropertyGroups(PROP_PLUGIN_PREFIX);
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        for (String object82 : iCommonsList) {
            cloneable = this.m_aCfg.getPropertyGroup("org.quartz.plugin." + object82, true);
            object3 = ((NonBlockingProperties)cloneable).getProperty("class", null);
            if (object3 == null) {
                this.m_aInitException = new SchedulerException("SchedulerPlugin class not specified for plugin '" + object82 + "'");
                throw this.m_aInitException;
            }
            object22 = null;
            try {
                object22 = (ISchedulerPlugin)iClassLoadHelper.loadClass((String)object3).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception11) {
                this.m_aInitException = new SchedulerException("SchedulerPlugin class '" + object3 + "' could not be instantiated.", exception11);
                throw this.m_aInitException;
            }
            try {
                this._setBeanProps(object22, (NonBlockingProperties)cloneable);
            }
            catch (Exception object5) {
                this.m_aInitException = new SchedulerException("JobStore SchedulerPlugin '" + object3 + "' props could not be configured.", object5);
                throw this.m_aInitException;
            }
            commonsArrayList.add(object22);
        }
        Class[] classArray = new Class[]{String.class};
        ICommonsList<String> iCommonsList2 = this.m_aCfg.getPropertyGroups(PROP_JOB_LISTENER_PREFIX);
        cloneable = new CommonsArrayList();
        for (Object object22 : iCommonsList2) {
            bl6 = this.m_aCfg.getPropertyGroup("org.quartz.jobListener." + (String)object22, true);
            bl7 = ((NonBlockingProperties)bl6).getProperty("class", null);
            if (bl7 == null) {
                this.m_aInitException = new SchedulerException("JobListener class not specified for listener '" + (String)object22 + "'");
                throw this.m_aInitException;
            }
            object = null;
            try {
                object = (IJobListener)iClassLoadHelper.loadClass(bl7).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception12) {
                this.m_aInitException = new SchedulerException("JobListener class '" + bl7 + "' could not be instantiated.", exception12);
                throw this.m_aInitException;
            }
            try {
                exception = null;
                try {
                    exception = object.getClass().getMethod("setName", classArray);
                }
                catch (NoSuchMethodException object23) {
                    // empty catch block
                }
                if (exception != null) {
                    ((Method)exception).invoke(object, object22);
                }
                this._setBeanProps(object, (NonBlockingProperties)bl6);
            }
            catch (Exception exception13) {
                this.m_aInitException = new SchedulerException("JobListener '" + bl7 + "' props could not be configured.", exception13);
                throw this.m_aInitException;
            }
            cloneable.add(object);
        }
        object3 = this.m_aCfg.getPropertyGroups(PROP_TRIGGER_LISTENER_PREFIX);
        object22 = new CommonsArrayList();
        bl6 = object3.iterator();
        while (bl6.hasNext()) {
            bl7 = (String)bl6.next();
            object = this.m_aCfg.getPropertyGroup("org.quartz.triggerListener." + bl7, true);
            exception = ((NonBlockingProperties)object).getProperty("class", null);
            if (exception == null) {
                this.m_aInitException = new SchedulerException("TriggerListener class not specified for listener '" + bl7 + "'");
                throw this.m_aInitException;
            }
            exception = null;
            try {
                exception = (ITriggerListener)iClassLoadHelper.loadClass((String)exception).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception2) {
                this.m_aInitException = new SchedulerException("TriggerListener class '" + (String)exception + "' could not be instantiated.", exception2);
                throw this.m_aInitException;
            }
            try {
                exception = null;
                try {
                    exception = exception.getClass().getMethod("setName", classArray);
                }
                catch (NoSuchMethodException iSchedulerPlugin) {
                    // empty catch block
                }
                if (exception != null) {
                    ((Method)exception).invoke(exception, bl7);
                }
                this._setBeanProps(exception, (NonBlockingProperties)object);
            }
            catch (Exception exception14) {
                this.m_aInitException = new SchedulerException("TriggerListener '" + (String)exception + "' props could not be configured.", exception14);
                throw this.m_aInitException;
            }
            object22.add(exception);
        }
        boolean bl8 = false;
        boolean bl9 = false;
        object = this.m_aCfg.getStringProperty(PROP_THREAD_EXECUTOR_CLASS);
        if (object != null) {
            nonBlockingProperties = this.m_aCfg.getPropertyGroup(PROP_THREAD_EXECUTOR, true);
            try {
                iThreadExecutor = (IThreadExecutor)iClassLoadHelper.loadClass((String)object).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                LOGGER.info("Using custom implementation for ThreadExecutor: " + (String)object);
                this._setBeanProps(iThreadExecutor, nonBlockingProperties);
            }
            catch (Exception exception3) {
                this.m_aInitException = new SchedulerException("ThreadExecutor class '" + (String)object + "' could not be instantiated.", exception3);
                throw this.m_aInitException;
            }
        } else {
            LOGGER.info("Using default implementation for ThreadExecutor");
            iThreadExecutor = new DefaultThreadExecutor();
        }
        try {
            Object object42;
            exception = new StdJobRunShellFactory();
            if (bl) {
                try {
                    string6 = DEFAULT_INSTANCE_ID;
                    if (iJobStore.isClustered()) {
                        string6 = iInstanceIdGenerator.generateInstanceId();
                    }
                }
                catch (Exception exception15) {
                    LOGGER.error("Couldn't generate instance Id!", exception15);
                    throw new IllegalStateException("Cannot run without an instance id.");
                }
            }
            exception = new QuartzSchedulerResources();
            ((QuartzSchedulerResources)exception).setName(string4);
            ((QuartzSchedulerResources)exception).setThreadName(string5);
            ((QuartzSchedulerResources)exception).setInstanceId(string6);
            ((QuartzSchedulerResources)exception).setJobRunShellFactory((IJobRunShellFactory)exception);
            ((QuartzSchedulerResources)exception).setMakeSchedulerThreadDaemon(bl2);
            ((QuartzSchedulerResources)exception).setThreadsInheritInitializersClassLoadContext(bl3);
            ((QuartzSchedulerResources)exception).setBatchTimeWindow(l2);
            ((QuartzSchedulerResources)exception).setMaxBatchSize(n);
            ((QuartzSchedulerResources)exception).setInterruptJobsOnShutdown(bl4);
            ((QuartzSchedulerResources)exception).setInterruptJobsOnShutdownWithWait(bl5);
            iThreadPool.setInstanceName(string4);
            iThreadPool.setInstanceId(string6);
            ((QuartzSchedulerResources)exception).setThreadExecutor(iThreadExecutor);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Initializing ThreadExecutor");
            }
            iThreadExecutor.initialize();
            ((QuartzSchedulerResources)exception).setThreadPool(iThreadPool);
            if (iThreadPool instanceof SimpleThreadPool && bl3) {
                ((SimpleThreadPool)iThreadPool).setThreadsInheritContextClassLoaderOfInitializingThread(bl3);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Initializing ThreadPool");
            }
            iThreadPool.initialize();
            bl8 = true;
            ((QuartzSchedulerResources)exception).setJobStore(iJobStore);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Adding " + commonsArrayList.size() + " scheduler plugins");
            }
            for (ISchedulerPlugin i : commonsArrayList) {
                ((QuartzSchedulerResources)exception).addSchedulerPlugin(i);
            }
            quartzScheduler = new QuartzScheduler((QuartzSchedulerResources)exception, l);
            bl9 = true;
            exception = this.instantiate((QuartzSchedulerResources)exception, quartzScheduler);
            if (iJobFactory != null) {
                quartzScheduler.setJobFactory(iJobFactory);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Initializing scheduler plugins");
            }
            for (int iterator = 0; iterator < commonsArrayList.size(); ++iterator) {
                ((ISchedulerPlugin)commonsArrayList.getAtIndex(iterator)).initialize((String)iCommonsList.getAtIndex(iterator), (IScheduler)exception, iClassLoadHelper);
            }
            Iterator<Object> iterator = cloneable.iterator();
            while (iterator.hasNext()) {
                object42 = (IJobListener)iterator.next();
                quartzScheduler.getListenerManager().addJobListener((IJobListener)object42, (IMatcher<JobKey>)EverythingMatcher.allJobs());
            }
            iterator = object22.iterator();
            while (iterator.hasNext()) {
                object42 = (ITriggerListener)iterator.next();
                quartzScheduler.getListenerManager().addTriggerListener((ITriggerListener)object42, (IMatcher<TriggerKey>)EverythingMatcher.allTriggers());
            }
            for (Object object42 : nonBlockingProperties2.keySet()) {
                String string = nonBlockingProperties2.getProperty((String)object42);
                exception.getContext().put(object42, string);
            }
            iJobStore.setInstanceId(string6);
            iJobStore.setInstanceName(string4);
            iJobStore.setThreadPoolSize(iThreadPool.getPoolSize());
            iJobStore.initialize(iClassLoadHelper, quartzScheduler.getSchedulerSignaler());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Initializing JobRunShellFactory");
            }
            exception.initialize((IScheduler)exception);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Initializing QuartzScheduler");
            }
            quartzScheduler.initialize();
            LOGGER.info("Quartz scheduler '" + exception.getSchedulerName() + "' initialized from " + this.m_sPropSrc);
            LOGGER.info("Quartz scheduler version: " + quartzScheduler.getVersion());
            quartzScheduler.addNoGCObject(schedulerRepository);
            schedulerRepository.bind((IScheduler)exception);
            return exception;
        }
        catch (Exception exception16) {
            StdSchedulerFactory._shutdownFromInstantiateException(iThreadPool, quartzScheduler, bl8, bl9);
            throw exception16;
        }
    }

    private static void _shutdownFromInstantiateException(IThreadPool iThreadPool, QuartzScheduler quartzScheduler, boolean bl, boolean bl2) {
        try {
            if (bl2) {
                quartzScheduler.shutdown(false);
            } else if (bl) {
                iThreadPool.shutdown(false);
            }
        }
        catch (Exception exception) {
            LOGGER.error("Got another exception while shutting down after instantiation exception", exception);
        }
    }

    @Nonnull
    protected IScheduler instantiate(QuartzSchedulerResources quartzSchedulerResources, QuartzScheduler quartzScheduler) {
        return new StdScheduler(quartzScheduler);
    }

    private void _setBeanProps(Object object, NonBlockingProperties nonBlockingProperties) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, IntrospectionException, SchedulerConfigException {
        nonBlockingProperties.remove("class");
        BeanInfo beanInfo = Introspector.getBeanInfo(object.getClass());
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        PropertiesParser propertiesParser = new PropertiesParser(nonBlockingProperties);
        for (String string : nonBlockingProperties.keySet()) {
            String string2 = string.substring(0, 1).toUpperCase(Locale.US);
            String string3 = "set" + string2 + string.substring(1);
            Method method = StdSchedulerFactory._getSetMethod(string3, propertyDescriptorArray);
            try {
                if (method == null) {
                    throw new NoSuchMethodException("No setter for property '" + string + "'");
                }
                Class<?>[] classArray = method.getParameterTypes();
                if (classArray.length != 1) {
                    throw new NoSuchMethodException("No 1-argument setter for property '" + string + "'");
                }
                PropertiesParser propertiesParser2 = propertiesParser;
                String string4 = propertiesParser.getStringProperty(string);
                if (string4 != null && string4.startsWith("$@")) {
                    string4 = string4.substring(2);
                    propertiesParser2 = this.m_aCfg;
                } else {
                    string4 = string;
                }
                if (classArray[0].equals(Integer.TYPE)) {
                    method.invoke(object, propertiesParser2.getIntProperty(string4));
                    continue;
                }
                if (classArray[0].equals(Long.TYPE)) {
                    method.invoke(object, propertiesParser2.getLongProperty(string4));
                    continue;
                }
                if (classArray[0].equals(Float.TYPE)) {
                    method.invoke(object, Float.valueOf(propertiesParser2.getFloatProperty(string4)));
                    continue;
                }
                if (classArray[0].equals(Double.TYPE)) {
                    method.invoke(object, propertiesParser2.getDoubleProperty(string4));
                    continue;
                }
                if (classArray[0].equals(Boolean.TYPE)) {
                    method.invoke(object, propertiesParser2.getBooleanProperty(string4));
                    continue;
                }
                if (classArray[0].equals(String.class)) {
                    method.invoke(object, propertiesParser2.getStringProperty(string4));
                    continue;
                }
                throw new NoSuchMethodException("No primitive-type setter for property '" + string + "'");
            }
            catch (NumberFormatException numberFormatException) {
                throw new SchedulerConfigException("Could not parse property '" + string + "' into correct data type: " + numberFormatException.toString());
            }
        }
    }

    private static Method _getSetMethod(String string, PropertyDescriptor[] propertyDescriptorArray) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null || !method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }

    private Class<?> _loadClass(String string) throws ClassNotFoundException, SchedulerConfigException {
        try {
            ClassLoader classLoader = this._findClassloader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
            throw new SchedulerConfigException("Unable to find a class loader on the current thread or class.");
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (this.getClass().getClassLoader() != null) {
                return this.getClass().getClassLoader().loadClass(string);
            }
            throw classNotFoundException;
        }
    }

    private ClassLoader _findClassloader() {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
            thread.setContextClassLoader(classLoader);
        }
        return classLoader;
    }

    private String _getSchedulerName() {
        return this.m_aCfg.getStringProperty(PROP_SCHED_INSTANCE_NAME, "MiniQuartzScheduler");
    }

    @Override
    public IScheduler getScheduler() throws SchedulerException {
        SchedulerRepository schedulerRepository;
        IScheduler iScheduler;
        if (this.m_aCfg == null) {
            this.initialize();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Looking up scheduler with name '" + this._getSchedulerName() + "'");
        }
        if ((iScheduler = (schedulerRepository = SchedulerRepository.getInstance()).lookup(this._getSchedulerName())) != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Reusing existing scheduler with name '" + this._getSchedulerName() + "'");
            }
            if (iScheduler.isShutdown()) {
                schedulerRepository.remove(this._getSchedulerName());
            } else {
                return iScheduler;
            }
        }
        iScheduler = this._instantiate();
        return iScheduler;
    }

    public static IScheduler getDefaultScheduler() throws SchedulerException {
        StdSchedulerFactory stdSchedulerFactory = new StdSchedulerFactory();
        return stdSchedulerFactory.getScheduler();
    }

    @Override
    public IScheduler getScheduler(String string) throws SchedulerException {
        return SchedulerRepository.getInstance().lookup(string);
    }

    @Override
    public ICommonsCollection<IScheduler> getAllSchedulers() throws SchedulerException {
        return SchedulerRepository.getInstance().lookupAll();
    }
}

