/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl.calendar;

import com.helger.commons.ValueEnforcer;
import com.helger.quartz.CronExpression;
import com.helger.quartz.ICalendar;
import com.helger.quartz.impl.calendar.AbstractCalendar;
import java.text.ParseException;
import java.util.Date;
import java.util.TimeZone;
import javax.annotation.Nonnull;

public class CronCalendar
extends AbstractCalendar<CronCalendar> {
    private CronExpression m_aCronExpression;

    public CronCalendar(@Nonnull CronCalendar cronCalendar) {
        super(cronCalendar);
        this.m_aCronExpression = cronCalendar.m_aCronExpression.getClone();
    }

    public CronCalendar(String string) throws ParseException {
        this(null, string, null);
    }

    public CronCalendar(ICalendar iCalendar, String string) throws ParseException {
        this(iCalendar, string, null);
    }

    public CronCalendar(ICalendar iCalendar, String string, TimeZone timeZone) throws ParseException {
        super(iCalendar, null);
        this.m_aCronExpression = new CronExpression(string);
        this.m_aCronExpression.setTimeZone(timeZone);
    }

    @Override
    public TimeZone getTimeZone() {
        return this.m_aCronExpression.getTimeZone();
    }

    @Override
    public void setTimeZone(TimeZone timeZone) {
        this.m_aCronExpression.setTimeZone(timeZone);
    }

    @Override
    public boolean isTimeIncluded(long l) {
        if (this.getBaseCalendar() != null && !this.getBaseCalendar().isTimeIncluded(l)) {
            return false;
        }
        return !this.m_aCronExpression.isSatisfiedBy(new Date(l));
    }

    @Override
    public long getNextIncludedTime(long l) {
        long l2 = l + 1L;
        while (!this.isTimeIncluded(l2)) {
            if (this.m_aCronExpression.isSatisfiedBy(new Date(l2))) {
                l2 = this.m_aCronExpression.getNextInvalidTimeAfter(new Date(l2)).getTime();
                continue;
            }
            if (this.getBaseCalendar() != null && !this.getBaseCalendar().isTimeIncluded(l2)) {
                l2 = this.getBaseCalendar().getNextIncludedTime(l2);
                continue;
            }
            ++l2;
        }
        return l2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("base calendar: [");
        if (this.getBaseCalendar() != null) {
            stringBuilder.append(this.getBaseCalendar().toString());
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append("], excluded cron expression: '");
        stringBuilder.append(this.m_aCronExpression);
        stringBuilder.append("'");
        return stringBuilder.toString();
    }

    @Nonnull
    public CronExpression getCronExpression() {
        return this.m_aCronExpression;
    }

    public void setCronExpression(@Nonnull String string) throws ParseException {
        CronExpression cronExpression = new CronExpression(string);
        this.setCronExpression(cronExpression);
    }

    public void setCronExpression(@Nonnull CronExpression cronExpression) {
        ValueEnforcer.notNull(cronExpression, "Expression");
        this.m_aCronExpression = cronExpression;
    }

    @Override
    @Nonnull
    public CronCalendar getClone() {
        return new CronCalendar(this);
    }
}

