/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl.matchers;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.quartz.IMatcher;
import com.helger.quartz.utils.Key;
import javax.annotation.Nonnull;

public class AndMatcher<T extends Key<T>>
implements IMatcher<T> {
    private final IMatcher<T> m_aLeftOperand;
    private final IMatcher<T> m_aRightOperand;

    public AndMatcher(@Nonnull IMatcher<T> iMatcher, @Nonnull IMatcher<T> iMatcher2) {
        ValueEnforcer.notNull(iMatcher, "LeftOperand");
        ValueEnforcer.notNull(iMatcher2, "RightOperand");
        this.m_aLeftOperand = iMatcher;
        this.m_aRightOperand = iMatcher2;
    }

    @Nonnull
    public IMatcher<T> getLeftOperand() {
        return this.m_aLeftOperand;
    }

    @Nonnull
    public IMatcher<T> getRightOperand() {
        return this.m_aRightOperand;
    }

    @Override
    public boolean isMatch(T t) {
        return this.m_aLeftOperand.isMatch(t) && this.m_aRightOperand.isMatch(t);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AndMatcher andMatcher = (AndMatcher)object;
        return this.m_aLeftOperand.equals(andMatcher.m_aLeftOperand) && this.m_aRightOperand.equals(andMatcher.m_aRightOperand);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aLeftOperand).append(this.m_aRightOperand).getHashCode();
    }
}

