/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl.matchers;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.quartz.IMatcher;
import com.helger.quartz.utils.Key;
import javax.annotation.Nonnull;

public class KeyMatcher<T extends Key<T>>
implements IMatcher<T> {
    private final T m_aCompareTo;

    protected KeyMatcher(@Nonnull T t) {
        ValueEnforcer.notNull(t, "CompareTo");
        this.m_aCompareTo = t;
    }

    @Nonnull
    public T getCompareToValue() {
        return this.m_aCompareTo;
    }

    @Override
    public boolean isMatch(T t) {
        return ((Key)this.m_aCompareTo).equals(t);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        KeyMatcher keyMatcher = (KeyMatcher)object;
        return ((Key)this.m_aCompareTo).equals(keyMatcher.m_aCompareTo);
    }

    @Override
    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aCompareTo).getHashCode();
    }

    public static <U extends Key<U>> KeyMatcher<U> keyEquals(U u) {
        return new KeyMatcher<U>(u);
    }
}

