/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.impl.triggers;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.datetime.PDTFactory;
import com.helger.quartz.CQuartz;
import com.helger.quartz.CronExpression;
import com.helger.quartz.CronScheduleBuilder;
import com.helger.quartz.ICalendar;
import com.helger.quartz.ICronTrigger;
import com.helger.quartz.IScheduleBuilder;
import com.helger.quartz.ITrigger;
import com.helger.quartz.QCloneUtils;
import com.helger.quartz.impl.triggers.AbstractTrigger;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CronTrigger
extends AbstractTrigger<CronTrigger>
implements ICronTrigger {
    protected static final int YEAR_TO_GIVEUP_SCHEDULING_AT = CQuartz.MAX_YEAR;
    private CronExpression m_aCronEx;
    private Date m_aStartTime;
    private Date m_aEndTime;
    private Date m_aNextFireTime;
    private Date m_aPreviousFireTime;
    private transient TimeZone m_aTimeZone;

    public CronTrigger(@Nonnull CronTrigger cronTrigger) {
        super(cronTrigger);
        this.m_aCronEx = QCloneUtils.getClone(cronTrigger.m_aCronEx);
        this.m_aStartTime = QCloneUtils.getClone(cronTrigger.m_aStartTime);
        this.m_aEndTime = QCloneUtils.getClone(cronTrigger.m_aEndTime);
        this.m_aNextFireTime = QCloneUtils.getClone(cronTrigger.m_aNextFireTime);
        this.m_aPreviousFireTime = QCloneUtils.getClone(cronTrigger.m_aPreviousFireTime);
        this.m_aTimeZone = QCloneUtils.getClone(cronTrigger.m_aTimeZone);
    }

    public CronTrigger() {
        this.setStartTime(new Date());
        this.setTimeZone(TimeZone.getDefault());
    }

    @Override
    @Nullable
    public String getCronExpression() {
        return this.m_aCronEx == null ? null : this.m_aCronEx.getCronExpression();
    }

    public void setCronExpression(@Nonnull String string) throws ParseException {
        TimeZone timeZone = this.getTimeZone();
        this.m_aCronEx = new CronExpression(string);
        this.m_aCronEx.setTimeZone(timeZone);
    }

    public void setCronExpression(@Nonnull CronExpression cronExpression) {
        this.m_aCronEx = cronExpression;
        this.m_aTimeZone = cronExpression.getTimeZone();
    }

    @Override
    @Nullable
    public final Date getStartTime() {
        return this.m_aStartTime;
    }

    @Override
    public final void setStartTime(@Nonnull Date date) {
        ValueEnforcer.notNull(date, "StartTime");
        Date date2 = this.getEndTime();
        if (date2 != null && date2.before(date)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        Calendar calendar = PDTFactory.createCalendar();
        calendar.setTime(date);
        calendar.set(14, 0);
        this.m_aStartTime = calendar.getTime();
    }

    @Override
    @Nullable
    public final Date getEndTime() {
        return this.m_aEndTime;
    }

    @Override
    public final void setEndTime(@Nullable Date date) {
        Date date2 = this.getStartTime();
        if (date2 != null && date != null && date2.after(date)) {
            throw new IllegalArgumentException("End time cannot be before start time");
        }
        this.m_aEndTime = date;
    }

    @Override
    public Date getNextFireTime() {
        return this.m_aNextFireTime;
    }

    @Override
    public void setNextFireTime(Date date) {
        this.m_aNextFireTime = date;
    }

    @Override
    public Date getPreviousFireTime() {
        return this.m_aPreviousFireTime;
    }

    @Override
    public void setPreviousFireTime(Date date) {
        this.m_aPreviousFireTime = date;
    }

    @Override
    @Nonnull
    public TimeZone getTimeZone() {
        if (this.m_aCronEx != null) {
            return this.m_aCronEx.getTimeZone();
        }
        if (this.m_aTimeZone == null) {
            this.m_aTimeZone = TimeZone.getDefault();
        }
        return this.m_aTimeZone;
    }

    public void setTimeZone(@Nullable TimeZone timeZone) {
        if (this.m_aCronEx != null) {
            this.m_aCronEx.setTimeZone(timeZone);
        }
        this.m_aTimeZone = timeZone;
    }

    @Override
    public Date getFireTimeAfter(@Nullable Date date) {
        Date date2 = date;
        if (date2 == null) {
            date2 = new Date();
        }
        if (this.getStartTime().after(date2)) {
            date2 = new Date(this.getStartTime().getTime() - 1000L);
        }
        if (this.getEndTime() != null && date2.compareTo(this.getEndTime()) >= 0) {
            return null;
        }
        Date date3 = this.getTimeAfter(date2);
        if (this.getEndTime() != null && date3 != null && date3.after(this.getEndTime())) {
            return null;
        }
        return date3;
    }

    @Override
    public Date getFinalFireTime() {
        Date date;
        if (this.getEndTime() != null) {
            date = this.getTimeBefore(new Date(this.getEndTime().getTime() + 1000L));
        } else {
            Date date2 = date = this.m_aCronEx == null ? null : this.m_aCronEx.getFinalFireTime();
        }
        if (date != null && this.getStartTime() != null && date.before(this.getStartTime())) {
            return null;
        }
        return date;
    }

    @Override
    public boolean mayFireAgain() {
        return this.getNextFireTime() != null;
    }

    @Override
    protected boolean validateMisfireInstruction(ITrigger.EMisfireInstruction eMisfireInstruction) {
        switch (eMisfireInstruction) {
            case MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY: 
            case MISFIRE_INSTRUCTION_SMART_POLICY: 
            case MISFIRE_INSTRUCTION_FIRE_ONCE_NOW: 
            case MISFIRE_INSTRUCTION_DO_NOTHING: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void updateAfterMisfire(ICalendar iCalendar) {
        ITrigger.EMisfireInstruction eMisfireInstruction = this.getMisfireInstruction();
        if (eMisfireInstruction == ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_SMART_POLICY) {
            eMisfireInstruction = ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_FIRE_ONCE_NOW;
        }
        switch (eMisfireInstruction) {
            case MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY: {
                return;
            }
            case MISFIRE_INSTRUCTION_FIRE_ONCE_NOW: {
                this.setNextFireTime(new Date());
                break;
            }
            case MISFIRE_INSTRUCTION_DO_NOTHING: {
                Date date = this.getFireTimeAfter(new Date());
                while (date != null && iCalendar != null && !iCalendar.isTimeIncluded(date.getTime())) {
                    date = this.getFireTimeAfter(date);
                }
                this.setNextFireTime(date);
                break;
            }
        }
    }

    public boolean willFireOn(Calendar calendar) {
        return this.willFireOn(calendar, false);
    }

    public boolean willFireOn(Calendar calendar, boolean bl) {
        Calendar calendar2 = QCloneUtils.getClone(calendar);
        calendar2.set(14, 0);
        if (bl) {
            calendar2.set(11, 0);
            calendar2.set(12, 0);
            calendar2.set(13, 0);
        }
        Date date = calendar2.getTime();
        Date date2 = this.getFireTimeAfter(new Date(calendar2.getTime().getTime() - 1000L));
        if (date2 == null) {
            return false;
        }
        Calendar calendar3 = Calendar.getInstance(calendar2.getTimeZone(), Locale.getDefault(Locale.Category.FORMAT));
        calendar3.setTime(date2);
        int n = calendar3.get(1);
        int n2 = calendar3.get(2);
        int n3 = calendar3.get(5);
        if (bl) {
            return n == calendar2.get(1) && n2 == calendar2.get(2) && n3 == calendar2.get(5);
        }
        while (date2.before(date)) {
            date2 = this.getFireTimeAfter(date2);
        }
        return date2.equals(date);
    }

    @Override
    public void triggered(ICalendar iCalendar) {
        this.m_aPreviousFireTime = this.m_aNextFireTime;
        this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
        while (this.m_aNextFireTime != null && iCalendar != null && !iCalendar.isTimeIncluded(this.m_aNextFireTime.getTime())) {
            this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
        }
    }

    @Override
    public void updateWithNewCalendar(ICalendar iCalendar, long l) {
        this.m_aNextFireTime = this.getFireTimeAfter(this.m_aPreviousFireTime);
        if (this.m_aNextFireTime == null || iCalendar == null) {
            return;
        }
        Date date = new Date();
        while (this.m_aNextFireTime != null && !iCalendar.isTimeIncluded(this.m_aNextFireTime.getTime())) {
            long l2;
            this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
            if (this.m_aNextFireTime == null) break;
            Calendar calendar = PDTFactory.createCalendar();
            calendar.setTime(this.m_aNextFireTime);
            if (calendar.get(1) > YEAR_TO_GIVEUP_SCHEDULING_AT) {
                this.m_aNextFireTime = null;
            }
            if (this.m_aNextFireTime == null || !this.m_aNextFireTime.before(date) || (l2 = date.getTime() - this.m_aNextFireTime.getTime()) < l) continue;
            this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
        }
    }

    @Override
    public Date computeFirstFireTime(ICalendar iCalendar) {
        this.m_aNextFireTime = this.getFireTimeAfter(new Date(this.getStartTime().getTime() - 1000L));
        while (this.m_aNextFireTime != null && iCalendar != null && !iCalendar.isTimeIncluded(this.m_aNextFireTime.getTime())) {
            this.m_aNextFireTime = this.getFireTimeAfter(this.m_aNextFireTime);
        }
        return this.m_aNextFireTime;
    }

    @Override
    public String getExpressionSummary() {
        return this.m_aCronEx == null ? null : this.m_aCronEx.getExpressionSummary();
    }

    @Override
    public IScheduleBuilder<CronTrigger> getScheduleBuilder() {
        CronScheduleBuilder cronScheduleBuilder = CronScheduleBuilder.cronSchedule(this.getCronExpression()).inTimeZone(this.getTimeZone());
        switch (this.getMisfireInstruction()) {
            case MISFIRE_INSTRUCTION_DO_NOTHING: {
                cronScheduleBuilder.withMisfireHandlingInstructionDoNothing();
                break;
            }
            case MISFIRE_INSTRUCTION_FIRE_ONCE_NOW: {
                cronScheduleBuilder.withMisfireHandlingInstructionFireAndProceed();
            }
        }
        return cronScheduleBuilder;
    }

    @Nullable
    protected Date getTimeAfter(Date date) {
        return this.m_aCronEx == null ? null : this.m_aCronEx.getTimeAfter(date);
    }

    @Nullable
    protected Date getTimeBefore(Date date) {
        return this.m_aCronEx == null ? null : this.m_aCronEx.getTimeBefore(date);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public CronTrigger getClone() {
        return new CronTrigger(this);
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }
}

