/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.listeners;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IJobListener;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.JobKey;
import com.helger.quartz.SchedulerException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobChainingJobListener
implements IJobListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobChainingJobListener.class);
    private final String m_sName;
    private final ICommonsMap<JobKey, JobKey> m_aChainLinks = new CommonsHashMap<JobKey, JobKey>();

    public JobChainingJobListener(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Name");
        this.m_sName = string;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.m_sName;
    }

    public void addJobChainLink(JobKey jobKey, JobKey jobKey2) {
        ValueEnforcer.notNull(jobKey, "FirstJob");
        ValueEnforcer.notNull(jobKey.getName(), "FirstJob.Name");
        ValueEnforcer.notNull(jobKey2, "SecondJob");
        ValueEnforcer.notNull(jobKey2.getName(), "SecondJob.Name");
        this.m_aChainLinks.put(jobKey, jobKey2);
    }

    @Override
    public void jobWasExecuted(@Nonnull IJobExecutionContext iJobExecutionContext, JobExecutionException jobExecutionException) {
        JobKey jobKey = (JobKey)this.m_aChainLinks.get(iJobExecutionContext.getJobDetail().getKey());
        if (jobKey == null) {
            return;
        }
        LOGGER.info("Job '" + iJobExecutionContext.getJobDetail().getKey() + "' will now chain to Job '" + jobKey + "'");
        try {
            iJobExecutionContext.getScheduler().triggerJob(jobKey);
        }
        catch (SchedulerException schedulerException) {
            LOGGER.error("Error encountered during chaining to Job '" + jobKey + "'", schedulerException);
        }
    }
}

