/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.plugins.history;

import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.IJobListener;
import com.helger.quartz.IMatcher;
import com.helger.quartz.IScheduler;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobExecutionException;
import com.helger.quartz.JobKey;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.impl.matchers.EverythingMatcher;
import com.helger.quartz.spi.IClassLoadHelper;
import com.helger.quartz.spi.ISchedulerPlugin;
import java.text.MessageFormat;
import java.util.Date;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingJobHistoryPlugin
implements ISchedulerPlugin,
IJobListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingJobHistoryPlugin.class);
    private String m_sName;
    private String m_sJobToBeFiredMessage = "Job {1}.{0} fired (by trigger {4}.{3}) at: {2, date, HH:mm:ss MM/dd/yyyy}";
    private String m_sJobSuccessMessage = "Job {1}.{0} execution complete at {2, date, HH:mm:ss MM/dd/yyyy} and reports: {8}";
    private String m_sJobFailedMessage = "Job {1}.{0} execution failed at {2, date, HH:mm:ss MM/dd/yyyy} and reports: {8}";
    private String m_sJobWasVetoedMessage = "Job {1}.{0} was vetoed.  It was to be fired (by trigger {4}.{3}) at: {2, date, HH:mm:ss MM/dd/yyyy}";

    public String getJobSuccessMessage() {
        return this.m_sJobSuccessMessage;
    }

    public String getJobFailedMessage() {
        return this.m_sJobFailedMessage;
    }

    public String getJobToBeFiredMessage() {
        return this.m_sJobToBeFiredMessage;
    }

    public void setJobSuccessMessage(String string) {
        this.m_sJobSuccessMessage = string;
    }

    public void setJobFailedMessage(String string) {
        this.m_sJobFailedMessage = string;
    }

    public void setJobToBeFiredMessage(String string) {
        this.m_sJobToBeFiredMessage = string;
    }

    public String getJobWasVetoedMessage() {
        return this.m_sJobWasVetoedMessage;
    }

    public void setJobWasVetoedMessage(String string) {
        this.m_sJobWasVetoedMessage = string;
    }

    @Override
    public void initialize(String string, IScheduler iScheduler, IClassLoadHelper iClassLoadHelper) throws SchedulerException {
        this.m_sName = string;
        iScheduler.getListenerManager().addJobListener((IJobListener)this, (IMatcher<JobKey>)EverythingMatcher.allJobs());
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    @Override
    public void jobToBeExecuted(IJobExecutionContext iJobExecutionContext) {
        if (LOGGER.isInfoEnabled()) {
            ITrigger iTrigger = iJobExecutionContext.getTrigger();
            Object[] objectArray = new Object[]{iJobExecutionContext.getJobDetail().getKey().getName(), iJobExecutionContext.getJobDetail().getKey().getGroup(), new Date(), iTrigger.getKey().getName(), iTrigger.getKey().getGroup(), iTrigger.getPreviousFireTime(), iTrigger.getNextFireTime(), iJobExecutionContext.getRefireCount()};
            LOGGER.info(new MessageFormat(this.getJobToBeFiredMessage(), Locale.US).format(objectArray));
        }
    }

    @Override
    public void jobWasExecuted(IJobExecutionContext iJobExecutionContext, JobExecutionException jobExecutionException) {
        ITrigger iTrigger = iJobExecutionContext.getTrigger();
        if (jobExecutionException != null) {
            if (LOGGER.isWarnEnabled()) {
                String string = jobExecutionException.getMessage();
                Object[] objectArray = new Object[]{iJobExecutionContext.getJobDetail().getKey().getName(), iJobExecutionContext.getJobDetail().getKey().getGroup(), new Date(), iTrigger.getKey().getName(), iTrigger.getKey().getGroup(), iTrigger.getPreviousFireTime(), iTrigger.getNextFireTime(), iJobExecutionContext.getRefireCount(), string};
                LOGGER.warn(new MessageFormat(this.getJobFailedMessage(), Locale.US).format(objectArray), jobExecutionException);
            }
        } else if (LOGGER.isInfoEnabled()) {
            String string = String.valueOf(iJobExecutionContext.getResult());
            Object[] objectArray = new Object[]{iJobExecutionContext.getJobDetail().getKey().getName(), iJobExecutionContext.getJobDetail().getKey().getGroup(), new Date(), iTrigger.getKey().getName(), iTrigger.getKey().getGroup(), iTrigger.getPreviousFireTime(), iTrigger.getNextFireTime(), iJobExecutionContext.getRefireCount(), string};
            LOGGER.info(new MessageFormat(this.getJobSuccessMessage(), Locale.US).format(objectArray));
        }
    }

    @Override
    public void jobExecutionVetoed(IJobExecutionContext iJobExecutionContext) {
        if (LOGGER.isInfoEnabled()) {
            ITrigger iTrigger = iJobExecutionContext.getTrigger();
            Object[] objectArray = new Object[]{iJobExecutionContext.getJobDetail().getKey().getName(), iJobExecutionContext.getJobDetail().getKey().getGroup(), new Date(), iTrigger.getKey().getName(), iTrigger.getKey().getGroup(), iTrigger.getPreviousFireTime(), iTrigger.getNextFireTime(), iJobExecutionContext.getRefireCount()};
            LOGGER.info(new MessageFormat(this.getJobWasVetoedMessage(), Locale.US).format(objectArray));
        }
    }
}

