/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.plugins.management;

import com.helger.quartz.IScheduler;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.spi.IClassLoadHelper;
import com.helger.quartz.spi.ISchedulerPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownHookPlugin
implements ISchedulerPlugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(ShutdownHookPlugin.class);
    private boolean m_bCleanShutdown = true;

    public boolean isCleanShutdown() {
        return this.m_bCleanShutdown;
    }

    public void setCleanShutdown(boolean bl) {
        this.m_bCleanShutdown = bl;
    }

    @Override
    public void initialize(String string, final IScheduler iScheduler, IClassLoadHelper iClassLoadHelper) throws SchedulerException {
        LOGGER.info("Registering Quartz shutdown hook.");
        Thread thread = new Thread("Quartz Shutdown-Hook " + iScheduler.getSchedulerName()){

            @Override
            public void run() {
                LOGGER.info("Shutting down Quartz...");
                try {
                    iScheduler.shutdown(ShutdownHookPlugin.this.isCleanShutdown());
                }
                catch (SchedulerException schedulerException) {
                    LOGGER.info("Error shutting down Quartz: " + schedulerException.getMessage(), schedulerException);
                }
            }
        };
        Runtime.getRuntime().addShutdownHook(thread);
    }

    @Override
    public void start() {
    }

    @Override
    public void shutdown() {
    }
}

