/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.simpl;

import com.helger.quartz.IJob;
import com.helger.quartz.IScheduler;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.simpl.SimpleJobFactory;
import com.helger.quartz.spi.TriggerFiredBundle;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertySettingJobFactory
extends SimpleJobFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertySettingJobFactory.class);
    private boolean m_bWarnIfNotFound = false;
    private boolean m_bThrowIfNotFound = false;

    @Override
    public IJob newJob(TriggerFiredBundle triggerFiredBundle, IScheduler iScheduler) throws SchedulerException {
        IJob iJob = super.newJob(triggerFiredBundle, iScheduler);
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.putAll(iScheduler.getContext());
        jobDataMap.putAll(triggerFiredBundle.getJobDetail().getJobDataMap());
        jobDataMap.putAll(triggerFiredBundle.getTrigger().getJobDataMap());
        this.setBeanProps(iJob, jobDataMap);
        return iJob;
    }

    protected void setBeanProps(Object object, JobDataMap jobDataMap) throws SchedulerException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(object.getClass());
        }
        catch (IntrospectionException introspectionException) {
            this._handleError("Unable to introspect Job class.", introspectionException);
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        Iterator iterator = jobDataMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            String string = (String)entry2.getKey();
            String string2 = string.substring(0, 1).toUpperCase(Locale.US);
            String string3 = "set" + string2 + string.substring(1);
            Method method = PropertySettingJobFactory._getSetMethod(string3, propertyDescriptorArray);
            Class<?> clazz = null;
            Object object2 = null;
            try {
                if (method == null) {
                    this._handleError("No setter on Job class " + object.getClass().getName() + " for property '" + string + "'");
                    continue;
                }
                clazz = method.getParameterTypes()[0];
                object2 = entry2.getValue();
                Object object3 = null;
                if (clazz.isPrimitive()) {
                    if (object2 == null) {
                        this._handleError("Cannot set primitive property '" + string + "' on Job class " + object.getClass().getName() + " to null.");
                        continue;
                    }
                    if (clazz.equals(Integer.TYPE)) {
                        if (object2 instanceof String) {
                            object3 = Integer.valueOf((String)object2);
                        } else if (object2 instanceof Integer) {
                            object3 = object2;
                        }
                    } else if (clazz.equals(Long.TYPE)) {
                        if (object2 instanceof String) {
                            object3 = Long.valueOf((String)object2);
                        } else if (object2 instanceof Long) {
                            object3 = object2;
                        }
                    } else if (clazz.equals(Float.TYPE)) {
                        if (object2 instanceof String) {
                            object3 = Float.valueOf((String)object2);
                        } else if (object2 instanceof Float) {
                            object3 = object2;
                        }
                    } else if (clazz.equals(Double.TYPE)) {
                        if (object2 instanceof String) {
                            object3 = Double.valueOf((String)object2);
                        } else if (object2 instanceof Double) {
                            object3 = object2;
                        }
                    } else if (clazz.equals(Boolean.TYPE)) {
                        if (object2 instanceof String) {
                            object3 = Boolean.valueOf((String)object2);
                        } else if (object2 instanceof Boolean) {
                            object3 = object2;
                        }
                    } else if (clazz.equals(Byte.TYPE)) {
                        if (object2 instanceof String) {
                            object3 = Byte.valueOf((String)object2);
                        } else if (object2 instanceof Byte) {
                            object3 = object2;
                        }
                    } else if (clazz.equals(Short.TYPE)) {
                        if (object2 instanceof String) {
                            object3 = Short.valueOf((String)object2);
                        } else if (object2 instanceof Short) {
                            object3 = object2;
                        }
                    } else if (clazz.equals(Character.TYPE)) {
                        if (object2 instanceof String) {
                            String string4 = (String)object2;
                            if (string4.length() == 1) {
                                object3 = Character.valueOf(string4.charAt(0));
                            }
                        } else if (object2 instanceof Character) {
                            object3 = object2;
                        }
                    }
                } else if (object2 != null && clazz.isAssignableFrom(object2.getClass())) {
                    object3 = object2;
                }
                if (object2 != null && object3 == null) {
                    this._handleError("The setter on Job class " + object.getClass().getName() + " for property '" + string + "' expects a " + clazz + " but was given " + object2.getClass().getName());
                    continue;
                }
                method.invoke(object, object3);
            }
            catch (NumberFormatException numberFormatException) {
                this._handleError("The setter on Job class " + object.getClass().getName() + " for property '" + string + "' expects a " + clazz + " but was given " + object2.getClass().getName(), numberFormatException);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this._handleError("The setter on Job class " + object.getClass().getName() + " for property '" + string + "' expects a " + clazz + " but was given " + object2.getClass().getName(), illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                this._handleError("The setter on Job class " + object.getClass().getName() + " for property '" + string + "' could not be accessed.", illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                this._handleError("The setter on Job class " + object.getClass().getName() + " for property '" + string + "' could not be invoked.", invocationTargetException);
            }
        }
    }

    private void _handleError(String string) throws SchedulerException {
        this._handleError(string, null);
    }

    private void _handleError(String string, Exception exception) throws SchedulerException {
        if (this.isThrowIfPropertyNotFound()) {
            throw new SchedulerException(string, exception);
        }
        if (this.isWarnIfPropertyNotFound()) {
            if (exception == null) {
                LOGGER.warn(string);
            } else {
                LOGGER.warn(string, exception);
            }
        }
    }

    private static Method _getSetMethod(String string, PropertyDescriptor[] propertyDescriptorArray) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null || method.getParameterTypes().length != 1 || !method.getName().equals(string)) continue;
            return method;
        }
        return null;
    }

    public boolean isThrowIfPropertyNotFound() {
        return this.m_bThrowIfNotFound;
    }

    public void setThrowIfPropertyNotFound(boolean bl) {
        this.m_bThrowIfNotFound = bl;
    }

    public boolean isWarnIfPropertyNotFound() {
        return this.m_bWarnIfNotFound;
    }

    public void setWarnIfPropertyNotFound(boolean bl) {
        this.m_bWarnIfNotFound = bl;
    }
}

