/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.simpl;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.CommonsHashSet;
import com.helger.commons.collection.impl.CommonsTreeSet;
import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.collection.impl.ICommonsSortedSet;
import com.helger.quartz.ICalendar;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobKey;
import com.helger.quartz.JobPersistenceException;
import com.helger.quartz.ObjectAlreadyExistsException;
import com.helger.quartz.QCloneUtils;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.impl.matchers.GroupMatcher;
import com.helger.quartz.impl.matchers.StringMatcher;
import com.helger.quartz.simpl.JobWrapper;
import com.helger.quartz.simpl.TriggerWrapper;
import com.helger.quartz.simpl.TriggerWrapperComparator;
import com.helger.quartz.spi.IClassLoadHelper;
import com.helger.quartz.spi.IJobStore;
import com.helger.quartz.spi.IOperableTrigger;
import com.helger.quartz.spi.ISchedulerSignaler;
import com.helger.quartz.spi.TriggerFiredBundle;
import com.helger.quartz.spi.TriggerFiredResult;
import com.helger.quartz.utils.Key;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RAMJobStore
implements IJobStore {
    private static final Logger LOGGER = LoggerFactory.getLogger(RAMJobStore.class);
    private static final AtomicLong FIRED_TRIGGER_RECORD_COUNTER = new AtomicLong(System.currentTimeMillis());
    protected final ICommonsMap<JobKey, JobWrapper> m_aJobsByKey = new CommonsHashMap<JobKey, JobWrapper>(1000);
    protected final ICommonsMap<TriggerKey, TriggerWrapper> m_aTriggersByKey = new CommonsHashMap<TriggerKey, TriggerWrapper>(1000);
    protected final ICommonsMap<String, ICommonsMap<JobKey, JobWrapper>> m_aJobsByGroup = new CommonsHashMap<String, ICommonsMap<JobKey, JobWrapper>>(25);
    protected final ICommonsMap<String, ICommonsMap<TriggerKey, TriggerWrapper>> m_aTriggersByGroup = new CommonsHashMap<String, ICommonsMap<TriggerKey, TriggerWrapper>>(25);
    protected final ICommonsSortedSet<TriggerWrapper> m_aTimeTriggers = new CommonsTreeSet<TriggerWrapperComparator>(new TriggerWrapperComparator());
    protected final ICommonsMap<String, ICalendar> m_aCalendarsByName = new CommonsHashMap<String, ICalendar>(25);
    protected final ICommonsList<TriggerWrapper> m_aTriggers = new CommonsArrayList<int>(1000);
    protected final Object m_aLock = new Object();
    protected final ICommonsSet<String> m_aPausedTriggerGroups = new CommonsHashSet<String>();
    protected final ICommonsSet<String> m_aPausedJobGroups = new CommonsHashSet<String>();
    protected final ICommonsSet<JobKey> m_aBlockedJobs = new CommonsHashSet<JobKey>();
    protected long m_nMisfireThreshold = 5000L;
    protected ISchedulerSignaler m_aSignaler;

    @Override
    public void initialize(IClassLoadHelper iClassLoadHelper, ISchedulerSignaler iSchedulerSignaler) {
        this.m_aSignaler = iSchedulerSignaler;
        LOGGER.info("RAMJobStore initialized.");
    }

    @Override
    public void schedulerStarted() {
    }

    @Override
    public void schedulerPaused() {
    }

    @Override
    public void schedulerResumed() {
    }

    public long getMisfireThreshold() {
        return this.m_nMisfireThreshold;
    }

    public void setMisfireThreshold(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("Misfire threshold must be larger than 0");
        }
        this.m_nMisfireThreshold = l;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public boolean supportsPersistence() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearAllSchedulingData() throws JobPersistenceException {
        Object object = this.m_aLock;
        synchronized (object) {
            ICommonsSet<Key> iCommonsSet;
            ICommonsList<String> iCommonsList = this.getTriggerGroupNames();
            for (String string : iCommonsList) {
                iCommonsSet = this.getTriggerKeys(GroupMatcher.triggerGroupEquals(string));
                for (TriggerKey key : iCommonsSet) {
                    this.removeTrigger(key);
                }
            }
            iCommonsList = this.getJobGroupNames();
            for (String string : iCommonsList) {
                iCommonsSet = this.getJobKeys(GroupMatcher.jobGroupEquals(string));
                for (JobKey jobKey : iCommonsSet) {
                    this.removeJob(jobKey);
                }
            }
            iCommonsList = this.getCalendarNames();
            for (String string : iCommonsList) {
                this.removeCalendar(string);
            }
        }
    }

    @Override
    public void storeJobAndTrigger(IJobDetail iJobDetail, IOperableTrigger iOperableTrigger) throws JobPersistenceException {
        this.storeJob(iJobDetail, false);
        this.storeTrigger(iOperableTrigger, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeJob(IJobDetail iJobDetail, boolean bl) throws ObjectAlreadyExistsException {
        JobWrapper jobWrapper = new JobWrapper((IJobDetail)iJobDetail.getClone());
        boolean bl2 = false;
        Object object = this.m_aLock;
        synchronized (object) {
            if (this.m_aJobsByKey.get(jobWrapper.m_aKey) != null) {
                if (!bl) {
                    throw new ObjectAlreadyExistsException(iJobDetail);
                }
                bl2 = true;
            }
            if (bl2) {
                JobWrapper jobWrapper2 = (JobWrapper)this.m_aJobsByKey.get(jobWrapper.m_aKey);
                jobWrapper2.setJobDetail(jobWrapper.getJobDetail());
            } else {
                CommonsHashMap commonsHashMap = (CommonsHashMap)this.m_aJobsByGroup.get(iJobDetail.getKey().getGroup());
                if (commonsHashMap == null) {
                    commonsHashMap = new CommonsHashMap(100);
                    this.m_aJobsByGroup.put(iJobDetail.getKey().getGroup(), commonsHashMap);
                }
                commonsHashMap.put(iJobDetail.getKey(), jobWrapper);
                this.m_aJobsByKey.put(jobWrapper.m_aKey, jobWrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJob(JobKey jobKey) {
        boolean bl = false;
        Object object = this.m_aLock;
        synchronized (object) {
            ICommonsList<IOperableTrigger> iCommonsList = this.getTriggersForJob(jobKey);
            Object object2 = iCommonsList.iterator();
            while (object2.hasNext()) {
                IOperableTrigger iOperableTrigger = (IOperableTrigger)object2.next();
                this.removeTrigger(iOperableTrigger.getKey());
                bl = true;
            }
            boolean bl2 = bl = this.m_aJobsByKey.remove(jobKey) != null || bl;
            if (bl && (object2 = (ICommonsMap)this.m_aJobsByGroup.get(jobKey.getGroup())) != null) {
                object2.remove(jobKey);
                if (object2.isEmpty()) {
                    this.m_aJobsByGroup.remove(jobKey.getGroup());
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeJobs(List<JobKey> list) throws JobPersistenceException {
        boolean bl = true;
        Object object = this.m_aLock;
        synchronized (object) {
            for (JobKey jobKey : list) {
                bl = this.removeJob(jobKey) && bl;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeTriggers(List<TriggerKey> list) throws JobPersistenceException {
        boolean bl = true;
        Object object = this.m_aLock;
        synchronized (object) {
            for (TriggerKey triggerKey : list) {
                bl = this.removeTrigger(triggerKey) && bl;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeJobsAndTriggers(Map<IJobDetail, Set<? extends ITrigger>> map, boolean bl) throws JobPersistenceException {
        Object object = this.m_aLock;
        synchronized (object) {
            if (!bl) {
                for (Map.Entry<IJobDetail, Set<? extends ITrigger>> entry : map.entrySet()) {
                    if (this.checkExists(entry.getKey().getKey())) {
                        throw new ObjectAlreadyExistsException(entry.getKey());
                    }
                    for (ITrigger iTrigger : entry.getValue()) {
                        if (!this.checkExists(iTrigger.getKey())) continue;
                        throw new ObjectAlreadyExistsException(iTrigger);
                    }
                }
            }
            for (Map.Entry<IJobDetail, Set<? extends ITrigger>> entry : map.entrySet()) {
                this.storeJob(entry.getKey(), true);
                for (ITrigger iTrigger : entry.getValue()) {
                    this.storeTrigger((IOperableTrigger)iTrigger, true);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeTrigger(IOperableTrigger iOperableTrigger, boolean bl) throws JobPersistenceException {
        TriggerWrapper triggerWrapper = new TriggerWrapper(iOperableTrigger.getClone());
        Object object = this.m_aLock;
        synchronized (object) {
            if (this.m_aTriggersByKey.get(triggerWrapper.m_aKey) != null) {
                if (!bl) {
                    throw new ObjectAlreadyExistsException(iOperableTrigger);
                }
                this._removeTrigger(iOperableTrigger.getKey(), false);
            }
            if (this.retrieveJob(iOperableTrigger.getJobKey()) == null) {
                throw new JobPersistenceException("The job (" + iOperableTrigger.getJobKey() + ") referenced by the trigger does not exist.");
            }
            this.m_aTriggers.add(triggerWrapper);
            CommonsHashMap commonsHashMap = (CommonsHashMap)this.m_aTriggersByGroup.get(iOperableTrigger.getKey().getGroup());
            if (commonsHashMap == null) {
                commonsHashMap = new CommonsHashMap(100);
                this.m_aTriggersByGroup.put(iOperableTrigger.getKey().getGroup(), commonsHashMap);
            }
            commonsHashMap.put(iOperableTrigger.getKey(), triggerWrapper);
            this.m_aTriggersByKey.put(triggerWrapper.m_aKey, triggerWrapper);
            if (this.m_aPausedTriggerGroups.contains(iOperableTrigger.getKey().getGroup()) || this.m_aPausedJobGroups.contains(iOperableTrigger.getJobKey().getGroup())) {
                triggerWrapper.m_nState = 4;
                if (this.m_aBlockedJobs.contains(triggerWrapper.m_aJobKey)) {
                    triggerWrapper.m_nState = 6;
                }
            } else if (this.m_aBlockedJobs.contains(triggerWrapper.m_aJobKey)) {
                triggerWrapper.m_nState = 5;
            } else {
                this.m_aTimeTriggers.add(triggerWrapper);
            }
        }
    }

    @Override
    public boolean removeTrigger(TriggerKey triggerKey) {
        return this._removeTrigger(triggerKey, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _removeTrigger(TriggerKey triggerKey, boolean bl) {
        boolean bl2;
        Object object = this.m_aLock;
        synchronized (object) {
            boolean bl3 = bl2 = this.m_aTriggersByKey.remove(triggerKey) != null;
            if (bl2) {
                ICommonsMap iCommonsMap = (ICommonsMap)this.m_aTriggersByGroup.get(triggerKey.getGroup());
                if (iCommonsMap != null) {
                    iCommonsMap.remove(triggerKey);
                    if (iCommonsMap.isEmpty()) {
                        this.m_aTriggersByGroup.remove(triggerKey.getGroup());
                    }
                }
                TriggerWrapper triggerWrapper = null;
                Iterator iterator = this.m_aTriggers.iterator();
                while (iterator.hasNext()) {
                    triggerWrapper = (TriggerWrapper)iterator.next();
                    if (!triggerKey.equals(triggerWrapper.m_aKey)) continue;
                    iterator.remove();
                    break;
                }
                this.m_aTimeTriggers.remove(triggerWrapper);
                if (bl) {
                    JobWrapper jobWrapper = (JobWrapper)this.m_aJobsByKey.get(triggerWrapper.m_aJobKey);
                    ICommonsList<IOperableTrigger> iCommonsList = this.getTriggersForJob(triggerWrapper.m_aJobKey);
                    if ((iCommonsList == null || iCommonsList.isEmpty()) && !jobWrapper.getJobDetail().isDurable() && this.removeJob(jobWrapper.m_aKey)) {
                        this.m_aSignaler.notifySchedulerListenersJobDeleted(jobWrapper.m_aKey);
                    }
                }
            }
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean replaceTrigger(TriggerKey triggerKey, IOperableTrigger iOperableTrigger) throws JobPersistenceException {
        boolean bl;
        Object object = this.m_aLock;
        synchronized (object) {
            TriggerWrapper triggerWrapper = (TriggerWrapper)this.m_aTriggersByKey.remove(triggerKey);
            boolean bl2 = bl = triggerWrapper != null;
            if (bl) {
                if (!triggerWrapper.getTrigger().getJobKey().equals(iOperableTrigger.getJobKey())) {
                    throw new JobPersistenceException("New trigger is not related to the same job as the old trigger.");
                }
                triggerWrapper = null;
                ICommonsMap iCommonsMap = (ICommonsMap)this.m_aTriggersByGroup.get(triggerKey.getGroup());
                if (iCommonsMap != null) {
                    iCommonsMap.remove(triggerKey);
                    if (iCommonsMap.isEmpty()) {
                        this.m_aTriggersByGroup.remove(triggerKey.getGroup());
                    }
                }
                Iterator iterator = this.m_aTriggers.iterator();
                while (iterator.hasNext()) {
                    triggerWrapper = (TriggerWrapper)iterator.next();
                    if (!triggerKey.equals(triggerWrapper.m_aKey)) continue;
                    iterator.remove();
                    break;
                }
                this.m_aTimeTriggers.remove(triggerWrapper);
                try {
                    this.storeTrigger(iOperableTrigger, false);
                }
                catch (JobPersistenceException jobPersistenceException) {
                    this.storeTrigger(triggerWrapper.getTrigger(), false);
                    throw jobPersistenceException;
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IJobDetail retrieveJob(JobKey jobKey) {
        Object object = this.m_aLock;
        synchronized (object) {
            JobWrapper jobWrapper = (JobWrapper)this.m_aJobsByKey.get(jobKey);
            return jobWrapper != null ? (IJobDetail)jobWrapper.getJobDetail().getClone() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOperableTrigger retrieveTrigger(TriggerKey triggerKey) {
        Object object = this.m_aLock;
        synchronized (object) {
            TriggerWrapper triggerWrapper = (TriggerWrapper)this.m_aTriggersByKey.get(triggerKey);
            return triggerWrapper != null ? triggerWrapper.getTrigger().getClone() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkExists(JobKey jobKey) throws JobPersistenceException {
        Object object = this.m_aLock;
        synchronized (object) {
            return this.m_aJobsByKey.get(jobKey) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkExists(TriggerKey triggerKey) throws JobPersistenceException {
        Object object = this.m_aLock;
        synchronized (object) {
            return this.m_aTriggersByKey.get(triggerKey) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ITrigger.ETriggerState getTriggerState(TriggerKey triggerKey) throws JobPersistenceException {
        Object object = this.m_aLock;
        synchronized (object) {
            TriggerWrapper triggerWrapper = (TriggerWrapper)this.m_aTriggersByKey.get(triggerKey);
            if (triggerWrapper == null) {
                return ITrigger.ETriggerState.NONE;
            }
            if (triggerWrapper.m_nState == 3) {
                return ITrigger.ETriggerState.COMPLETE;
            }
            if (triggerWrapper.m_nState == 4) {
                return ITrigger.ETriggerState.PAUSED;
            }
            if (triggerWrapper.m_nState == 6) {
                return ITrigger.ETriggerState.PAUSED;
            }
            if (triggerWrapper.m_nState == 5) {
                return ITrigger.ETriggerState.BLOCKED;
            }
            if (triggerWrapper.m_nState == 7) {
                return ITrigger.ETriggerState.ERROR;
            }
            return ITrigger.ETriggerState.NORMAL;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeCalendar(String string, ICalendar iCalendar, boolean bl, boolean bl2) throws ObjectAlreadyExistsException {
        ICalendar iCalendar2 = iCalendar.getClone();
        Object object = this.m_aLock;
        synchronized (object) {
            Object v = this.m_aCalendarsByName.get(string);
            if (v != null && !bl) {
                throw new ObjectAlreadyExistsException("Calendar with name '" + string + "' already exists.");
            }
            if (v != null) {
                this.m_aCalendarsByName.remove(string);
            }
            this.m_aCalendarsByName.put(string, iCalendar2);
            if (v != null && bl2) {
                for (TriggerWrapper triggerWrapper : this.getTriggerWrappersForCalendar(string)) {
                    IOperableTrigger iOperableTrigger = triggerWrapper.getTrigger();
                    boolean bl3 = this.m_aTimeTriggers.remove(triggerWrapper);
                    iOperableTrigger.updateWithNewCalendar(iCalendar2, this.getMisfireThreshold());
                    if (!bl3) continue;
                    this.m_aTimeTriggers.add(triggerWrapper);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeCalendar(String string) throws JobPersistenceException {
        int n = 0;
        Object object = this.m_aLock;
        synchronized (object) {
            for (TriggerWrapper triggerWrapper : this.m_aTriggers) {
                IOperableTrigger iOperableTrigger = triggerWrapper.m_aTrigger;
                if (iOperableTrigger.getCalendarName() == null || !iOperableTrigger.getCalendarName().equals(string)) continue;
                ++n;
            }
        }
        if (n > 0) {
            throw new JobPersistenceException("Calender cannot be removed if it referenced by a Trigger!");
        }
        return this.m_aCalendarsByName.remove(string) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICalendar retrieveCalendar(String string) {
        Object object = this.m_aLock;
        synchronized (object) {
            ICalendar iCalendar = (ICalendar)this.m_aCalendarsByName.get(string);
            if (iCalendar != null) {
                return iCalendar.getClone();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfJobs() {
        Object object = this.m_aLock;
        synchronized (object) {
            return this.m_aJobsByKey.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfTriggers() {
        Object object = this.m_aLock;
        synchronized (object) {
            return this.m_aTriggers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfCalendars() {
        Object object = this.m_aLock;
        synchronized (object) {
            return this.m_aCalendarsByName.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommonsSet<JobKey> getJobKeys(GroupMatcher<JobKey> groupMatcher) {
        CommonsHashSet commonsHashSet = null;
        Object object = this.m_aLock;
        synchronized (object) {
            StringMatcher.EStringOperatorName eStringOperatorName = groupMatcher.getCompareWithOperator();
            String string = groupMatcher.getCompareToValue();
            if (eStringOperatorName == StringMatcher.EStringOperatorName.EQUALS) {
                ICommonsMap iCommonsMap = (ICommonsMap)this.m_aJobsByGroup.get(string);
                if (iCommonsMap != null) {
                    commonsHashSet = new CommonsHashSet();
                    for (JobWrapper jobWrapper : iCommonsMap.values()) {
                        if (jobWrapper == null) continue;
                        commonsHashSet.add(jobWrapper.getJobDetail().getKey());
                    }
                }
            } else {
                for (Map.Entry entry : this.m_aJobsByGroup.entrySet()) {
                    if (!eStringOperatorName.evaluate((String)entry.getKey(), string) || entry.getValue() == null) continue;
                    if (commonsHashSet == null) {
                        commonsHashSet = new CommonsHashSet();
                    }
                    for (JobWrapper jobWrapper : ((ICommonsMap)entry.getValue()).values()) {
                        if (jobWrapper == null) continue;
                        commonsHashSet.add(jobWrapper.getJobDetail().getKey());
                    }
                }
            }
        }
        return commonsHashSet == null ? new CommonsHashSet() : commonsHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommonsList<String> getCalendarNames() {
        Object object = this.m_aLock;
        synchronized (object) {
            return new CommonsArrayList(this.m_aCalendarsByName.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommonsSet<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> groupMatcher) {
        CommonsHashSet commonsHashSet = null;
        Object object = this.m_aLock;
        synchronized (object) {
            StringMatcher.EStringOperatorName eStringOperatorName = groupMatcher.getCompareWithOperator();
            String string = groupMatcher.getCompareToValue();
            if (eStringOperatorName == StringMatcher.EStringOperatorName.EQUALS) {
                ICommonsMap iCommonsMap = (ICommonsMap)this.m_aTriggersByGroup.get(string);
                if (iCommonsMap != null) {
                    commonsHashSet = new CommonsHashSet();
                    for (TriggerWrapper triggerWrapper : iCommonsMap.values()) {
                        if (triggerWrapper == null) continue;
                        commonsHashSet.add(triggerWrapper.m_aTrigger.getKey());
                    }
                }
            } else {
                for (Map.Entry entry : this.m_aTriggersByGroup.entrySet()) {
                    if (!eStringOperatorName.evaluate((String)entry.getKey(), string) || entry.getValue() == null) continue;
                    if (commonsHashSet == null) {
                        commonsHashSet = new CommonsHashSet();
                    }
                    for (TriggerWrapper triggerWrapper : ((ICommonsMap)entry.getValue()).values()) {
                        if (triggerWrapper == null) continue;
                        commonsHashSet.add(triggerWrapper.m_aTrigger.getKey());
                    }
                }
            }
        }
        return commonsHashSet == null ? new CommonsHashSet() : commonsHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommonsList<String> getJobGroupNames() {
        Object object = this.m_aLock;
        synchronized (object) {
            return new CommonsArrayList(this.m_aJobsByGroup.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommonsList<String> getTriggerGroupNames() {
        Object object = this.m_aLock;
        synchronized (object) {
            return new CommonsArrayList(this.m_aTriggersByGroup.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommonsList<IOperableTrigger> getTriggersForJob(JobKey jobKey) {
        CommonsArrayList<IOperableTrigger> commonsArrayList = new CommonsArrayList<IOperableTrigger>();
        Object object = this.m_aLock;
        synchronized (object) {
            for (TriggerWrapper triggerWrapper : this.m_aTriggers) {
                if (!triggerWrapper.m_aJobKey.equals(jobKey)) continue;
                commonsArrayList.add(triggerWrapper.m_aTrigger.getClone());
            }
        }
        return commonsArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICommonsList<TriggerWrapper> getTriggerWrappersForJob(JobKey jobKey) {
        CommonsArrayList<TriggerWrapper> commonsArrayList = new CommonsArrayList<TriggerWrapper>();
        Object object = this.m_aLock;
        synchronized (object) {
            for (TriggerWrapper triggerWrapper : this.m_aTriggers) {
                if (!triggerWrapper.m_aJobKey.equals(jobKey)) continue;
                commonsArrayList.add(triggerWrapper);
            }
        }
        return commonsArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICommonsList<TriggerWrapper> getTriggerWrappersForCalendar(String string) {
        CommonsArrayList<TriggerWrapper> commonsArrayList = new CommonsArrayList<TriggerWrapper>();
        Object object = this.m_aLock;
        synchronized (object) {
            for (TriggerWrapper triggerWrapper : this.m_aTriggers) {
                String string2 = triggerWrapper.getTrigger().getCalendarName();
                if (string2 == null || !string2.equals(string)) continue;
                commonsArrayList.add(triggerWrapper);
            }
        }
        return commonsArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseTrigger(TriggerKey triggerKey) {
        Object object = this.m_aLock;
        synchronized (object) {
            TriggerWrapper triggerWrapper = (TriggerWrapper)this.m_aTriggersByKey.get(triggerKey);
            if (triggerWrapper == null || triggerWrapper.m_aTrigger == null) {
                return;
            }
            if (triggerWrapper.m_nState == 3) {
                return;
            }
            triggerWrapper.m_nState = triggerWrapper.m_nState == 5 ? 6 : 4;
            this.m_aTimeTriggers.remove(triggerWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommonsList<String> pauseTriggers(GroupMatcher<TriggerKey> groupMatcher) {
        CommonsArrayList<String> commonsArrayList;
        Object object = this.m_aLock;
        synchronized (object) {
            commonsArrayList = new CommonsArrayList<String>();
            StringMatcher.EStringOperatorName eStringOperatorName = groupMatcher.getCompareWithOperator();
            if (eStringOperatorName == StringMatcher.EStringOperatorName.EQUALS) {
                if (this.m_aPausedTriggerGroups.add(groupMatcher.getCompareToValue())) {
                    commonsArrayList.add(groupMatcher.getCompareToValue());
                }
            } else {
                for (String string : this.m_aTriggersByGroup.keySet()) {
                    if (!eStringOperatorName.evaluate(string, groupMatcher.getCompareToValue()) || !this.m_aPausedTriggerGroups.add(groupMatcher.getCompareToValue())) continue;
                    commonsArrayList.add(string);
                }
            }
            for (String string : commonsArrayList) {
                ICommonsSet<TriggerKey> iCommonsSet = this.getTriggerKeys(GroupMatcher.triggerGroupEquals(string));
                for (TriggerKey triggerKey : iCommonsSet) {
                    this.pauseTrigger(triggerKey);
                }
            }
        }
        return commonsArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseJob(JobKey jobKey) {
        Object object = this.m_aLock;
        synchronized (object) {
            ICommonsList<IOperableTrigger> iCommonsList = this.getTriggersForJob(jobKey);
            for (IOperableTrigger iOperableTrigger : iCommonsList) {
                this.pauseTrigger(iOperableTrigger.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommonsList<String> pauseJobs(GroupMatcher<JobKey> groupMatcher) {
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        Object object = this.m_aLock;
        synchronized (object) {
            StringMatcher.EStringOperatorName eStringOperatorName = groupMatcher.getCompareWithOperator();
            switch (eStringOperatorName) {
                case EQUALS: {
                    if (!this.m_aPausedJobGroups.add(groupMatcher.getCompareToValue())) break;
                    commonsArrayList.add(groupMatcher.getCompareToValue());
                    break;
                }
                default: {
                    for (String string : this.m_aJobsByGroup.keySet()) {
                        if (!eStringOperatorName.evaluate(string, groupMatcher.getCompareToValue()) || !this.m_aPausedJobGroups.add(string)) continue;
                        commonsArrayList.add(string);
                    }
                }
            }
            for (String string : commonsArrayList) {
                for (JobKey jobKey : this.getJobKeys(GroupMatcher.jobGroupEquals(string))) {
                    ICommonsList<IOperableTrigger> iCommonsList = this.getTriggersForJob(jobKey);
                    for (IOperableTrigger iOperableTrigger : iCommonsList) {
                        this.pauseTrigger(iOperableTrigger.getKey());
                    }
                }
            }
        }
        return commonsArrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeTrigger(TriggerKey triggerKey) {
        Object object = this.m_aLock;
        synchronized (object) {
            TriggerWrapper triggerWrapper = (TriggerWrapper)this.m_aTriggersByKey.get(triggerKey);
            if (triggerWrapper == null || triggerWrapper.m_aTrigger == null) {
                return;
            }
            IOperableTrigger iOperableTrigger = triggerWrapper.getTrigger();
            if (triggerWrapper.m_nState != 4 && triggerWrapper.m_nState != 6) {
                return;
            }
            triggerWrapper.m_nState = this.m_aBlockedJobs.contains(iOperableTrigger.getJobKey()) ? 5 : 0;
            this.applyMisfire(triggerWrapper);
            if (triggerWrapper.m_nState == 0) {
                this.m_aTimeTriggers.add(triggerWrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICommonsList<String> resumeTriggers(GroupMatcher<TriggerKey> groupMatcher) {
        CommonsHashSet commonsHashSet = new CommonsHashSet();
        Object object = this.m_aLock;
        synchronized (object) {
            ICommonsSet<TriggerKey> iCommonsSet = this.getTriggerKeys(groupMatcher);
            for (TriggerKey object2 : iCommonsSet) {
                String string;
                commonsHashSet.add(object2.getGroup());
                if (this.m_aTriggersByKey.get(object2) != null && this.m_aPausedJobGroups.contains(string = ((TriggerWrapper)this.m_aTriggersByKey.get((Object)object2)).m_aJobKey.getGroup())) continue;
                this.resumeTrigger(object2);
            }
            for (String string : commonsHashSet) {
                this.m_aPausedTriggerGroups.remove(string);
            }
        }
        return new CommonsArrayList(commonsHashSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeJob(JobKey jobKey) {
        Object object = this.m_aLock;
        synchronized (object) {
            ICommonsList<IOperableTrigger> iCommonsList = this.getTriggersForJob(jobKey);
            for (IOperableTrigger iOperableTrigger : iCommonsList) {
                this.resumeTrigger(iOperableTrigger.getKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommonsCollection<String> resumeJobs(GroupMatcher<JobKey> groupMatcher) {
        CommonsHashSet<String> commonsHashSet = new CommonsHashSet<String>();
        Object object = this.m_aLock;
        synchronized (object) {
            ICommonsSet<JobKey> iCommonsSet = this.getJobKeys(groupMatcher);
            for (String object2 : this.m_aPausedJobGroups) {
                if (!groupMatcher.getCompareWithOperator().evaluate(object2, groupMatcher.getCompareToValue())) continue;
                commonsHashSet.add(object2);
            }
            for (String string : commonsHashSet) {
                this.m_aPausedJobGroups.remove(string);
            }
            for (JobKey jobKey : iCommonsSet) {
                ICommonsList<IOperableTrigger> iCommonsList = this.getTriggersForJob(jobKey);
                for (IOperableTrigger iOperableTrigger : iCommonsList) {
                    this.resumeTrigger(iOperableTrigger.getKey());
                }
            }
        }
        return commonsHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pauseAll() {
        Object object = this.m_aLock;
        synchronized (object) {
            ICommonsList<String> iCommonsList = this.getTriggerGroupNames();
            for (String string : iCommonsList) {
                this.pauseTriggers((GroupMatcher)GroupMatcher.triggerGroupEquals(string));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resumeAll() {
        Object object = this.m_aLock;
        synchronized (object) {
            this.m_aPausedJobGroups.clear();
            this.resumeTriggers((GroupMatcher)GroupMatcher.anyTriggerGroup());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean applyMisfire(TriggerWrapper triggerWrapper) {
        Date date;
        long l = System.currentTimeMillis();
        if (this.getMisfireThreshold() > 0L) {
            l -= this.getMisfireThreshold();
        }
        if ((date = triggerWrapper.m_aTrigger.getNextFireTime()) == null || date.getTime() > l || triggerWrapper.m_aTrigger.getMisfireInstruction() == ITrigger.EMisfireInstruction.MISFIRE_INSTRUCTION_IGNORE_MISFIRE_POLICY) {
            return false;
        }
        ICalendar iCalendar = null;
        if (triggerWrapper.m_aTrigger.getCalendarName() != null) {
            iCalendar = this.retrieveCalendar(triggerWrapper.m_aTrigger.getCalendarName());
        }
        this.m_aSignaler.notifyTriggerListenersMisfired(triggerWrapper.m_aTrigger.getClone());
        triggerWrapper.m_aTrigger.updateAfterMisfire(iCalendar);
        if (triggerWrapper.m_aTrigger.getNextFireTime() == null) {
            triggerWrapper.m_nState = 3;
            this.m_aSignaler.notifySchedulerListenersFinalized(triggerWrapper.m_aTrigger);
            Object object = this.m_aLock;
            synchronized (object) {
                this.m_aTimeTriggers.remove(triggerWrapper);
            }
        } else if (date.equals(triggerWrapper.m_aTrigger.getNextFireTime())) {
            return false;
        }
        return true;
    }

    @Nonnull
    @Nonempty
    protected String getFiredTriggerRecordId() {
        return Long.toString(FIRED_TRIGGER_RECORD_COUNTER.incrementAndGet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommonsList<IOperableTrigger> acquireNextTriggers(long l, int n, long l2) {
        Object object = this.m_aLock;
        synchronized (object) {
            CommonsArrayList<IOperableTrigger> commonsArrayList = new CommonsArrayList<IOperableTrigger>();
            CommonsHashSet commonsHashSet = new CommonsHashSet();
            CommonsHashSet commonsHashSet2 = new CommonsHashSet();
            long l3 = l;
            if (this.m_aTimeTriggers.isEmpty()) {
                return commonsArrayList;
            }
            while (true) {
                TriggerWrapper triggerWrapper;
                try {
                    triggerWrapper = (TriggerWrapper)this.m_aTimeTriggers.first();
                    if (triggerWrapper == null) break;
                    this.m_aTimeTriggers.remove(triggerWrapper);
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
                if (triggerWrapper.m_aTrigger.getNextFireTime() == null) continue;
                if (this.applyMisfire(triggerWrapper)) {
                    if (triggerWrapper.m_aTrigger.getNextFireTime() == null) continue;
                    this.m_aTimeTriggers.add(triggerWrapper);
                    continue;
                }
                if (triggerWrapper.getTrigger().getNextFireTime().getTime() > l3) {
                    this.m_aTimeTriggers.add(triggerWrapper);
                    break;
                }
                JobKey jobKey = triggerWrapper.m_aTrigger.getJobKey();
                IJobDetail iJobDetail = ((JobWrapper)this.m_aJobsByKey.get(triggerWrapper.m_aTrigger.getJobKey())).getJobDetail();
                if (iJobDetail.isConcurrentExectionDisallowed() && !commonsHashSet.add(jobKey)) {
                    commonsHashSet2.add(triggerWrapper);
                    continue;
                }
                triggerWrapper.m_nState = 1;
                triggerWrapper.m_aTrigger.setFireInstanceId(this.getFiredTriggerRecordId());
                IOperableTrigger iOperableTrigger = triggerWrapper.m_aTrigger.getClone();
                if (commonsArrayList.isEmpty()) {
                    l3 = Math.max(triggerWrapper.m_aTrigger.getNextFireTime().getTime(), System.currentTimeMillis()) + l2;
                }
                commonsArrayList.add(iOperableTrigger);
                if (commonsArrayList.size() == n) break;
            }
            if (!commonsHashSet2.isEmpty()) {
                this.m_aTimeTriggers.addAll(commonsHashSet2);
            }
            return commonsArrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseAcquiredTrigger(IOperableTrigger iOperableTrigger) {
        Object object = this.m_aLock;
        synchronized (object) {
            TriggerWrapper triggerWrapper = (TriggerWrapper)this.m_aTriggersByKey.get(iOperableTrigger.getKey());
            if (triggerWrapper != null && triggerWrapper.m_nState == 1) {
                triggerWrapper.m_nState = 0;
                this.m_aTimeTriggers.add(triggerWrapper);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ICommonsList<TriggerFiredResult> triggersFired(List<IOperableTrigger> list) {
        Object object = this.m_aLock;
        synchronized (object) {
            CommonsArrayList<TriggerFiredResult> commonsArrayList = new CommonsArrayList<TriggerFiredResult>();
            for (IOperableTrigger iOperableTrigger : list) {
                Object object2;
                TriggerWrapper triggerWrapper = (TriggerWrapper)this.m_aTriggersByKey.get(iOperableTrigger.getKey());
                if (triggerWrapper == null || triggerWrapper.m_aTrigger == null || triggerWrapper.m_nState != 1) continue;
                ICalendar iCalendar = null;
                if (triggerWrapper.m_aTrigger.getCalendarName() != null && (iCalendar = this.retrieveCalendar(triggerWrapper.m_aTrigger.getCalendarName())) == null) continue;
                Date date = iOperableTrigger.getPreviousFireTime();
                this.m_aTimeTriggers.remove(triggerWrapper);
                triggerWrapper.m_aTrigger.triggered(iCalendar);
                iOperableTrigger.triggered(iCalendar);
                triggerWrapper.m_nState = 0;
                TriggerFiredBundle triggerFiredBundle = new TriggerFiredBundle(this.retrieveJob(triggerWrapper.m_aJobKey), iOperableTrigger, iCalendar, false, new Date(), iOperableTrigger.getPreviousFireTime(), date, iOperableTrigger.getNextFireTime());
                IJobDetail iJobDetail = triggerFiredBundle.getJobDetail();
                if (iJobDetail.isConcurrentExectionDisallowed()) {
                    object2 = this.getTriggerWrappersForJob(iJobDetail.getKey());
                    Iterator iterator = object2.iterator();
                    while (iterator.hasNext()) {
                        TriggerWrapper triggerWrapper2 = (TriggerWrapper)iterator.next();
                        if (triggerWrapper2.m_nState == 0) {
                            triggerWrapper2.m_nState = 5;
                        }
                        if (triggerWrapper2.m_nState == 4) {
                            triggerWrapper2.m_nState = 6;
                        }
                        this.m_aTimeTriggers.remove(triggerWrapper2);
                    }
                    this.m_aBlockedJobs.add(iJobDetail.getKey());
                } else if (triggerWrapper.m_aTrigger.getNextFireTime() != null) {
                    object2 = this.m_aLock;
                    synchronized (object2) {
                        this.m_aTimeTriggers.add(triggerWrapper);
                    }
                }
                commonsArrayList.add(new TriggerFiredResult(triggerFiredBundle));
            }
            return commonsArrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void triggeredJobComplete(IOperableTrigger iOperableTrigger, IJobDetail iJobDetail, ITrigger.ECompletedExecutionInstruction eCompletedExecutionInstruction) {
        Object object = this.m_aLock;
        synchronized (object) {
            JobWrapper jobWrapper = (JobWrapper)this.m_aJobsByKey.get(iJobDetail.getKey());
            TriggerWrapper triggerWrapper = (TriggerWrapper)this.m_aTriggersByKey.get(iOperableTrigger.getKey());
            if (jobWrapper != null) {
                Serializable serializable;
                IJobDetail iJobDetail2 = jobWrapper.getJobDetail();
                if (iJobDetail2.isPersistJobDataAfterExecution()) {
                    serializable = QCloneUtils.getClone(iJobDetail.getJobDataMap());
                    iJobDetail2 = iJobDetail2.getJobBuilder().setJobData((JobDataMap)serializable).build();
                    jobWrapper.setJobDetail(iJobDetail2);
                }
                if (iJobDetail2.isConcurrentExectionDisallowed()) {
                    this.m_aBlockedJobs.remove(iJobDetail2.getKey());
                    serializable = this.getTriggerWrappersForJob(iJobDetail2.getKey());
                    Iterator iterator = serializable.iterator();
                    while (iterator.hasNext()) {
                        TriggerWrapper triggerWrapper2 = (TriggerWrapper)iterator.next();
                        if (triggerWrapper2.m_nState == 5) {
                            triggerWrapper2.m_nState = 0;
                            this.m_aTimeTriggers.add(triggerWrapper2);
                        }
                        if (triggerWrapper2.m_nState != 6) continue;
                        triggerWrapper2.m_nState = 4;
                    }
                    this.m_aSignaler.signalSchedulingChange(0L);
                }
            } else {
                this.m_aBlockedJobs.remove(iJobDetail.getKey());
            }
            if (triggerWrapper != null) {
                if (eCompletedExecutionInstruction == ITrigger.ECompletedExecutionInstruction.DELETE_TRIGGER) {
                    if (iOperableTrigger.getNextFireTime() == null) {
                        if (triggerWrapper.getTrigger().getNextFireTime() == null) {
                            this.removeTrigger(iOperableTrigger.getKey());
                        }
                    } else {
                        this.removeTrigger(iOperableTrigger.getKey());
                        this.m_aSignaler.signalSchedulingChange(0L);
                    }
                } else if (eCompletedExecutionInstruction == ITrigger.ECompletedExecutionInstruction.SET_TRIGGER_COMPLETE) {
                    triggerWrapper.m_nState = 3;
                    this.m_aTimeTriggers.remove(triggerWrapper);
                    this.m_aSignaler.signalSchedulingChange(0L);
                } else if (eCompletedExecutionInstruction == ITrigger.ECompletedExecutionInstruction.SET_TRIGGER_ERROR) {
                    LOGGER.info("Trigger " + iOperableTrigger.getKey() + " set to ERROR state.");
                    triggerWrapper.m_nState = 7;
                    this.m_aSignaler.signalSchedulingChange(0L);
                } else if (eCompletedExecutionInstruction == ITrigger.ECompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_ERROR) {
                    LOGGER.info("All triggers of Job " + iOperableTrigger.getJobKey() + " set to ERROR state.");
                    this.setAllTriggersOfJobToState(iOperableTrigger.getJobKey(), 7);
                    this.m_aSignaler.signalSchedulingChange(0L);
                } else if (eCompletedExecutionInstruction == ITrigger.ECompletedExecutionInstruction.SET_ALL_JOB_TRIGGERS_COMPLETE) {
                    this.setAllTriggersOfJobToState(iOperableTrigger.getJobKey(), 3);
                    this.m_aSignaler.signalSchedulingChange(0L);
                }
            }
        }
    }

    protected void setAllTriggersOfJobToState(JobKey jobKey, int n) {
        ICommonsList<TriggerWrapper> iCommonsList = this.getTriggerWrappersForJob(jobKey);
        for (TriggerWrapper triggerWrapper : iCommonsList) {
            triggerWrapper.m_nState = n;
            if (n == 0) continue;
            this.m_aTimeTriggers.remove(triggerWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String peekTriggers() {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = this.m_aLock;
        synchronized (object) {
            for (TriggerWrapper triggerWrapper : this.m_aTriggersByKey.values()) {
                stringBuilder.append(triggerWrapper.m_aTrigger.getKey().getName());
                stringBuilder.append("/");
            }
            stringBuilder.append(" | ");
            for (TriggerWrapper triggerWrapper : this.m_aTimeTriggers) {
                stringBuilder.append(triggerWrapper.m_aTrigger.getKey().getName());
                stringBuilder.append("->");
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public ICommonsSet<String> getPausedTriggerGroups() throws JobPersistenceException {
        CommonsHashSet<String> commonsHashSet = new CommonsHashSet<String>();
        commonsHashSet.addAll(this.m_aPausedTriggerGroups);
        return commonsHashSet;
    }

    @Override
    public void setInstanceId(String string) {
    }

    @Override
    public void setInstanceName(String string) {
    }

    @Override
    public void setThreadPoolSize(int n) {
    }

    @Override
    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return 5L;
    }

    @Override
    public boolean isClustered() {
        return false;
    }
}

