/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.simpl;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.quartz.SchedulerConfigException;
import com.helger.quartz.spi.IThreadPool;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleThreadPool
implements IThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleThreadPool.class);
    private int m_nCount = -1;
    private int m_nPrio = 5;
    private boolean m_bIsShutdown = false;
    private boolean m_bHandoffPending = false;
    private boolean m_bInheritLoader = false;
    private boolean m_bInheritGroup = true;
    private boolean m_bMakeThreadsDaemons = false;
    private ThreadGroup m_aThreadGroup;
    private final Object m_aNextRunnableLock = new Object();
    private ICommonsList<WorkerThread> m_aWorkers;
    private final ICommonsList<WorkerThread> m_aAvailWorkers = new CommonsArrayList<WorkerThread>();
    private final ICommonsList<WorkerThread> m_aBusyWorkers = new CommonsArrayList<WorkerThread>();
    private String m_sThreadNamePrefix;
    private String m_sSchedulerInstanceName;

    public SimpleThreadPool() {
    }

    public SimpleThreadPool(int n, int n2) {
        this.setThreadCount(n);
        this.setThreadPriority(n2);
    }

    @Override
    public int getPoolSize() {
        return this.getThreadCount();
    }

    public final void setThreadCount(int n) {
        this.m_nCount = n;
    }

    public final int getThreadCount() {
        return this.m_nCount;
    }

    public final void setThreadPriority(int n) {
        this.m_nPrio = n;
    }

    public final int getThreadPriority() {
        return this.m_nPrio;
    }

    public final void setThreadNamePrefix(@Nullable String string) {
        this.m_sThreadNamePrefix = string;
    }

    @Nullable
    public final String getThreadNamePrefix() {
        return this.m_sThreadNamePrefix;
    }

    public final boolean isThreadsInheritContextClassLoaderOfInitializingThread() {
        return this.m_bInheritLoader;
    }

    public final void setThreadsInheritContextClassLoaderOfInitializingThread(boolean bl) {
        this.m_bInheritLoader = bl;
    }

    public final boolean isThreadsInheritGroupOfInitializingThread() {
        return this.m_bInheritGroup;
    }

    public final void setThreadsInheritGroupOfInitializingThread(boolean bl) {
        this.m_bInheritGroup = bl;
    }

    public final boolean isMakeThreadsDaemons() {
        return this.m_bMakeThreadsDaemons;
    }

    public final void setMakeThreadsDaemons(boolean bl) {
        this.m_bMakeThreadsDaemons = bl;
    }

    @Override
    public void setInstanceId(String string) {
    }

    @Override
    public void setInstanceName(String string) {
        this.m_sSchedulerInstanceName = string;
    }

    @Override
    public void initialize() throws SchedulerConfigException {
        if (this.m_aWorkers != null && this.m_aWorkers.isNotEmpty()) {
            return;
        }
        if (this.m_nCount <= 0) {
            throw new SchedulerConfigException("Thread count must be > 0");
        }
        if (this.m_nPrio < 1 || this.m_nPrio > 10) {
            throw new SchedulerConfigException("Thread priority must be <= 1 and <= 10");
        }
        if (this.isThreadsInheritGroupOfInitializingThread()) {
            this.m_aThreadGroup = Thread.currentThread().getThreadGroup();
        } else {
            this.m_aThreadGroup = Thread.currentThread().getThreadGroup();
            Object object = this.m_aThreadGroup;
            while (!((ThreadGroup)object).getName().equals("main")) {
                this.m_aThreadGroup = object;
                object = this.m_aThreadGroup.getParent();
                if (object != null) continue;
                throw new IllegalStateException("Failed to resolve thread group with name 'main'");
            }
            this.m_aThreadGroup = new ThreadGroup((ThreadGroup)object, this.m_sSchedulerInstanceName + "-SimpleThreadPool");
            if (this.isMakeThreadsDaemons()) {
                this.m_aThreadGroup.setDaemon(true);
            }
        }
        if (this.isThreadsInheritContextClassLoaderOfInitializingThread()) {
            LOGGER.info("Job execution threads will use class loader of thread: " + Thread.currentThread().getName());
        }
        for (WorkerThread workerThread : this.createWorkerThreads(this.m_nCount)) {
            workerThread.start();
            this.m_aAvailWorkers.add(workerThread);
        }
        LOGGER.info("Initialized " + this.m_nCount + " worker threads");
    }

    protected List<WorkerThread> createWorkerThreads(int n) {
        this.m_aWorkers = new CommonsArrayList<WorkerThread>();
        for (int i = 1; i <= n; ++i) {
            String string = this.getThreadNamePrefix();
            if (string == null) {
                string = this.m_sSchedulerInstanceName + "_Worker";
            }
            WorkerThread workerThread = new WorkerThread(this, this.m_aThreadGroup, string + "-" + i, this.getThreadPriority(), this.isMakeThreadsDaemons());
            if (this.isThreadsInheritContextClassLoaderOfInitializingThread()) {
                workerThread.setContextClassLoader(Thread.currentThread().getContextClassLoader());
            }
            this.m_aWorkers.add(workerThread);
        }
        return this.m_aWorkers;
    }

    public void shutdown() {
        this.shutdown(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown(boolean bl) {
        Object object = this.m_aNextRunnableLock;
        synchronized (object) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Shutting down threadpool...");
            }
            this.m_bIsShutdown = true;
            if (this.m_aWorkers == null) {
                return;
            }
            for (WorkerThread workerThread : this.m_aWorkers) {
                workerThread.shutdown();
                this.m_aAvailWorkers.remove(workerThread);
            }
            this.m_aNextRunnableLock.notifyAll();
            if (bl) {
                boolean bl2 = false;
                try {
                    WorkerThread workerThread;
                    while (this.m_bHandoffPending) {
                        try {
                            this.m_aNextRunnableLock.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            bl2 = true;
                        }
                    }
                    while (this.m_aBusyWorkers.isNotEmpty()) {
                        workerThread = (WorkerThread)this.m_aBusyWorkers.get(0);
                        try {
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("Waiting for thread " + workerThread.getName() + " to shut down");
                            }
                            this.m_aNextRunnableLock.wait(2000L);
                        }
                        catch (InterruptedException interruptedException) {
                            bl2 = true;
                        }
                    }
                    Iterator iterator = this.m_aWorkers.iterator();
                    while (iterator.hasNext()) {
                        workerThread = (WorkerThread)iterator.next();
                        try {
                            workerThread.join();
                            iterator.remove();
                        }
                        catch (InterruptedException interruptedException) {
                            bl2 = true;
                        }
                    }
                }
                finally {
                    if (bl2) {
                        Thread.currentThread().interrupt();
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("No executing jobs remaining, all threads stopped.");
                }
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Shutdown of threadpool complete.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean runInThread(Runnable runnable) {
        if (runnable == null) {
            return false;
        }
        Object object = this.m_aNextRunnableLock;
        synchronized (object) {
            this.m_bHandoffPending = true;
            while (this.m_aAvailWorkers.isEmpty() && !this.m_bIsShutdown) {
                try {
                    this.m_aNextRunnableLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            if (!this.m_bIsShutdown) {
                WorkerThread workerThread = (WorkerThread)this.m_aAvailWorkers.remove(0);
                this.m_aBusyWorkers.add(workerThread);
                workerThread.run(runnable);
            } else {
                WorkerThread workerThread = new WorkerThread(this, this.m_aThreadGroup, "WorkerThread-LastJob", this.m_nPrio, this.isMakeThreadsDaemons(), runnable);
                this.m_aBusyWorkers.add(workerThread);
                this.m_aWorkers.add(workerThread);
                workerThread.start();
            }
            this.m_aNextRunnableLock.notifyAll();
            this.m_bHandoffPending = false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int blockForAvailableThreads() {
        Object object = this.m_aNextRunnableLock;
        synchronized (object) {
            while ((this.m_aAvailWorkers.isEmpty() || this.m_bHandoffPending) && !this.m_bIsShutdown) {
                try {
                    this.m_aNextRunnableLock.wait(500L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            return this.m_aAvailWorkers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makeAvailable(WorkerThread workerThread) {
        Object object = this.m_aNextRunnableLock;
        synchronized (object) {
            if (!this.m_bIsShutdown) {
                this.m_aAvailWorkers.add(workerThread);
            }
            this.m_aBusyWorkers.remove(workerThread);
            this.m_aNextRunnableLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearFromBusyWorkersList(WorkerThread workerThread) {
        Object object = this.m_aNextRunnableLock;
        synchronized (object) {
            this.m_aBusyWorkers.remove(workerThread);
            this.m_aNextRunnableLock.notifyAll();
        }
    }

    final class WorkerThread
    extends Thread {
        private final Object m_aLock;
        private final AtomicBoolean m_aCanRun;
        private final SimpleThreadPool m_aSTP;
        private Runnable m_aRunnable;
        private boolean m_bRunOnce;

        WorkerThread(SimpleThreadPool simpleThreadPool2, ThreadGroup threadGroup, String string, int n, boolean bl) {
            this(simpleThreadPool2, threadGroup, string, n, bl, null);
        }

        WorkerThread(SimpleThreadPool simpleThreadPool2, ThreadGroup threadGroup, String string, int n, boolean bl, Runnable runnable) {
            super(threadGroup, string);
            this.m_aLock = new Object();
            this.m_aCanRun = new AtomicBoolean(true);
            this.m_bRunOnce = false;
            this.m_aSTP = simpleThreadPool2;
            this.m_aRunnable = runnable;
            if (runnable != null) {
                this.m_bRunOnce = true;
            }
            this.setPriority(n);
            this.setDaemon(bl);
        }

        void shutdown() {
            this.m_aCanRun.set(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(Runnable runnable) {
            Object object = this.m_aLock;
            synchronized (object) {
                if (this.m_aRunnable != null) {
                    throw new IllegalStateException("Already running a Runnable!");
                }
                this.m_aRunnable = runnable;
                this.m_aLock.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            while (this.m_aCanRun.get()) {
                Object object;
                try {
                    object = this.m_aLock;
                    synchronized (object) {
                        while (this.m_aRunnable == null && this.m_aCanRun.get()) {
                            this.m_aLock.wait(500L);
                        }
                        if (this.m_aRunnable != null) {
                            bl = true;
                            this.m_aRunnable.run();
                        }
                    }
                }
                catch (InterruptedException interruptedException) {
                    try {
                        LOGGER.error("Worker thread was interrupt'ed.", interruptedException);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Thread.currentThread().interrupt();
                }
                catch (Exception exception) {
                    try {
                        LOGGER.error("Error while executing the Runnable: ", exception);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                }
                finally {
                    object = this.m_aLock;
                    synchronized (object) {
                        this.m_aRunnable = null;
                    }
                    if (this.getPriority() != this.m_aSTP.getThreadPriority()) {
                        this.setPriority(this.m_aSTP.getThreadPriority());
                    }
                    if (this.m_bRunOnce) {
                        this.m_aCanRun.set(false);
                        SimpleThreadPool.this.clearFromBusyWorkersList(this);
                        continue;
                    }
                    if (!bl) continue;
                    bl = false;
                    SimpleThreadPool.this.makeAvailable(this);
                }
            }
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("WorkerThread is shut down.");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

