/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.spi;

import com.helger.commons.collection.impl.ICommonsCollection;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.quartz.ICalendar;
import com.helger.quartz.IJobDetail;
import com.helger.quartz.ITrigger;
import com.helger.quartz.JobKey;
import com.helger.quartz.JobPersistenceException;
import com.helger.quartz.SchedulerConfigException;
import com.helger.quartz.SchedulerException;
import com.helger.quartz.TriggerKey;
import com.helger.quartz.impl.matchers.GroupMatcher;
import com.helger.quartz.spi.IClassLoadHelper;
import com.helger.quartz.spi.IOperableTrigger;
import com.helger.quartz.spi.ISchedulerSignaler;
import com.helger.quartz.spi.TriggerFiredResult;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface IJobStore
extends Serializable {
    public void initialize(IClassLoadHelper var1, ISchedulerSignaler var2) throws SchedulerConfigException;

    public void schedulerStarted() throws SchedulerException;

    public void schedulerPaused();

    public void schedulerResumed();

    public void shutdown();

    public boolean supportsPersistence();

    public long getEstimatedTimeToReleaseAndAcquireTrigger();

    public boolean isClustered();

    public void storeJobAndTrigger(IJobDetail var1, IOperableTrigger var2) throws JobPersistenceException;

    public void storeJob(IJobDetail var1, boolean var2) throws JobPersistenceException;

    public void storeJobsAndTriggers(Map<IJobDetail, Set<? extends ITrigger>> var1, boolean var2) throws JobPersistenceException;

    public boolean removeJob(JobKey var1) throws JobPersistenceException;

    public boolean removeJobs(List<JobKey> var1) throws JobPersistenceException;

    public IJobDetail retrieveJob(JobKey var1) throws JobPersistenceException;

    public void storeTrigger(IOperableTrigger var1, boolean var2) throws JobPersistenceException;

    public boolean removeTrigger(TriggerKey var1) throws JobPersistenceException;

    public boolean removeTriggers(List<TriggerKey> var1) throws JobPersistenceException;

    public boolean replaceTrigger(TriggerKey var1, IOperableTrigger var2) throws JobPersistenceException;

    public IOperableTrigger retrieveTrigger(TriggerKey var1) throws JobPersistenceException;

    public boolean checkExists(JobKey var1) throws JobPersistenceException;

    public boolean checkExists(TriggerKey var1) throws JobPersistenceException;

    public void clearAllSchedulingData() throws JobPersistenceException;

    public void storeCalendar(String var1, ICalendar var2, boolean var3, boolean var4) throws JobPersistenceException;

    public boolean removeCalendar(String var1) throws JobPersistenceException;

    public ICalendar retrieveCalendar(String var1) throws JobPersistenceException;

    public int getNumberOfJobs() throws JobPersistenceException;

    public int getNumberOfTriggers() throws JobPersistenceException;

    public int getNumberOfCalendars() throws JobPersistenceException;

    public ICommonsSet<JobKey> getJobKeys(GroupMatcher<JobKey> var1) throws JobPersistenceException;

    public ICommonsSet<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> var1) throws JobPersistenceException;

    public ICommonsList<String> getJobGroupNames() throws JobPersistenceException;

    public ICommonsList<String> getTriggerGroupNames() throws JobPersistenceException;

    public ICommonsList<String> getCalendarNames() throws JobPersistenceException;

    public ICommonsList<IOperableTrigger> getTriggersForJob(JobKey var1) throws JobPersistenceException;

    public ITrigger.ETriggerState getTriggerState(TriggerKey var1) throws JobPersistenceException;

    public void pauseTrigger(TriggerKey var1) throws JobPersistenceException;

    public ICommonsCollection<String> pauseTriggers(GroupMatcher<TriggerKey> var1) throws JobPersistenceException;

    public void pauseJob(JobKey var1) throws JobPersistenceException;

    public ICommonsCollection<String> pauseJobs(GroupMatcher<JobKey> var1) throws JobPersistenceException;

    public void resumeTrigger(TriggerKey var1) throws JobPersistenceException;

    public ICommonsCollection<String> resumeTriggers(GroupMatcher<TriggerKey> var1) throws JobPersistenceException;

    public ICommonsSet<String> getPausedTriggerGroups() throws JobPersistenceException;

    public void resumeJob(JobKey var1) throws JobPersistenceException;

    public ICommonsCollection<String> resumeJobs(GroupMatcher<JobKey> var1) throws JobPersistenceException;

    public void pauseAll() throws JobPersistenceException;

    public void resumeAll() throws JobPersistenceException;

    public ICommonsList<IOperableTrigger> acquireNextTriggers(long var1, int var3, long var4) throws JobPersistenceException;

    public void releaseAcquiredTrigger(IOperableTrigger var1);

    public ICommonsList<TriggerFiredResult> triggersFired(List<IOperableTrigger> var1) throws JobPersistenceException;

    public void triggeredJobComplete(IOperableTrigger var1, IJobDetail var2, ITrigger.ECompletedExecutionInstruction var3);

    public void setInstanceId(String var1);

    public void setInstanceName(String var1);

    public void setThreadPoolSize(int var1);
}

