/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.utils;

import com.helger.commons.collection.impl.CommonsArrayList;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ClassUtils {
    private ClassUtils() {
    }

    public static boolean isAnnotationPresent(Class<?> clazz, Class<? extends Annotation> clazz2) {
        for (Class<?> clazz3 = clazz; clazz3 != null; clazz3 = clazz3.getSuperclass()) {
            if (clazz3.isAnnotationPresent(clazz2)) {
                return true;
            }
            if (!ClassUtils._isAnnotationPresentOnInterfacesRecursive(clazz3, clazz2)) continue;
            return true;
        }
        return false;
    }

    private static boolean _isAnnotationPresentOnInterfacesRecursive(Class<?> clazz, Class<? extends Annotation> clazz2) {
        for (Class<?> clazz3 : clazz.getInterfaces()) {
            if (clazz3.isAnnotationPresent(clazz2)) {
                return true;
            }
            if (!ClassUtils._isAnnotationPresentOnInterfacesRecursive(clazz3, clazz2)) continue;
            return true;
        }
        return false;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> clazz2) {
        Object object;
        Serializable serializable;
        for (serializable = clazz; serializable != null; serializable = ((Class)serializable).getSuperclass()) {
            object = ((Class)serializable).getAnnotation(clazz2);
            if (object == null) continue;
            return object;
        }
        serializable = new CommonsArrayList();
        serializable.add(clazz);
        while (!serializable.isEmpty()) {
            object = (Class)serializable.removeFirst();
            if (object == null) continue;
            if (((Class)object).isInterface()) {
                T t = ((Class)object).getAnnotation(clazz2);
                if (t != null) {
                    return t;
                }
            } else {
                serializable.add(((Class)object).getSuperclass());
            }
            serializable.addAll(((Class)object).getInterfaces());
        }
        return null;
    }
}

