/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.utils;

import com.helger.commons.collection.impl.CommonsArrayList;
import com.helger.commons.collection.impl.CommonsLinkedHashSet;
import com.helger.commons.collection.impl.ICommonsList;
import com.helger.commons.lang.NonBlockingProperties;
import com.helger.commons.string.StringHelper;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesParser.class);
    private final NonBlockingProperties m_aProps;

    public PropertiesParser(NonBlockingProperties nonBlockingProperties) {
        this.m_aProps = nonBlockingProperties;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("PropertiesParser ctor: " + nonBlockingProperties);
        }
    }

    public NonBlockingProperties getUnderlyingProperties() {
        return this.m_aProps;
    }

    public String getStringProperty(String string) {
        return this.getStringProperty(string, null);
    }

    public String getStringProperty(String string, String string2) {
        String string3 = this.m_aProps.getProperty(string);
        if (string3 != null && (string3 = string3.trim()).length() > 0) {
            return string3;
        }
        return StringHelper.trim(string2);
    }

    public String[] getStringArrayProperty(String string) {
        return this.getStringArrayProperty(string, null);
    }

    public String[] getStringArrayProperty(String string, String[] stringArray) {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            return stringArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        try {
            while (stringTokenizer.hasMoreTokens()) {
                commonsArrayList.add(stringTokenizer.nextToken().trim());
            }
            return commonsArrayList.toArray(new String[commonsArrayList.size()]);
        }
        catch (Exception exception) {
            return stringArray;
        }
    }

    public boolean getBooleanProperty(String string) {
        return this.getBooleanProperty(string, false);
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        String string2 = this.getStringProperty(string);
        return string2 == null ? bl : Boolean.parseBoolean(string2);
    }

    public byte getByteProperty(String string) {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Byte.parseByte(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public byte getByteProperty(String string, byte by) {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            return by;
        }
        try {
            return Byte.parseByte(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public char getCharProperty(String string) {
        return this.getCharProperty(string, '\u0000');
    }

    public char getCharProperty(String string, char c) {
        String string2 = this.getStringProperty(string);
        return string2 == null ? c : string2.charAt(0);
    }

    public double getDoubleProperty(String string) {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public double getDoubleProperty(String string, double d) {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            return d;
        }
        try {
            return Double.parseDouble(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public float getFloatProperty(String string) {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public float getFloatProperty(String string, float f) {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            return f;
        }
        try {
            return Float.parseFloat(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public int getIntProperty(String string) {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public int getIntProperty(String string, int n) {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public int[] getIntArrayProperty(String string) {
        return this.getIntArrayProperty(string, null);
    }

    public int[] getIntArrayProperty(String string, int[] nArray) {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            return nArray;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        CommonsArrayList commonsArrayList = new CommonsArrayList();
        try {
            while (stringTokenizer.hasMoreTokens()) {
                try {
                    commonsArrayList.add(Integer.valueOf(stringTokenizer.nextToken().trim()));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new NumberFormatException(" '" + string2 + "'");
                }
            }
            int[] nArray2 = new int[commonsArrayList.size()];
            for (int i = 0; i < commonsArrayList.size(); ++i) {
                nArray2[i] = (Integer)commonsArrayList.get(i);
            }
            return nArray2;
        }
        catch (Exception exception) {
            return nArray;
        }
    }

    public long getLongProperty(String string) {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public long getLongProperty(String string, long l) {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            return l;
        }
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public short getShortProperty(String string) {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            throw new NumberFormatException(" null string");
        }
        try {
            return Short.parseShort(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public short getShortProperty(String string, short s) {
        String string2 = this.getStringProperty(string);
        if (string2 == null) {
            return s;
        }
        try {
            return Short.parseShort(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new NumberFormatException(" '" + string2 + "'");
        }
    }

    public ICommonsList<String> getPropertyGroups(String string) {
        CommonsLinkedHashSet commonsLinkedHashSet = new CommonsLinkedHashSet(10);
        String string2 = string;
        if (!string2.endsWith(".")) {
            string2 = string2 + ".";
        }
        for (String string3 : this.m_aProps.keySet()) {
            if (!string3.startsWith(string2)) continue;
            String string4 = string3.substring(string2.length(), string3.indexOf(46, string2.length()));
            commonsLinkedHashSet.add(string4);
        }
        return commonsLinkedHashSet.getCopyAsList();
    }

    public NonBlockingProperties getPropertyGroup(String string) {
        return this.getPropertyGroup(string, false, null);
    }

    public NonBlockingProperties getPropertyGroup(String string, boolean bl) {
        return this.getPropertyGroup(string, bl, null);
    }

    public NonBlockingProperties getPropertyGroup(String string, boolean bl, String[] stringArray) {
        NonBlockingProperties nonBlockingProperties = new NonBlockingProperties();
        String string2 = string;
        if (!string2.endsWith(".")) {
            string2 = string2 + ".";
        }
        for (String string3 : this.m_aProps.keySet()) {
            if (!string3.startsWith(string2)) continue;
            boolean bl2 = false;
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length && !bl2; ++i) {
                    bl2 = string3.startsWith(stringArray[i]);
                }
            }
            if (bl2) continue;
            String string4 = this.getStringProperty(string3, "");
            if (bl) {
                nonBlockingProperties.put(string3.substring(string2.length()), string4);
                continue;
            }
            nonBlockingProperties.put(string3, string4);
        }
        return nonBlockingProperties;
    }
}

