/*
 * Decompiled with CFR 0.152.
 */
package com.helger.quartz.utils.counter.sampled;

import com.helger.commons.ValueEnforcer;
import com.helger.quartz.utils.counter.CounterConfig;
import com.helger.quartz.utils.counter.ICounter;
import com.helger.quartz.utils.counter.sampled.SampledCounter;

public class SampledCounterConfig
extends CounterConfig {
    private final int m_nIntervalSecs;
    private final int m_nHistorySize;
    private final boolean m_bIsReset;

    public SampledCounterConfig(int n, int n2, boolean bl, long l) {
        super(l);
        ValueEnforcer.isGT0(n, "Interval");
        ValueEnforcer.isGT0(n2, "HistorySize");
        this.m_nIntervalSecs = n;
        this.m_nHistorySize = n2;
        this.m_bIsReset = bl;
    }

    public int getHistorySize() {
        return this.m_nHistorySize;
    }

    public int getIntervalSecs() {
        return this.m_nIntervalSecs;
    }

    public boolean isResetOnSample() {
        return this.m_bIsReset;
    }

    @Override
    public ICounter createCounter() {
        return new SampledCounter(this);
    }
}

