/*
 * Decompiled with CFR 0.152.
 */
package com.helger.schedule.job;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.callback.CallbackList;
import com.helger.commons.state.ESuccess;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedTimer;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.timing.StopWatch;
import com.helger.quartz.IJob;
import com.helger.quartz.IJobExecutionContext;
import com.helger.quartz.JobDataMap;
import com.helger.quartz.JobExecutionException;
import com.helger.schedule.job.IJobExceptionCallback;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractJob
implements IJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractJob.class);
    private static final IMutableStatisticsHandlerKeyedTimer s_aStatsTimer = StatisticsManager.getKeyedTimerHandler(AbstractJob.class);
    private static final IMutableStatisticsHandlerKeyedCounter s_aStatsCounterSuccess = StatisticsManager.getKeyedCounterHandler(AbstractJob.class + "$success");
    private static final IMutableStatisticsHandlerKeyedCounter s_aStatsCounterFailure = StatisticsManager.getKeyedCounterHandler(AbstractJob.class + "$failure");
    private static final CallbackList<IJobExceptionCallback> s_aExceptionCallbacks = new CallbackList();

    @Nonnull
    @ReturnsMutableObject
    public static CallbackList<IJobExceptionCallback> exceptionCallbacks() {
        return s_aExceptionCallbacks;
    }

    @OverrideOnDemand
    protected void beforeExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext) {
    }

    @OverrideOnDemand
    protected abstract void onExecute(@Nonnull JobDataMap var1, @Nonnull IJobExecutionContext var2) throws JobExecutionException;

    @OverrideOnDemand
    protected void afterExecute(@Nonnull JobDataMap jobDataMap, @Nonnull IJobExecutionContext iJobExecutionContext, @Nonnull ESuccess eSuccess) {
    }

    protected static void triggerCustomExceptionHandler(@Nonnull Throwable throwable, @Nullable String string, @Nonnull IJob iJob) {
        AbstractJob.exceptionCallbacks().forEach(iJobExceptionCallback -> iJobExceptionCallback.onScheduledJobException(throwable, string, iJob));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void execute(@Nonnull IJobExecutionContext iJobExecutionContext) throws JobExecutionException {
        ESuccess eSuccess = ESuccess.FAILURE;
        JobDataMap jobDataMap = new JobDataMap(iJobExecutionContext.getMergedJobDataMap());
        this.beforeExecute(jobDataMap, iJobExecutionContext);
        try {
            String string = this.getClass().getName();
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Executing scheduled job " + string);
                }
                StopWatch stopWatch = StopWatch.createdStarted();
                this.onExecute(jobDataMap, iJobExecutionContext);
                eSuccess = ESuccess.SUCCESS;
                s_aStatsTimer.addTime(string, stopWatch.stopAndGetMillis());
                s_aStatsCounterSuccess.increment(string);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Successfully finished executing scheduled job " + string);
                }
            }
            catch (Exception exception) {
                s_aStatsCounterFailure.increment(string);
                AbstractJob.triggerCustomExceptionHandler(exception, string, this);
                if (exception instanceof JobExecutionException) {
                    throw (JobExecutionException)exception;
                }
                throw new JobExecutionException("Internal job execution error of " + string, exception);
            }
        }
        finally {
            this.afterExecute(jobDataMap, iJobExecutionContext, eSuccess);
        }
    }
}

